/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.mservice.paywriteback;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class TransferApplyPayBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static final Log LOGGER = LogFactory.getLog(TransferApplyPayBillWriteBackService.class);

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        LOGGER.info("doSaveValidateExecute begin");
        super.doSaveValidateExecute(param, sourceBill);
        String entityName = sourceBill.getDataEntityType().getDisplayName().getLocaleValue();
        if (!"C".equals(sourceBill.getString("billstatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u7684\u6e90\u5355[%2$s]\u4ed8\u6b3e\u72b6\u6001\u987b\u7b49\u4e8e\u5df2\u5ba1\u6838\u3002", (String)"TransferApplyPayBillWriteBackService_0", (String)"tmc-fca-mservice", (Object[])new Object[0]), entityName, sourceBill.getString("billno")));
        }
        if (sourceBill.getBoolean("invalidflag")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u7684\u6e90\u5355[%2$s]\u5df2\u4f5c\u5e9f\u3002", (String)"TransferApplyPayBillWriteBackService_1", (String)"tmc-fca-mservice", (Object[])new Object[0]), entityName, sourceBill.getString("billno")));
        }
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((Object)payBillInfo.getSourceBillId(), (String)"cas_transferapply", (String)"id, billno, billstatus, invalidflag, payeecurrency, cas_transferapply_entry.e_payeeamount");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("payeecurrency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject dynamicObject) {
        return null;
    }

    protected BigDecimal getSourceBillPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObjectCollection entries = sourceBill.getDynamicObjectCollection("cas_transferapply_entry");
        Optional<DynamicObject> entry = entries.stream().filter(e -> Objects.equals(e.getPkValue(), param.getPayBill().getSourceBillEntryId())).findFirst();
        if (entry.isPresent()) {
            return entry.get().getBigDecimal("e_payeeamount");
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal getSourceBillLockPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        QFilter filter = new QFilter("entry.e_sourcebillentryid", "=", (Object)param.getPayBill().getSourceBillEntryId());
        filter = filter.and("id", "<>", (Object)param.getPayBill().getPayBillId());
        DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.e_actamt", (QFilter[])filter.toArray());
        return paybills.stream().map(p -> p.getBigDecimal("entry.e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

