/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.compare;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import kd.tmc.fca.common.compare.BPlusTreeNode;

public class BPlusTree<K extends Comparable<K>, V> {
    private int maxKeys = 64;
    private BPlusTreeNode<K, V> root;

    public BPlusTree(int degree) {
        this.maxKeys = degree;
        this.root = new BPlusTreeNode(true);
    }

    public BPlusTree() {
        this.root = new BPlusTreeNode(true);
    }

    public BPlusTreeNode<K, V> getRoot() {
        return this.root;
    }

    public void insert(K key, V value) {
        BPlusTreeNode<K, V> root = this.root;
        if (root.entries.size() == this.maxKeys) {
            BPlusTreeNode newRoot = new BPlusTreeNode(false);
            newRoot.children.add(root);
            this.splitChild(newRoot, 0, root);
            this.root = newRoot;
        }
        this.insertNonFull(this.root, key, value);
    }

    public List<V> search(K key) {
        return this.search(this.root, key);
    }

    private void splitChild(BPlusTreeNode<K, V> parent, int i, BPlusTreeNode<K, V> fullNode) {
        BPlusTreeNode newNode = new BPlusTreeNode(fullNode.isLeaf);
        int midIndex = this.maxKeys / 2;
        parent.entries.add(i, fullNode.entries.get(midIndex));
        parent.children.add(i + 1, newNode);
        newNode.entries.addAll(fullNode.entries.subList(midIndex + 1, fullNode.entries.size()));
        fullNode.entries.subList(midIndex, fullNode.entries.size()).clear();
        if (!fullNode.isLeaf) {
            newNode.children.addAll(fullNode.children.subList(midIndex + 1, fullNode.children.size()));
            fullNode.children.subList(midIndex + 1, fullNode.children.size()).clear();
        }
        if (fullNode.isLeaf) {
            newNode.next = fullNode.next;
            fullNode.next = newNode;
        }
    }

    private void insertNonFull(BPlusTreeNode<K, V> node, K key, V value) {
        if (node.isLeaf) {
            int i;
            for (i = 0; i < node.entries.size() && key.compareTo(node.entries.get(i).getKey()) > 0; ++i) {
            }
            if (i < node.entries.size() && key.equals(node.entries.get(i).getKey())) {
                node.entries.get(i).getValue().add(value);
            } else {
                ArrayList<V> values = new ArrayList<V>();
                values.add(value);
                node.entries.add(i, new AbstractMap.SimpleEntry(key, values));
            }
        } else {
            int i;
            for (i = node.entries.size() - 1; i >= 0 && key.compareTo(node.entries.get(i).getKey()) < 0; --i) {
            }
            BPlusTreeNode child = node.children.get(++i);
            if (child.entries.size() == this.maxKeys) {
                this.splitChild(node, i, child);
                if (key.compareTo(node.entries.get(i).getKey()) > 0) {
                    ++i;
                }
            }
            this.insertNonFull(node.children.get(i), key, value);
        }
    }

    private List<V> search(BPlusTreeNode<K, V> node, K key) {
        int i;
        for (i = 0; i < node.entries.size() && key.compareTo(node.entries.get(i).getKey()) > 0; ++i) {
        }
        if (i < node.entries.size() && key.equals(node.entries.get(i).getKey())) {
            return node.entries.get(i).getValue();
        }
        if (node.isLeaf) {
            return new ArrayList();
        }
        return this.search(node.children.get(i), key);
    }

    public void printTree() {
        this.printNode(this.root, 0);
    }

    private void printNode(BPlusTreeNode<K, V> node, int level) {
        System.out.println("Level " + level + " " + node.entries);
        if (!node.isLeaf) {
            for (BPlusTreeNode child : node.children) {
                this.printNode(child, level + 1);
            }
        }
    }
}

