/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.compare;

import java.math.BigDecimal;
import java.util.Objects;
import kd.tmc.fca.common.enums.SymbolEnum;

public class CompareData {
    private Object id;
    private final String fieldKey;
    private final Object fieldValue;
    private final Object displayName;
    private final SymbolEnum symbolEnum;
    private boolean isCheckSource = false;

    public Object getId() {
        return this.id;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public SymbolEnum getSymbolEnum() {
        return this.symbolEnum;
    }

    public Object getDisplayName() {
        return this.displayName;
    }

    public boolean isCheckSource() {
        return this.isCheckSource;
    }

    public CompareData(String fieldKey, Object fieldValue) {
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.symbolEnum = SymbolEnum.EQUALS;
        this.displayName = String.valueOf(fieldValue);
    }

    public CompareData(Object id, String fieldKey, Object fieldValue) {
        this.id = id;
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.symbolEnum = SymbolEnum.EQUALS;
        this.displayName = String.valueOf(fieldValue);
    }

    public CompareData(String fieldKey, Object fieldValue, Object displayName) {
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.symbolEnum = SymbolEnum.EQUALS;
    }

    public CompareData(Object id, String fieldKey, Object fieldValue, SymbolEnum symbolEnum) {
        this.id = id;
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.symbolEnum = symbolEnum;
        this.displayName = String.valueOf(fieldValue);
    }

    public CompareData(Object id, String fieldKey, Object fieldValue, Object displayName, boolean isCheckSource) {
        this.id = id;
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.symbolEnum = SymbolEnum.EQUALS;
        this.isCheckSource = isCheckSource;
    }

    public CompareData(Object id, String fieldKey, Object fieldValue, Object displayName, SymbolEnum symbolEnum) {
        this.id = id;
        this.fieldKey = fieldKey;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.symbolEnum = symbolEnum;
    }

    public boolean equals(Object obj) {
        CompareData compareData;
        if (obj instanceof CompareData && Objects.equals((compareData = (CompareData)obj).getFieldKey(), this.fieldKey) && this.fieldValue != null && compareData.fieldValue != null && this.fieldValue.getClass() == compareData.fieldValue.getClass()) {
            if (this.symbolEnum == SymbolEnum.EQUALS) {
                if (this.fieldValue instanceof BigDecimal) {
                    return ((BigDecimal)this.fieldValue).compareTo((BigDecimal)compareData.fieldValue) == 0;
                }
                return Objects.equals(compareData.fieldValue, this.fieldValue);
            }
            if (this.symbolEnum == SymbolEnum.LESS_EQUALS) {
                if (this.fieldValue instanceof BigDecimal) {
                    return ((BigDecimal)this.fieldValue).compareTo((BigDecimal)compareData.fieldValue) <= 0;
                }
                if (this.fieldValue instanceof Number) {
                    return ((Number)this.fieldValue).doubleValue() <= ((Number)compareData.fieldValue).doubleValue();
                }
            } else if (this.symbolEnum == SymbolEnum.LESS_THEN) {
                if (this.fieldValue instanceof BigDecimal) {
                    return ((BigDecimal)this.fieldValue).compareTo((BigDecimal)compareData.fieldValue) < 0;
                }
                if (this.fieldValue instanceof Number) {
                    return ((Number)this.fieldValue).doubleValue() < ((Number)compareData.fieldValue).doubleValue();
                }
            }
        }
        return false;
    }

    public String toString() {
        return "CompareData{id=" + this.id + ", fieldKey='" + this.fieldKey + '\'' + ", fieldValue=" + this.fieldValue + ", displayName='" + this.displayName + '\'' + ", symbolEnum=" + (Object)((Object)this.symbolEnum) + ", isCheckSource=" + this.isCheckSource + '}';
    }
}

