/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.compare;

import java.util.List;
import java.util.Map;
import kd.tmc.fca.common.compare.BPlusTree;
import kd.tmc.fca.common.compare.BPlusTreeNode;
import kd.tmc.fca.common.compare.CompareData;
import kd.tmc.fca.common.compare.CompareResult;
import kd.tmc.fca.common.compare.CompareService;

public class CompareServiceImpl
implements CompareService {
    private final BPlusTree<Long, CompareData> sourceTree;
    private final BPlusTree<Long, CompareData> targetTree;
    private final BPlusTree<Long, CompareResult> resultTree;

    public CompareServiceImpl(BPlusTree<Long, CompareData> sourceTree, BPlusTree<Long, CompareData> targetTree) {
        this.sourceTree = sourceTree;
        this.targetTree = targetTree;
        this.resultTree = new BPlusTree(64);
    }

    @Override
    public BPlusTree<Long, CompareResult> invoke() {
        this.compareNode(this.targetTree.getRoot());
        return this.resultTree;
    }

    private void compareNode(BPlusTreeNode<Long, CompareData> node) {
        if (!node.isLeaf) {
            for (BPlusTreeNode<Long, CompareData> bPlusTreeNode : node.children) {
                this.compareNode(bPlusTreeNode);
            }
        } else {
            List entries = node.entries;
            for (Map.Entry entry : entries) {
                List targets = entry.getValue();
                List<CompareData> sources = this.sourceTree.search((Long)((Comparable)entry.getKey()));
                if (sources == null) continue;
                for (CompareData target : targets) {
                    for (CompareData source : sources) {
                        if (!target.getFieldKey().equals(source.getFieldKey()) || target.equals(source)) continue;
                        CompareResult compareResult = target.isCheckSource() ? new CompareResult(target.getId(), source.getFieldKey(), target.getDisplayName(), target.getSymbolEnum(), true) : new CompareResult(target.getId(), source.getFieldKey(), source.getDisplayName(), target.getSymbolEnum());
                        this.resultTree.insert((Long)((Comparable)entry.getKey()), compareResult);
                    }
                }
            }
        }
    }
}

