/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.convert.AbstractBillConverter;
import kd.tmc.fca.common.helper.CodeRuleHelper;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPayStatusChangeHelper;

public class BankTransBillConverter
extends AbstractBillConverter {
    private static Map<String, String> fieldMapper = new HashMap<String, String>();
    private DynamicObject transBill;
    private String transBillName;
    private String bankTransBillName;

    public BankTransBillConverter(DynamicObject transBill) {
        String transBillName = transBill.getDataEntityType().getName();
        String bankTransBillName = TransBillHelper.getBankTransBillEntity(transBill);
        this.transBill = transBill;
        this.transBillName = transBillName;
        this.bankTransBillName = bankTransBillName;
    }

    public DynamicObject getTransBill() {
        return this.transBill;
    }

    public DynamicObject convertToTargetBill() {
        String currUser = RequestContext.get().getUserId();
        Date currDate = new Date();
        DynamicObject bankTransBill = this.convertToTargetBill(this.transBill);
        bankTransBill.set("billno", (Object)CodeRuleHelper.generateNumber(this.bankTransBillName, bankTransBill, null, null));
        bankTransBill.set("bizdate", (Object)currDate);
        bankTransBill.set("creator", (Object)currUser);
        bankTransBill.set("createtime", (Object)currDate);
        bankTransBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        bankTransBill.set("auditdate", (Object)currDate);
        bankTransBill.set("auditor", (Object)currUser);
        bankTransBill.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
        String sourceEntityKey = this.getSourceEntityKey();
        String remark = StringUtils.equals((CharSequence)sourceEntityKey, (CharSequence)"fca_transupbill") ? ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"BankTransBillConverter_0", (String)"tmc-fca-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"BankTransBillConverter_1", (String)"tmc-fca-common", (Object[])new Object[0]);
        DynamicObjectCollection entry = bankTransBill.getDynamicObjectCollection("entrys");
        ArrayList<DynamicObject> waitRemoveEntryList = new ArrayList<DynamicObject>();
        DynamicObjectCollection sourceEntries = this.transBill.getDynamicObjectCollection("entrys");
        List canSubmitTransBillEntryIdList = sourceEntries.stream().filter(TransBillPayStatusChangeHelper::transBillDetailCanCommitBei).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            row.set("remark", (Object)remark);
            boolean canCommit = canSubmitTransBillEntryIdList.contains(row.getLong("sourceentryid"));
            if (!canCommit) {
                waitRemoveEntryList.add(row);
                continue;
            }
            row.set("status", (Object)BeBillStatusEnum.OP.getValue());
            totalAmount = totalAmount.add(row.getBigDecimal("transamt"));
        }
        entry.removeAll(waitRemoveEntryList);
        if (entry.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b63\u5e38\u4e14\u4ed8\u6b3e\u6210\u529f/\u88ab\u6253\u56de\u4e14\u4ed8\u6b3e\u5931\u8d25\u90e8\u5206\u7684\u5212\u62e8\u5355\u5206\u5f55\u3002", (String)"BankTransBillConverter_2", (String)"tmc-fca-common", (Object[])new Object[0]));
        }
        bankTransBill.set("count", (Object)entry.size());
        bankTransBill.set("amount", (Object)totalAmount);
        return bankTransBill;
    }

    @Override
    public String getSourceEntityKey() {
        return this.transBillName;
    }

    @Override
    public String getTargetEntityKey() {
        return this.bankTransBillName;
    }

    @Override
    public String getTargetField(String sourceField) {
        return fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return fieldMapper;
    }

    @Override
    public List<String> getGroupFields() {
        ArrayList<String> groupByFields = new ArrayList<String>();
        groupByFields.add("id");
        return groupByFields;
    }

    static {
        fieldMapper.put("company", "company");
        fieldMapper.put("bank", "bank");
        fieldMapper.put("accountbank", "accountbank");
        fieldMapper.put("currency", "currency");
        fieldMapper.put("exchangerate", "exchangerate");
        fieldMapper.put("locamt", "locamt");
        fieldMapper.put("billno", "transbillno");
        fieldMapper.put("id", "sourcebillid");
        fieldMapper.put("subacct", "subacct");
        fieldMapper.put("transamt", "transamt");
        fieldMapper.put("entrys.id", "sourceentryid");
    }
}

