/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.service.model.BalanceModelService;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.SystemParameterHelper;
import kd.tmc.fca.common.helper.TransBillPayStatusChangeHelper;

public class AcctBalShowHelper {
    private static Log logger = LogFactory.getLog(TransBillPayStatusChangeHelper.class);

    public static FormShowParameter create(String entityKey, DynamicObject acct, long currencyId, long orgId) {
        logger.info("AcctBalShowHelper create begin");
        FormShowParameter showPara = new FormShowParameter();
        showPara.setFormId("fca_bankacctbal");
        showPara.setCustomParam("currency", (Object)currencyId);
        if (null != acct) {
            DynamicObject bankAcct = null;
            String acctType = acct.getDataEntityType().getName();
            if (acctType.equals("ifm_inneracct")) {
                bankAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)acct);
            } else if (acctType.equals("bd_accountbanks")) {
                bankAcct = acct;
            }
            if (null != bankAcct) {
                Long bankacctId = bankAcct.getLong("id");
                showPara.setCustomParam("bankAcct", (Object)bankacctId);
                String balanceType = SystemParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
                BalanceModelService balanceModelService = new BalanceModelService();
                BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId);
                BigDecimal currentBalance = bizBalanceModelBean.getAmount();
                BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount(entityKey, bankAcct, currencyId, orgId, 0L, currentBalance);
                logger.info("AcctBalShowHelper create usableBalance\uff1a", (Object)usableBalance);
                showPara.setCustomParam("valbalance", (Object)usableBalance);
                showPara.setCustomParam("curbalance", (Object)currentBalance);
            }
        }
        showPara.getOpenStyle().setShowType(ShowType.Modal);
        return showPara;
    }
}

