/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillPayStatusChangeHelper {
    private static final Log LOGGER = LogFactory.getLog(TransBillPayStatusChangeHelper.class);

    public static boolean transBillDetailCanCommitBei(DynamicObject entry) {
        String state = (String)entry.get("state");
        String payStatus = (String)entry.get("paystatus");
        String paychanel = (String)entry.get("paychanel");
        return !(!FcaTransDetailStatusEnum.NORMAL.getValue().equals(state) && !FcaTransDetailStatusEnum.BACK.getValue().equals(state) || !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) || !FcaTransPayChanEnum.BEI.getValue().equals(paychanel));
    }

    public static void beiBitBack(Long id, String entryName) {
        LOGGER.info("TransBillPayStatusChangeHelper beiBitBack id:{},entryName:{}", (Object)id, (Object)entryName);
        DynamicObject tranBill = TmcDataServiceHelper.loadSingle((Object)id, (String)entryName);
        if (tranBill == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"ID:[%1$  %2$]\uff0c\u5bf9\u5e94\u7684\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"TransBillPayStatusChangeHelper_0", (String)"tmc-fca-common", (Object[])new Object[0]), id, entryName));
        }
        DynamicObjectCollection entries = tranBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entries) {
            String state = (String)entry.get("state");
            String payStatus = (String)entry.get("paystatus");
            String paychanel = (String)entry.get("paychanel");
            if (!FcaTransPayChanEnum.BEI.getValue().equals(paychanel) || FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) || !FcaTransDetailStatusEnum.NORMAL.getValue().equals(state)) continue;
            if (!FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u662f\u6700\u7ec8\u4ed8\u6b3e\u72b6\u6001\u7684\u5355\u636e\u65e0\u6cd5\u6253\u56de\u3002", (String)"TransBillPayStatusChangeHelper_1", (String)"tmc-fca-common", (Object[])new Object[0]), new Object[0]));
            }
            entry.set("state", (Object)FcaTransDetailStatusEnum.BACK.getValue());
            tranBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)entryName, (DynamicObject[])new DynamicObject[]{tranBill}, (OperateOption)OperateOption.create());
        }
    }
}

