/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.common.helper.overdraft;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.AmtValidateHelper;
import kd.tmc.fca.common.helper.overdraft.AcctOverDraftCommValidatorFacade;
import kd.tmc.fca.common.helper.overdraft.ValidatorResult;
import kd.tmc.fca.common.helper.overdraft.ValidatorResultInfo;
import kd.tmc.fca.common.util.AmtUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AcctOverDraftCommValidatorImpl
implements AcctOverDraftCommValidatorFacade {
    @Override
    public ValidatorResult availableBalanceAndQuotaValidator(Long acctId, Long currencyId, BigDecimal amount, String action) {
        ValidatorResultInfo resultQuotaOnSingle;
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks");
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        ValidatorResult result = new ValidatorResult();
        Boolean isControl = this.isControl(bankStratg, action);
        if (!isControl.booleanValue()) {
            return result;
        }
        ValidatorResultInfo resultAvailableBalance = this.availableBalanceValidator_(bankAcct, currency, bankStratg, amount, action);
        if (resultAvailableBalance.isError()) {
            return result.addErrorResult(resultAvailableBalance);
        }
        if (resultAvailableBalance.isConfirm()) {
            result.addConfirmResult(resultAvailableBalance);
        }
        if ((resultQuotaOnSingle = this.quotaOnSingleValidator_(bankAcct, currency, bankStratg, amount, action)).isError()) {
            return result.addErrorResult(resultQuotaOnSingle);
        }
        ValidatorResultInfo resultQuotaOnDay = this.quotaOnDayValidator_(bankAcct, currency, bankStratg, amount, action);
        if (resultQuotaOnDay.isError()) {
            return result.addErrorResult(resultQuotaOnDay);
        }
        ValidatorResultInfo resultQuotaOnMonth = this.quotaOnMonthValidator_(bankAcct, currency, bankStratg, amount, action);
        if (resultQuotaOnMonth.isError()) {
            return result.addErrorResult(resultQuotaOnMonth);
        }
        if (resultQuotaOnSingle.isConfirm()) {
            result.addConfirmResult(resultQuotaOnSingle);
        }
        if (resultQuotaOnDay.isConfirm()) {
            result.addConfirmResult(resultQuotaOnDay);
        }
        if (resultQuotaOnMonth.isConfirm()) {
            result.addConfirmResult(resultQuotaOnMonth);
        }
        return result;
    }

    @Override
    public ValidatorResultInfo availableBalanceValidator(Long acctId, Long currencyId, BigDecimal amount, String action) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks");
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        return this.availableBalanceValidator_(bankAcct, currency, bankStratg, amount, action);
    }

    private ValidatorResultInfo availableBalanceValidator_(DynamicObject bankAcct, DynamicObject currency, DynamicObject bankStratg, BigDecimal amount, String action) {
        Boolean isControl = this.isControl(bankStratg, action);
        if (!isControl.booleanValue()) {
            return ValidatorResultInfo.makeSuccResult();
        }
        Pair<AmtValidateHelper.ValidStatus, String> result = AmtValidateHelper.isValid(bankAcct, amount, currency, null, this.isPayAction(action));
        return new ValidatorResultInfo(((AmtValidateHelper.ValidStatus)((Object)result.getLeft())).getValue(), (String)result.getRight());
    }

    @Override
    public ValidatorResultInfo quotaOnSingleValidator(Long acctId, Long currencyId, BigDecimal amount, String action) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks");
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        return this.quotaOnSingleValidator_(bankAcct, currency, bankStratg, amount, action);
    }

    private ValidatorResultInfo quotaOnSingleValidator_(DynamicObject bankAcct, DynamicObject currency, DynamicObject bankStratg, BigDecimal amount, String action) {
        if (bankStratg == null) {
            return ValidatorResultInfo.makeSuccResult();
        }
        Boolean isControl = this.isControl(bankStratg, action);
        if (!isControl.booleanValue()) {
            return ValidatorResultInfo.makeSuccResult();
        }
        if (!this.isPayLimit(bankStratg)) {
            return ValidatorResultInfo.makeSuccResult();
        }
        String currencySign = currency.getString("sign");
        BigDecimal singlelimit = bankStratg.getBigDecimal("singlelimit");
        if (BigDecimal.ZERO.compareTo(singlelimit) == 0) {
            return ValidatorResultInfo.makeSuccResult();
        }
        int amtprecision = currency.getInt("amtprecision");
        if (amount.compareTo(singlelimit) > 0) {
            return ValidatorResultInfo.makeErrorResult(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff0c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\uff08%1$s\uff09\u5927\u4e8e\u5355\u7b14\u9650\u989d\uff08%2$s\uff09\u3002", (String)"AcctOverDraftCommValidatorImpl_0", (String)"tmc-fca-common", (Object[])new Object[0]), AmtUtil.getFormatAmt(amount, currencySign, amtprecision), AmtUtil.getFormatAmt(singlelimit, currencySign, amtprecision)));
        }
        return ValidatorResultInfo.makeSuccResult();
    }

    @Override
    public ValidatorResultInfo quotaOnDayValidator(Long acctId, Long currencyId, BigDecimal amount, String action) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks");
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        return this.quotaOnDayValidator_(bankAcct, currency, bankStratg, amount, action);
    }

    @Override
    public ValidatorResultInfo quotaOnMonthValidator(Long acctId, Long currencyId, BigDecimal amount, String action) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks");
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        DynamicObject bankStratg = AmtCalcHelper.getAcctStratg(bankAcct, currencyId);
        return this.quotaOnMonthValidator_(bankAcct, currency, bankStratg, amount, action);
    }

    private ValidatorResultInfo quotaOnDayValidator_(DynamicObject bankAcct, DynamicObject currency, DynamicObject bankStratg, BigDecimal amount, String action) {
        if (bankStratg == null) {
            return ValidatorResultInfo.makeSuccResult();
        }
        Boolean isControl = this.isControl(bankStratg, action);
        if (!isControl.booleanValue()) {
            return ValidatorResultInfo.makeSuccResult();
        }
        if (!this.isPayLimit(bankStratg)) {
            return ValidatorResultInfo.makeSuccResult();
        }
        BigDecimal dailylimit = bankStratg.getBigDecimal("dailylimit");
        if (BigDecimal.ZERO.compareTo(dailylimit) == 0) {
            return ValidatorResultInfo.makeSuccResult();
        }
        String currencySign = currency.getString("sign");
        Date startTime = DateUtils.parseDate((Object)DateUtils.getDate((String)"yyyy-MM-dd"));
        Date endTime = new Date();
        BigDecimal paybillAmt = AmtCalcHelper.getPayBillPayAmt((Long)bankAcct.getPkValue(), (Long)currency.getPkValue(), startTime, endTime);
        BigDecimal agentPaybillAmt = CasBusinessHelper.getAgentPayBillPayAmt((long)((Long)bankAcct.getPkValue()), (long)((Long)currency.getPkValue()), (Date)startTime, (Date)endTime);
        BigDecimal dayPayedAmt = paybillAmt.add(agentPaybillAmt);
        int amtprecision = currency.getInt("amtprecision");
        if (dayPayedAmt.add(amount).compareTo(dailylimit) > 0) {
            return ValidatorResultInfo.makeErrorResult(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff0c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\uff08%1$s\uff09+\u65e5\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\uff08%2$s\uff09 \u5927\u4e8e \u65e5\u9650\u989d\uff08%3$s\uff09\u3002", (String)"AcctOverDraftCommValidatorImpl_1", (String)"tmc-fca-common", (Object[])new Object[0]), AmtUtil.getFormatAmt(amount, currencySign, amtprecision), AmtUtil.getFormatAmt(dayPayedAmt, currencySign, amtprecision), AmtUtil.getFormatAmt(dailylimit, currencySign, amtprecision)));
        }
        return ValidatorResultInfo.makeSuccResult();
    }

    private ValidatorResultInfo quotaOnMonthValidator_(DynamicObject bankAcct, DynamicObject currency, DynamicObject bankStratg, BigDecimal amount, String action) {
        if (bankStratg == null) {
            return ValidatorResultInfo.makeSuccResult();
        }
        if (!this.isPayLimit(bankStratg)) {
            return ValidatorResultInfo.makeSuccResult();
        }
        Boolean isControl = this.isControl(bankStratg, action);
        if (!isControl.booleanValue()) {
            return ValidatorResultInfo.makeSuccResult();
        }
        BigDecimal monthlylimit = bankStratg.getBigDecimal("monthlylimit");
        if (BigDecimal.ZERO.compareTo(monthlylimit) == 0) {
            return ValidatorResultInfo.makeSuccResult();
        }
        String acctNum = bankAcct.getString("bankaccountnumber");
        String currencySign = currency.getString("sign");
        Date startTime = DateUtils.parseDate((Object)DateUtils.getFirstDayOfMonth());
        Date endTime = new Date();
        BigDecimal paybillAmt = AmtCalcHelper.getPayBillPayAmt((Long)bankAcct.getPkValue(), (Long)currency.getPkValue(), startTime, endTime);
        BigDecimal agentPaybillAmt = CasBusinessHelper.getAgentPayBillPayAmt((long)((Long)bankAcct.getPkValue()), (long)((Long)currency.getPkValue()), (Date)startTime, (Date)endTime);
        BigDecimal monthPayedAmt = paybillAmt.add(agentPaybillAmt);
        int amtprecision = currency.getInt("amtprecision");
        if (monthPayedAmt.add(amount).compareTo(monthlylimit) > 0) {
            return ValidatorResultInfo.makeErrorResult(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff0c\u672c\u6b21\u4ed8\u6b3e\u91d1\u989d\uff08%1$s\uff09+\u6708\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\uff08%2$s\uff09 \u5927\u4e8e \u6708\u9650\u989d\uff08%3$s\uff09\u3002", (String)"AcctOverDraftCommValidatorImpl_2", (String)"tmc-fca-common", (Object[])new Object[0]), AmtUtil.getFormatAmt(amount, currencySign, amtprecision), AmtUtil.getFormatAmt(monthPayedAmt, currencySign, amtprecision), AmtUtil.getFormatAmt(monthlylimit, currencySign, amtprecision)));
        }
        return ValidatorResultInfo.makeSuccResult();
    }

    private Boolean isControl(DynamicObject bankStratg, String action) {
        if (bankStratg == null) {
            return Boolean.FALSE;
        }
        Boolean enable = bankStratg.getBoolean("enable");
        if (!enable.booleanValue()) {
            return Boolean.FALSE;
        }
        String isControl = null;
        isControl = this.isPayAction(action) ? bankStratg.getString("ispay") : bankStratg.getString("issubmit");
        if ("1".equals(isControl) || "true".equals(isControl)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isPayLimit(DynamicObject bankStratg) {
        if (bankStratg == null) {
            return false;
        }
        String isPayLimit = bankStratg.getString("ispaylimit");
        return "1".equals(isPayLimit) || "true".equals(isPayLimit);
    }
}

