/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.acctgroup;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.constant.FcaBizConstant;
import kd.tmc.fca.common.enums.FcaAcctControlModelEnum;
import kd.tmc.fca.common.enums.FcaOperNameEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;
import kd.tmc.fca.common.helper.AcctGroupRelInnerAcctHelper;

public class AcctGroupEdit
extends AbstractBasePlugIn
implements RowClickEventListener {
    public static final String CHANGE_COMPANY_CALLBACK = "CHANGE_COMPANY_CALLBACK";
    public static final String CHANGE_COMPANY_CALLBACK_OLD = "CHANGE_COMPANY_CALLBACK_OLD ";
    public static final String CHANGE_ACCOUNT_BANK_CALLBACK = "CHANGE_ACCOUNTBANK_CALLBACK";
    public static final String CHANGE_ACCOUNT_BANK_CALLBACK_OLD = "CHANGE_ACCOUNTBANK_CALLBACK_OLD";
    public static final String CHANGE_CURRENCY_CALLBACK = "CHANGE_CURRENCY_CALLBACK";
    public static final String CHANGE_CURRENCY_CALLBACK_OLD = "CHANGE_CURRENCY_CALLBACK_OLD";
    public static final String CONFIRM_CLEAN_CALLBACK = "CONFIRM_CLEAN_CALLBACK";
    public static final String CHOOSE_WHICHENTRY = "CHOOSE_WHICHENTRY";
    public static final String ISAUTOADDROW = "isautoaddrow";
    public static final String STRATEGY = "strategy";
    public static final String AUTOUP = "autoup";
    public static final String AUTODOWN = "autodown";
    public static final String AUTO = "auto";
    private static final Log LOGGER = LogFactory.getLog(AcctGroupEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List<Object> acctcompanyIdList = this.getAuthAcctList().stream().map(o -> o.get("company")).distinct().collect(Collectors.toList());
        DynamicObject bankacct = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"company", evt -> {
            if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
                FormShowParameter sp = evt.getFormShowParameter();
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_COMPANY_CALLBACK));
            }
            return new QFilter("id", "in", (Object)acctcompanyIdList);
        });
        BasedataEdit companyF7 = (BasedataEdit)this.getView().getControl("company");
        companyF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = company != null ? company.getPkValue().toString() : "";
            boolean isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            LOGGER.info("isChange:{},returnData:{},pk:{}", new Object[]{isChange, returnData, pk});
            if (isChange) {
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_COMPANY_CALLBACK);
            }
        });
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"accountbank", evt -> {
            if (company == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"AcctGroupEdit_0", (String)"tmc-fca-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return null;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)bankacct)) {
                FormShowParameter sp = evt.getFormShowParameter();
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_ACCOUNT_BANK_CALLBACK));
            }
            return new QFilter("company", "=", (Object)company.getLong("id")).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and("isvirtual", "=", (Object)"0");
        });
        BasedataEdit accountBankF7 = (BasedataEdit)this.getView().getControl("accountbank");
        accountBankF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            boolean isChange;
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = bankacct != null ? bankacct.getPkValue().toString() : "";
            boolean bl = isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            if (isChange) {
                this.getPageCache().put(CHANGE_ACCOUNT_BANK_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_ACCOUNT_BANK_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_ACCOUNT_BANK_CALLBACK);
            }
        });
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"currency", evt -> {
            if (bankacct == null) {
                this.getView().showTipNotification(new FcaBizConstant().getChooseAcctFirst());
                evt.setCancel(true);
                return null;
            }
            if (currency != null) {
                FormShowParameter sp = evt.getFormShowParameter();
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_CURRENCY_CALLBACK));
            }
            DynamicObjectCollection currencies = (DynamicObjectCollection)bankacct.get("currency");
            ArrayList<Long> currencyId = new ArrayList<Long>(currencies.size());
            for (DynamicObject curr : currencies) {
                currencyId.add(curr.getLong("fbasedataid.id"));
            }
            return new QFilter("id", "in", currencyId);
        });
        BasedataEdit currencyF7 = (BasedataEdit)this.getView().getControl("currency");
        currencyF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            boolean isChange;
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = currency != null ? currency.getPkValue().toString() : "";
            boolean bl = isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            if (isChange) {
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_CURRENCY_CALLBACK);
            }
        });
        if (EmptyUtil.isNoEmpty((DynamicObject)currency) && EmptyUtil.isNoEmpty((DynamicObject)company) && !EmptyUtil.isEmpty((DynamicObject)bankacct)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"entrys"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"tbl_in"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"tbl_out"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"tbl_inout"});
            Long currId = (Long)currency.getPkValue();
            Long nowacctId = (Long)bankacct.getPkValue();
            List<Long> acctId = this.acctCurrency(acctcompanyIdList, currId);
            QFilter accountFilter = new QFilter("company", "in", acctcompanyIdList).and("id", "in", acctId).and("id", "!=", (Object)nowacctId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()).and("isvirtual", "=", (Object)"0");
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"bankacct", evt -> {
                evt.getFormShowParameter().setCustomParam("isclearcorefilter", (Object)"true");
                return accountFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"bankacct_in", evt -> {
                evt.getFormShowParameter().setCustomParam("isclearcorefilter", (Object)"true");
                return accountFilter.and("accttype", "in", (Object)new String[]{AcctTypeEnum.IN.getValue()});
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"bankacct_out", evt -> {
                evt.getFormShowParameter().setCustomParam("isclearcorefilter", (Object)"true");
                return accountFilter.and("accttype", "in", (Object)new String[]{AcctTypeEnum.OUT.getValue()});
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"bankacct_inout", evt -> {
                evt.getFormShowParameter().setCustomParam("isclearcorefilter", (Object)"true");
                return accountFilter.and("accttype", "in", (Object)new String[]{AcctTypeEnum.INOUT.getValue()});
            });
            QFilter strategyFilter = new QFilter("currency", "=", (Object)currency.getLong("id")).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"transtrategy", evt -> strategyFilter);
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"transtrategy_in", evt -> strategyFilter);
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"transtrategy_out", evt -> strategyFilter);
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"transtrategy_inout", evt -> strategyFilter);
            QFilter autoTransUpFilter = new QFilter("type", "=", (Object)FcaTransTypeEnum.TRANSUP.getValue()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            QFilter autoTransDownFilter = new QFilter("type", "=", (Object)FcaTransTypeEnum.TRANSDOWN.getValue()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransup", evt -> {
                DynamicObject accountbank = (DynamicObject)this.getModel().getValue("bankacct");
                if (EmptyUtil.isEmpty((DynamicObject)accountbank)) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else {
                    boolean issetbankinterface = accountbank.getBoolean("issetbankinterface");
                    if (!issetbankinterface) {
                        autoTransUpFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                    }
                }
                return autoTransUpFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransdown", evt -> {
                DynamicObject accountbank = (DynamicObject)this.getModel().getValue("bankacct");
                if (EmptyUtil.isEmpty((DynamicObject)accountbank)) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else {
                    boolean issetbankinterface = accountbank.getBoolean("issetbankinterface");
                    if (!issetbankinterface) {
                        autoTransDownFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                    }
                }
                return autoTransDownFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransup_in", evt -> {
                DynamicObject accountbank_in = (DynamicObject)this.getModel().getValue("bankacct_in");
                if (EmptyUtil.isEmpty((DynamicObject)accountbank_in)) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else {
                    boolean issetbankinterface = accountbank_in.getBoolean("issetbankinterface");
                    if (!issetbankinterface) {
                        autoTransUpFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                    }
                }
                return autoTransUpFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransdown_out", evt -> {
                DynamicObject accountbank_out = (DynamicObject)this.getModel().getValue("bankacct_out");
                if (EmptyUtil.isEmpty((DynamicObject)accountbank_out)) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else if (!accountbank_out.getBoolean("issetbankinterface")) {
                    autoTransDownFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                }
                return autoTransDownFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransdown_inout", evt -> {
                DynamicObject accountBankInout = (DynamicObject)this.getModel().getValue("bankacct_inout");
                if (accountBankInout == null) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else if (!accountBankInout.getBoolean("issetbankinterface")) {
                    autoTransDownFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                }
                return autoTransDownFilter;
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"autotransup_inout", evt -> {
                DynamicObject accountbank_in = (DynamicObject)this.getModel().getValue("bankacct_inout");
                if (EmptyUtil.isEmpty((DynamicObject)accountbank_in)) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                } else if (!accountbank_in.getBoolean("issetbankinterface")) {
                    autoTransUpFilter.and("opername", "!=", (Object)FcaOperNameEnum.DOSUBMITBEI.getValue());
                }
                return autoTransUpFilter;
            });
            DynamicObject son_bank_acct = (DynamicObject)this.getModel().getValue("bankacct");
            List<Long> innerId = this.InnerCurrency(acctcompanyIdList, currId);
            QFilter innerFilter = new QFilter("finorg.org", "=", company.getPkValue()).and(new QFilter("id", "in", innerId));
            int entryson = this.getModel().getEntryCurrentRowIndex("entrys");
            if (!EmptyUtil.isEmpty((DynamicObject)son_bank_acct)) {
                this.getView().setEnable(Boolean.valueOf(true), entryson, new String[]{"inneracct"});
                DynamicObject company_son = (DynamicObject)son_bank_acct.get("company");
                QFilter innerFilter_door = innerFilter.and("company", "=", (Object)company_son.getLong("id"));
                TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"inneracct", evt -> innerFilter_door);
            }
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"inneracct_in", evt -> {
                DynamicObject bankAcctIn = (DynamicObject)this.getModel().getValue("bankacct_in");
                if (bankAcctIn == null) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                    evt.setCancel(true);
                    return null;
                }
                DynamicObject company_son = (DynamicObject)bankAcctIn.get("company");
                return new QFilter("finorg.org", "=", company.getPkValue()).and(new QFilter("id", "in", (Object)innerId)).and(new QFilter("company", "=", (Object)company_son.getLong("id")));
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"inneracct_out", evt -> {
                DynamicObject bankAcctIn = (DynamicObject)this.getModel().getValue("bankacct_out");
                if (bankAcctIn == null) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                    evt.setCancel(true);
                    return null;
                }
                DynamicObject company_son = (DynamicObject)bankAcctIn.get("company");
                return new QFilter("finorg.org", "=", company.getPkValue()).and(new QFilter("id", "in", (Object)innerId)).and(new QFilter("company", "=", (Object)company_son.getLong("id")));
            });
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"inneracct_inout", evt -> {
                DynamicObject bankAcctInOut = (DynamicObject)this.getModel().getValue("bankacct_inout");
                if (bankAcctInOut == null) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChooseAcctFirst());
                    evt.setCancel(true);
                    return null;
                }
                DynamicObject company_son = (DynamicObject)bankAcctInOut.get("company");
                return new QFilter("finorg.org", "=", company.getPkValue()).and(new QFilter("id", "in", (Object)innerId)).and(new QFilter("company", "=", (Object)company_son.getLong("id")));
            });
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entrys"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tbl_in"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tbl_out"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tbl_inout"});
        }
        this.tabChange();
    }

    private void tabChange() {
        Tab tab = (Tab)this.getControl("sonaccttabap");
        tab.addTabSelectListener(tabSelectEvent -> {
            String tabKey = tabSelectEvent.getTabKey();
            this.setBotnVisiable(tabKey);
        });
    }

    void setBotnVisiable(String tabKey) {
        if ("incometabap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"newentry_in", "deleteentry_in"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newentry_out", "deleteentry_out", "newentry_inout", "deleteentry_inout"});
        } else if ("expendtabap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"newentry_out", "deleteentry_out"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newentry_in", "deleteentry_in", "newentry_inout", "deleteentry_inout"});
        } else if ("inouttabap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"newentry_inout", "deleteentry_inout"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newentry_in", "deleteentry_in", "newentry_out", "deleteentry_out"});
        }
    }

    private List<DynamicObject> getAuthAcctList() {
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter companyIdFilter = new QFilter("company", "in", (Object)authOrgList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        return QueryServiceHelper.query((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter[]{companyIdFilter, enableFilter});
    }

    private List<Long> acctCurrency(List<Object> companyIdList, Long currId) {
        ArrayList<Long> acctCurrId = new ArrayList<Long>();
        Map acctmaps = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"currency", (QFilter[])new QFilter[]{new QFilter("company", "in", companyIdList)});
        if (!CollectionUtils.isEmpty((Map)acctmaps)) {
            for (Map.Entry acct : acctmaps.entrySet()) {
                DynamicObject value = (DynamicObject)acct.getValue();
                DynamicObjectCollection currys = (DynamicObjectCollection)value.get("currency");
                ArrayList<Long> currIdList = new ArrayList<Long>();
                for (DynamicObject curr : currys) {
                    currIdList.add(curr.getLong("fbasedataid.id"));
                }
                if (!currIdList.contains(currId)) continue;
                acctCurrId.add((Long)value.getPkValue());
            }
        }
        return acctCurrId;
    }

    private List<Long> InnerCurrency(List<Object> companyIdList, Long currId) {
        ArrayList<Long> innerCurrId = new ArrayList<Long>();
        Map innerMap = TmcDataServiceHelper.loadFromCache((String)"ifm_inneracct", (String)"currency", (QFilter[])new QFilter[]{new QFilter("company", "in", companyIdList)});
        if (!CollectionUtils.isEmpty((Map)innerMap)) {
            for (Map.Entry inner : innerMap.entrySet()) {
                DynamicObject value = (DynamicObject)inner.getValue();
                DynamicObjectCollection currys = (DynamicObjectCollection)value.get("currency");
                ArrayList<Long> currIdList = new ArrayList<Long>();
                for (DynamicObject curr : currys) {
                    currIdList.add(curr.getLong("fbasedataid.id"));
                }
                if (!currIdList.contains(currId)) continue;
                innerCurrId.add((Long)value.getPkValue());
            }
        }
        return innerCurrId;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getPageCache().get("isFirst") == null) {
            this.getPageCache().put("isFirst", "true");
            this.getModel().setValue("enable", null);
            this.clearEntry();
            this.setAcctControlModel();
        }
    }

    void setAcctControlModel() {
        Object value = this.getModel().getValue("managemode");
        if ("portal_acct".equals(value)) {
            this.getModel().setValue("acctctlmode", (Object)FcaAcctControlModelEnum.PORTAL_ACCT.getName());
        } else {
            this.getModel().setValue("acctctlmode", (Object)FcaAcctControlModelEnum.INCOME_TWOLINE.getName());
        }
        this.getView().updateView("acctctlmode");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        switch (fieldKey) {
            case "managemode": {
                this.setAcctControlModel();
                this.getView().showConfirm(new FcaBizConstant().getTipForclean(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CLEAN_CALLBACK, (IFormPlugin)this));
                break;
            }
            case "company": {
                if (newValue != null) break;
                this.getModel().setValue("accountbank", null);
                break;
            }
            case "currency": {
                if (newValue != null) break;
                this.clearEntry();
                break;
            }
            case "accountbank": {
                DynamicObject accountBanks = (DynamicObject)newValue;
                if (accountBanks != null) {
                    DynamicObjectCollection currencies = (DynamicObjectCollection)accountBanks.get("currency");
                    if (EmptyUtil.isEmpty((DynamicObject)company)) {
                        this.getModel().setValue("company", accountBanks.getDynamicObject("company").getPkValue());
                    }
                    if (currencies.size() == 1) {
                        this.getModel().setValue("currency", ((DynamicObject)currencies.get(0)).get("fbasedataid.id"));
                        break;
                    }
                    this.getModel().setValue("currency", accountBanks.get("defaultcurrency"));
                    break;
                }
                this.getModel().setValue("currency", null);
                break;
            }
            case "bankacct": {
                DynamicObject acctbanks_door = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowIndex_door = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("transtrategy", null, rowIndex_door);
                this.getModel().setValue("inneracct", null, rowIndex_door);
                this.getModel().setValue("autotransup", null, rowIndex_door);
                this.getModel().setValue("autotransdown", null, rowIndex_door);
                this.setEnableAutotransAndInner(acctbanks_door, rowIndex_door, "door");
                AcctGroupRelInnerAcctHelper.fillInnerAccounts((IDataModel)this.getModel());
                break;
            }
            case "bankacct_in": {
                DynamicObject son_bank_acct_in = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowIndex_in = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("transtrategy_in", null, rowIndex_in);
                this.getModel().setValue("inneracct_in", null, rowIndex_in);
                this.getModel().setValue("autotransup_in", null, rowIndex_in);
                this.setEnableAutotransAndInner(son_bank_acct_in, rowIndex_in, "in");
                break;
            }
            case "bankacct_out": {
                DynamicObject son_bank_acct_out = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowIndex_out = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("transtrategy_out", null, rowIndex_out);
                this.getModel().setValue("inneracct_out", null, rowIndex_out);
                this.getModel().setValue("autotransdown_out", null, rowIndex_out);
                this.setEnableAutotransAndInner(son_bank_acct_out, rowIndex_out, "out");
                break;
            }
            case "bankacct_inout": {
                DynamicObject son_bank_acct_inout = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowIndex_inout = e.getChangeSet()[0].getRowIndex();
                this.getModel().setValue("transtrategy_inout", null, rowIndex_inout);
                this.getModel().setValue("inneracct_inout", null, rowIndex_inout);
                this.getModel().setValue("autotransdown_inout", null, rowIndex_inout);
                this.getModel().setValue("autotransup_inout", null, rowIndex_inout);
                this.setEnableAutotransAndInner(son_bank_acct_inout, rowIndex_inout, "inout");
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection entry_inout;
        DynamicObjectCollection entry_out;
        DynamicObjectCollection entry_in;
        DynamicObjectCollection entry;
        int length;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if (this.getPageCache().getAll().containsKey(ISAUTOADDROW)) {
            this.getPageCache().remove(ISAUTOADDROW);
            return;
        }
        if ("entrys".equals(entryName) && (length = (entry = this.getModel().getEntryEntity("entrys")).size()) > 0) {
            this.getView().setEnable(Boolean.valueOf(false), length - 1, new String[]{"autotransup", "autotransdown", "inneracct"});
        }
        if ("tbl_in".equals(entryName) && (length = (entry_in = this.getModel().getEntryEntity("tbl_in")).size()) > 0) {
            this.getView().setEnable(Boolean.valueOf(false), length - 1, new String[]{"autotransup_in", "inneracct_in"});
        }
        if ("tbl_out".equals(entryName) && (length = (entry_out = this.getModel().getEntryEntity("tbl_out")).size()) > 0) {
            this.getView().setEnable(Boolean.valueOf(false), length - 1, new String[]{"autotransdown_out", "inneracct_out"});
        }
        if ("tbl_inout".equals(entryName) && (length = (entry_inout = this.getModel().getEntryEntity("tbl_inout")).size()) > 0) {
            this.getView().setEnable(Boolean.valueOf(false), length - 1, new String[]{"autotransdown_inout", "autotransup_inout", "inneracct_inout"});
        }
    }

    private void setEnableAutotransAndInner(DynamicObject newValue, int selectRow, String type) {
        this.setEnableAutoTransAndInnerDetail(!EmptyUtil.isEmpty((DynamicObject)newValue), selectRow, type);
    }

    private void setEnableAutoTransAndInnerDetail(boolean isEnable, int selectRow, String type) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String managemode = dataEntity.getString("managemode");
        if ("portal_acct".equals(managemode)) {
            this.getView().setEnable(Boolean.valueOf(isEnable), selectRow, new String[]{"autotransup", "autotransdown", "inneracct"});
        } else if ("in".equalsIgnoreCase(type)) {
            this.getView().setEnable(Boolean.valueOf(isEnable), selectRow, new String[]{"autotransup_in", "inneracct_in"});
        } else if ("out".equalsIgnoreCase(type)) {
            this.getView().setEnable(Boolean.valueOf(isEnable), selectRow, new String[]{"autotransdown_out", "inneracct_out"});
        } else if ("inout".equalsIgnoreCase(type)) {
            this.getView().setEnable(Boolean.valueOf(isEnable), selectRow, new String[]{"autotransdown_inout", "autotransup_inout", "inneracct_inout"});
        }
    }

    private void showChangeConfirmDialog(String key) {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        this.getView().showConfirm(new FcaBizConstant().getTipForupdate(), MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entrys");
        this.getModel().deleteEntryData("tbl_in");
        this.getModel().deleteEntryData("tbl_out");
        this.getModel().deleteEntryData("tbl_inout");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntryGrid doorEntrys = (EntryGrid)this.getControl("entrys");
        EntryGrid incomeEntrys = (EntryGrid)this.getControl("tbl_in");
        EntryGrid expendEntrys = (EntryGrid)this.getControl("tbl_out");
        EntryGrid inoutEntries = (EntryGrid)this.getControl("tbl_inout");
        DynamicObjectCollection doorDatas = this.getModel().getEntryEntity("entrys");
        DynamicObjectCollection incomeDatas = this.getModel().getEntryEntity("tbl_in");
        DynamicObjectCollection expendDatas = this.getModel().getEntryEntity("tbl_out");
        DynamicObjectCollection inoutDatas = this.getModel().getEntryEntity("tbl_inout");
        Object currPkValue = null;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            currPkValue = currency.getPkValue();
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        Tab tab = (Tab)this.getView().getControl("sonaccttabap");
        switch (operateKey) {
            case "filldoorentry": {
                for (DynamicObject doorData : doorDatas) {
                    DynamicObject entrbankacct = (DynamicObject)doorData.get("bankacct");
                    if (!EmptyUtil.isEmpty((DynamicObject)entrbankacct)) continue;
                    this.getView().showTipNotification(new FcaBizConstant().getIfacctnullcannotdo(), Integer.valueOf(2000));
                    return;
                }
                int[] selectDoorRows = doorEntrys.getSelectRows();
                if (selectDoorRows.length == 0) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChoosemoreData());
                    return;
                }
                this.showForm("fca_batch_input", "filldoorentry", currPkValue);
                args.setCancel(true);
                break;
            }
            case "fillentry": {
                if ("incometabap".equals(tab.getCurrentTab())) {
                    for (DynamicObject incomeData : incomeDatas) {
                        DynamicObject entrbankacct = (DynamicObject)incomeData.get("bankacct_in");
                        if (!EmptyUtil.isEmpty((DynamicObject)entrbankacct)) continue;
                        this.getView().showTipNotification(new FcaBizConstant().getIfacctnullcannotdo(), Integer.valueOf(2000));
                        return;
                    }
                    int[] selectInRows = incomeEntrys.getSelectRows();
                    if (selectInRows.length == 0) {
                        this.getView().showErrorNotification(new FcaBizConstant().getChoosemoreData());
                        return;
                    }
                    this.showForm("fca_batch_input", "incometabap", currPkValue);
                    args.setCancel(true);
                    break;
                }
                if ("expendtabap".equals(tab.getCurrentTab())) {
                    for (DynamicObject expendData : expendDatas) {
                        DynamicObject entrbankacct = (DynamicObject)expendData.get("bankacct_out");
                        if (!EmptyUtil.isEmpty((DynamicObject)entrbankacct)) continue;
                        this.getView().showTipNotification(new FcaBizConstant().getIfacctnullcannotdo(), Integer.valueOf(2000));
                        return;
                    }
                    int[] selectOutRows = expendEntrys.getSelectRows();
                    if (selectOutRows.length == 0) {
                        this.getView().showErrorNotification(new FcaBizConstant().getChoosemoreData());
                        return;
                    }
                    this.showForm("fca_batch_input", "expendtabap", currPkValue);
                    args.setCancel(true);
                    break;
                }
                if (!"inouttabap".equals(tab.getCurrentTab())) break;
                for (DynamicObject inoutData : inoutDatas) {
                    DynamicObject entrbankacct = (DynamicObject)inoutData.get("bankacct_inout");
                    if (!EmptyUtil.isEmpty((DynamicObject)entrbankacct)) continue;
                    this.getView().showTipNotification(new FcaBizConstant().getIfacctnullcannotdo(), Integer.valueOf(2000));
                    return;
                }
                Object selectOutRows = inoutEntries.getSelectRows();
                if (((Object)selectOutRows).length == 0) {
                    this.getView().showErrorNotification(new FcaBizConstant().getChoosemoreData());
                    return;
                }
                this.showForm("fca_batch_input", "inouttabap", currPkValue);
                args.setCancel(true);
                break;
            }
            case "save": {
                this.entryDeal();
                break;
            }
        }
    }

    public void showForm(String formId, String callBackBtn, Object currPkValue) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getCustomParams().put(CHOOSE_WHICHENTRY, callBackBtn);
        fsp.getCustomParams().put("currPkValue", currPkValue);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackBtn);
        fsp.setCloseCallBack(callBack);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(fsp);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)"save", (CharSequence)args.getOperateKey())) {
            this.getView().updateView();
        }
    }

    private void entryDeal() {
        if ("income_twoline".equals(this.getModel().getValue("managemode"))) {
            DynamicObjectCollection incomeEntrys = this.getModel().getEntryEntity("tbl_in");
            DynamicObjectCollection expendEntrys = this.getModel().getEntryEntity("tbl_out");
            DynamicObjectCollection inoutEntries = this.getModel().getEntryEntity("tbl_inout");
            this.getModel().deleteEntryData("entrys");
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField("bankacct", new Object[0]);
            vs.addField("transtrategy", new Object[0]);
            vs.addField("autotransup", new Object[0]);
            vs.addField("autotransdown", new Object[0]);
            vs.addField("inneracct", new Object[0]);
            for (DynamicObject incomeEntry : incomeEntrys) {
                vs.addRow(new Object[]{incomeEntry.get("seq"), incomeEntry.get("bankacct_in.id"), incomeEntry.get("transtrategy_in.id"), incomeEntry.get("autotransup_in.id"), incomeEntry.get("autotransdown_in.id"), incomeEntry.get("inneracct_in.id")});
            }
            for (DynamicObject expendEntry : expendEntrys) {
                vs.addRow(new Object[]{expendEntry.get("seq"), expendEntry.get("bankacct_out.id"), expendEntry.get("transtrategy_out.id"), expendEntry.get("autotransup_out.id"), expendEntry.get("autotransdown_out.id"), expendEntry.get("inneracct_out.id")});
            }
            for (DynamicObject inoutEntry : inoutEntries) {
                vs.addRow(new Object[]{inoutEntry.get("seq"), inoutEntry.get("bankacct_inout.id"), inoutEntry.get("transtrategy_inout.id"), inoutEntry.get("autotransup_inout.id"), inoutEntry.get("autotransdown_inout.id"), inoutEntry.get("inneracct_inout.id")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entrys", vs);
            model.endInit();
            this.getView().updateView("entrys");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object value = this.getModel().getValue("managemode");
        if ("portal_acct".equals(value)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconapinout"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconapinout"});
        }
        this.dataReplay();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
        control.hidePanel(SplitDirection.right, true);
        if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_print"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"enable"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"modifier"});
        }
        if ("EDIT".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_print"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"enable"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"modifier"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        Tab tab = (Tab)this.getControl("sonaccttabap");
        String tabKey = tab.getCurrentTab();
        this.setBotnVisiable(tabKey);
        this.getModel().setDataChanged(false);
    }

    void dataReplay() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String managemode = dataEntity.getString("managemode");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        AcctGroupRelInnerAcctHelper.fillInnerAccounts((IDataModel)this.getModel());
        if ("income_twoline".equals(managemode)) {
            this.getModel().deleteEntryData("tbl_in");
            this.getModel().deleteEntryData("tbl_out");
            this.getModel().deleteEntryData("tbl_inout");
            for (DynamicObject entry : entrys) {
                DynamicObject entrbankacct = entry.getDynamicObject("bankacct");
                DynamicObject transtrategy = entry.getDynamicObject("transtrategy");
                DynamicObject autotransup = entry.getDynamicObject("autotransup");
                DynamicObject autotransdown = entry.getDynamicObject("autotransdown");
                DynamicObject entrinnacct = entry.getDynamicObject("inneracct");
                String accttype = null;
                if (entrbankacct != null) {
                    accttype = entrbankacct.getString("accttype");
                }
                if (AcctTypeEnum.IN.getValue().equals(accttype)) {
                    DynamicObjectCollection incomeEntrys = this.getModel().getEntryEntity("tbl_in");
                    this.getPageCache().put(ISAUTOADDROW, "true");
                    int newEntryRow = this.getModel().createNewEntryRow("tbl_in");
                    ((DynamicObject)incomeEntrys.get(newEntryRow)).set("bankacct_in", (Object)entrbankacct);
                    ((DynamicObject)incomeEntrys.get(newEntryRow)).set("transtrategy_in", (Object)transtrategy);
                    ((DynamicObject)incomeEntrys.get(newEntryRow)).set("autotransup_in", (Object)autotransup);
                    ((DynamicObject)incomeEntrys.get(newEntryRow)).set("autotransdown_in", (Object)autotransdown);
                    ((DynamicObject)incomeEntrys.get(newEntryRow)).set("inneracct_in", (Object)entrinnacct);
                    continue;
                }
                if (AcctTypeEnum.OUT.getValue().equals(accttype)) {
                    this.getPageCache().put(ISAUTOADDROW, "true");
                    int newEntryRow = this.getModel().createNewEntryRow("tbl_out");
                    DynamicObjectCollection expendEntrys = this.getModel().getEntryEntity("tbl_out");
                    ((DynamicObject)expendEntrys.get(newEntryRow)).set("bankacct_out", (Object)entrbankacct);
                    ((DynamicObject)expendEntrys.get(newEntryRow)).set("transtrategy_out", (Object)transtrategy);
                    ((DynamicObject)expendEntrys.get(newEntryRow)).set("autotransup_out", (Object)autotransup);
                    ((DynamicObject)expendEntrys.get(newEntryRow)).set("autotransdown_out", (Object)autotransdown);
                    ((DynamicObject)expendEntrys.get(newEntryRow)).set("inneracct_out", (Object)entrinnacct);
                    continue;
                }
                if (!AcctTypeEnum.INOUT.getValue().equals(accttype)) continue;
                this.getPageCache().put(ISAUTOADDROW, "true");
                int newEntryRow = this.getModel().createNewEntryRow("tbl_inout");
                DynamicObjectCollection inoutEntries = this.getModel().getEntryEntity("tbl_inout");
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("bankacct_inout", (Object)entrbankacct);
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("transtrategy_inout", (Object)transtrategy);
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("autotransup_inout", (Object)autotransup);
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("autotransdown_inout", (Object)autotransdown);
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("autotransup_inout", (Object)autotransup);
                ((DynamicObject)inoutEntries.get(newEntryRow)).set("inneracct_inout", (Object)entrinnacct);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String pkOld;
        Object pk;
        ListSelectedRow selectedRow;
        String acctBankField;
        Object returnBatchContent;
        String returnbatchfield;
        Object whichchoose;
        HashMap returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"filldoorentry")) {
            returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                whichchoose = returnData.get("whichchoose");
                returnbatchfield = (String)returnData.get("returnbatchfield");
                returnBatchContent = returnData.get("returnBatchContent");
                acctBankField = "bankacct";
                if (EmptyUtil.isNoEmpty((String)returnbatchfield)) {
                    if (returnbatchfield.contains(STRATEGY)) {
                        returnbatchfield = "transtrategy";
                    } else if (returnbatchfield.contains(AUTOUP)) {
                        returnbatchfield = "autotransup";
                    } else if (returnbatchfield.contains(AUTODOWN)) {
                        returnbatchfield = "autotransdown";
                    }
                    this.batchFillEntry("entrys", whichchoose, returnbatchfield, returnBatchContent, acctBankField);
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"incometabap")) {
            returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                whichchoose = returnData.get("whichchoose");
                returnbatchfield = (String)returnData.get("returnbatchfield");
                returnBatchContent = returnData.get("returnBatchContent");
                acctBankField = "bankacct_in";
                if (EmptyUtil.isNoEmpty((String)returnbatchfield)) {
                    if (returnbatchfield.contains(STRATEGY)) {
                        returnbatchfield = "transtrategy_in";
                    } else if (returnbatchfield.contains(AUTOUP)) {
                        returnbatchfield = "autotransup_in";
                    } else if (returnbatchfield.contains(AUTODOWN)) {
                        returnbatchfield = "autotransdown_in";
                    }
                    this.batchFillEntry("tbl_in", whichchoose, returnbatchfield, returnBatchContent, acctBankField);
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"expendtabap")) {
            returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                whichchoose = returnData.get("whichchoose");
                returnbatchfield = (String)returnData.get("returnbatchfield");
                returnBatchContent = returnData.get("returnBatchContent");
                acctBankField = "bankacct_out";
                if (EmptyUtil.isNoEmpty((String)returnbatchfield)) {
                    if (returnbatchfield.contains(STRATEGY)) {
                        returnbatchfield = "transtrategy_out";
                    } else if (returnbatchfield.contains(AUTOUP)) {
                        returnbatchfield = "autotransup_out";
                    } else if (returnbatchfield.contains(AUTODOWN)) {
                        returnbatchfield = "autotransdown_out";
                    }
                    this.batchFillEntry("tbl_out", whichchoose, returnbatchfield, returnBatchContent, acctBankField);
                }
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"inouttabap") && EmptyUtil.isNoEmpty((Object)(returnData = (HashMap)closedCallBackEvent.getReturnData()))) {
            whichchoose = returnData.get("whichchoose");
            returnbatchfield = (String)returnData.get("returnbatchfield");
            returnBatchContent = returnData.get("returnBatchContent");
            acctBankField = "bankacct_inout";
            if (EmptyUtil.isNoEmpty((String)returnbatchfield)) {
                if (returnbatchfield.contains(STRATEGY)) {
                    returnbatchfield = "transtrategy_inout";
                } else if (returnbatchfield.contains(AUTOUP)) {
                    returnbatchfield = "autotransup_inout";
                } else if (returnbatchfield.contains(AUTODOWN)) {
                    returnbatchfield = "autotransdown_inout";
                }
                this.batchFillEntry("tbl_inout", whichchoose, returnbatchfield, returnBatchContent, acctBankField);
            }
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_ACCOUNT_BANK_CALLBACK)) {
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject bank_acct = (DynamicObject)this.getModel().getValue("accountbank");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                selectedRow = returnData.get(0);
                pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = bank_acct != null ? bank_acct.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_ACCOUNT_BANK_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_ACCOUNT_BANK_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_ACCOUNT_BANK_CALLBACK);
            }
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_CURRENCY_CALLBACK)) {
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                selectedRow = returnData.get(0);
                pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = currency != null ? currency.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_CURRENCY_CALLBACK);
            }
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_COMPANY_CALLBACK)) {
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                selectedRow = returnData.get(0);
                pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = company != null ? company.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_COMPANY_CALLBACK);
            }
        }
    }

    private void batchFillEntry(String anyentry, Object whichchoose, String returnbatchfield, Object returnBatchContent, String acctBankField) {
        EntryGrid entrys = (EntryGrid)this.getControl(anyentry);
        DynamicObjectCollection chooseEntrys = this.getModel().getEntryEntity(anyentry);
        String opername = "";
        int opRows = 0;
        if (returnbatchfield.contains(AUTO)) {
            opername = ((DynamicObject)returnBatchContent).getString("opername");
        }
        ArrayList<Integer> failRowDetail = new ArrayList<Integer>();
        if ("selectedrows".equals(whichchoose)) {
            int[] selectRows = entrys.getSelectRows();
            opRows = selectRows.length;
            for (int i = 0; i < selectRows.length; ++i) {
                if (FcaOperNameEnum.DOSUBMITBEI.getValue().equals(opername)) {
                    if (((DynamicObject)chooseEntrys.get(selectRows[i])).getDynamicObject(acctBankField).getBoolean("issetbankinterface")) {
                        ((DynamicObject)chooseEntrys.get(selectRows[i])).set(returnbatchfield, returnBatchContent);
                        continue;
                    }
                    failRowDetail.add(i);
                    continue;
                }
                ((DynamicObject)chooseEntrys.get(selectRows[i])).set(returnbatchfield, returnBatchContent);
            }
        } else {
            for (int i = 0; i < chooseEntrys.size(); ++i) {
                opRows = chooseEntrys.size();
                if (FcaOperNameEnum.DOSUBMITBEI.getValue().equals(opername)) {
                    if (((DynamicObject)chooseEntrys.get(i)).getDynamicObject(acctBankField).getBoolean("issetbankinterface")) {
                        ((DynamicObject)chooseEntrys.get(i)).set(returnbatchfield, returnBatchContent);
                        continue;
                    }
                    failRowDetail.add(i);
                    continue;
                }
                ((DynamicObject)chooseEntrys.get(i)).set(returnbatchfield, returnBatchContent);
            }
        }
        StringBuilder sbt = new StringBuilder();
        StringBuilder sbc = new StringBuilder();
        String total = String.format(ResManager.loadKDString((String)"\u5171\u64cd\u4f5c\u5206\u5f55%1$d\u884c\uff0c\u6210\u529f%2$d\u884c\uff0c\u5931\u8d25%3$d\u884c\u3002", (String)"AcctGroupEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]), opRows, opRows - failRowDetail.size(), failRowDetail.size());
        sbt.append(total);
        if (failRowDetail.size() > 0) {
            for (int i = 0; i < failRowDetail.size(); ++i) {
                int failrow = (Integer)failRowDetail.get(i);
                String content = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8bbe\u7f6e\u5931\u8d25\u3002\u5b50\u8d26\u6237\u5fc5\u987b\u5f00\u901a\u94f6\u4f01\uff0c\u624d\u80fd\u9009\u62e9\u201c\u6267\u884c\u64cd\u4f5c\u201d\u4e3a\u63d0\u4ea4\u94f6\u4f01\u7684\u81ea\u52a8\u5212\u62e8\u8bbe\u7f6e\u3002", (String)"AcctGroupEdit_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]), failrow + 1);
                sbc.append(content);
                if (i == failRowDetail.size() - 1) continue;
                sbc.append("</br>");
            }
            this.batchInputTip(sbt.toString(), sbc.toString());
            this.getView().updateView(anyentry);
        } else {
            this.getView().showSuccessNotification(sbt.toString(), Integer.valueOf(2000));
            this.getView().updateView(anyentry);
        }
    }

    void batchInputTip(String title, String content) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        parameters.setCustomParam("errorMsg", (Object)buf.append(content));
        this.getView().showForm(parameters);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String pk;
            if (callBackId.equals(CHANGE_COMPANY_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_COMPANY_CALLBACK);
                LOGGER.info("pk:{}", (Object)pk);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK_OLD);
                this.getModel().setValue("company", (Object)pk);
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("currency", null);
                this.clearEntry();
            }
            if (callBackId.equals(CHANGE_ACCOUNT_BANK_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_ACCOUNT_BANK_CALLBACK);
                this.getPageCache().remove(CHANGE_ACCOUNT_BANK_CALLBACK);
                this.getPageCache().remove(CHANGE_ACCOUNT_BANK_CALLBACK_OLD);
                this.getModel().setValue("accountbank", (Object)pk);
                this.clearEntry();
            }
            if (callBackId.equals(CHANGE_CURRENCY_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_CURRENCY_CALLBACK);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK_OLD);
                this.getModel().setValue("currency", (Object)pk);
                this.clearEntry();
            }
            if (callBackId.equals(CONFIRM_CLEAN_CALLBACK)) {
                Object value = this.getModel().getValue("managemode");
                if ("income_twoline".equals(value)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconapinout"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconapinout"});
                }
                this.clearEntry();
            }
        } else {
            String pk;
            if (callBackId.equals(CHANGE_COMPANY_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_COMPANY_CALLBACK_OLD);
                LOGGER.info("pk:{}", (Object)pk);
                this.getModel().setValue("company", (Object)pk);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK_OLD);
            }
            if (callBackId.equals(CHANGE_ACCOUNT_BANK_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_ACCOUNT_BANK_CALLBACK_OLD);
                this.getModel().setValue("accountbank", (Object)pk);
                this.getPageCache().remove(CHANGE_ACCOUNT_BANK_CALLBACK);
                this.getPageCache().remove(CHANGE_ACCOUNT_BANK_CALLBACK_OLD);
            }
            if (callBackId.equals(CHANGE_CURRENCY_CALLBACK)) {
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK);
                pk = this.getPageCache().get(CHANGE_CURRENCY_CALLBACK_OLD);
                this.getModel().setValue("currency", (Object)pk);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK_OLD);
            }
            if (callBackId.equals(CONFIRM_CLEAN_CALLBACK)) {
                Object value = this.getModel().getValue("managemode");
                this.getModel().beginInit();
                if ("income_twoline".equals(value)) {
                    this.getModel().setValue("managemode", (Object)"portal_acct");
                    this.setAcctControlModel();
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconapinout"});
                } else {
                    this.getModel().setValue("managemode", (Object)"income_twoline");
                    this.setAcctControlModel();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconapinout"});
                }
                this.getModel().endInit();
                this.getView().updateView("managemode");
            }
        }
    }
}

