/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.applytransbill;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class Apply2TransBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Set<DynamicObject> transBills = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            return targetBill;
        }).collect(Collectors.toSet());
        Map<Long, DynamicObject> beBankInfosMap = this.getBeBankInfoMap(transBills);
        if (beBankInfosMap != null && beBankInfosMap.size() > 0) {
            for (ExtendedDataEntity billData : billDataEntitys) {
                DynamicObjectCollection entryS;
                DynamicObject beBank;
                DynamicObject bank;
                DynamicObject accountBank;
                DynamicObject transBill = billData.getDataEntity();
                if (transBill.containsProperty("accountbank") && (accountBank = transBill.getDynamicObject("accountbank")) != null && (bank = accountBank.getDynamicObject("bank")) != null && (beBank = beBankInfosMap.get(bank.getLong("id"))) != null) {
                    Long country = beBank.getLong("bebank.country");
                    String provinceTxt = beBank.getString("bebank.provincetxt");
                    String cityTxt = beBank.getString("bebank.cityTxt");
                    transBill.set("country_id", (Object)country);
                    transBill.set("province", (Object)provinceTxt);
                    transBill.set("city", (Object)cityTxt);
                }
                if (!transBill.containsProperty("entrys") || (entryS = transBill.getDynamicObjectCollection("entrys")) == null || entryS.size() <= 0) continue;
                for (DynamicObject entry : entryS) {
                    DynamicObject beBank2;
                    DynamicObject bank2;
                    DynamicObject subAccountBank = entry.getDynamicObject("subacct");
                    if (subAccountBank == null || (bank2 = subAccountBank.getDynamicObject("bank")) == null || (beBank2 = beBankInfosMap.get(bank2.getLong("id"))) == null) continue;
                    Long country = beBank2.getLong("bebank.country");
                    String provinceTxt = beBank2.getString("bebank.provincetxt");
                    String cityTxt = beBank2.getString("bebank.cityTxt");
                    entry.set("entrycountry_id", (Object)country);
                    entry.set("entryprovince", (Object)provinceTxt);
                    entry.set("entrycity", (Object)cityTxt);
                }
            }
        }
    }

    public Map<Long, DynamicObject> getBeBankInfoMap(Set<DynamicObject> transBills) {
        HashSet<Object> finId = new HashSet<Object>(10);
        for (DynamicObject transBill : transBills) {
            DynamicObjectCollection entryS;
            DynamicObject bank;
            DynamicObject accountBank;
            if (transBill.containsProperty("accountbank") && (accountBank = transBill.getDynamicObject("accountbank")) != null && (bank = accountBank.getDynamicObject("bank")) != null) {
                finId.add(bank.getPkValue());
            }
            if (!transBill.containsProperty("entrys") || (entryS = transBill.getDynamicObjectCollection("entrys")) == null || entryS.size() <= 0) continue;
            for (DynamicObject entry : entryS) {
                DynamicObject bank2;
                DynamicObject accountBank2 = entry.getDynamicObject("subacct");
                if (accountBank2 == null || (bank2 = accountBank2.getDynamicObject("bank")) == null) continue;
                finId.add(bank2.getPkValue());
            }
        }
        DynamicObjectCollection bankInfos = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank.id,bebank.country,bebank.provincetxt,bebank.citytxt", (QFilter[])new QFilter[]{new QFilter("id", "in", finId)});
        Map<Long, DynamicObject> result = bankInfos.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        return result;
    }
}

