/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.applytransbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.helper.AcctGroupRelInnerAcctHelper;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.resource.FcaBizResource;
import kd.tmc.fca.common.util.SysParameterHelp;

public class ApplyTransBillEdit
extends AbstractBillPlugIn {
    public static final String CHANGE_PARENTORG_CALLBACK = "CHANGE_PARENTORG_CALLBACK";
    public static final String CHANGE_PARENTORG_CALLBACK_OLD = "CHANGE_PARENTORG_CALLBACK_OLD";
    public static final String CHANGE_CURRENCY_CALLBACK = "CHANGE_CURRENCY_CALLBACK";
    public static final String CHANGE_CURRENCY_CALLBACK_OLD = "CHANGE_CURRENCY_CALLBACK_OLD";
    public static final String CHANGE_COMPANY_CALLBACK = "CHANGE_COMPANY_CALLBACK";
    public static final String CHANGE_COMPANY_CALLBACK_OLD = "CHANGE_COMPANY_CALLBACK_OLD ";
    private static final Log LOGGER = LogFactory.getLog(ApplyTransBillEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        String name = model.getDataEntity().getDataEntityType().getName();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"company", evt -> {
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)name, (String)"47156aff000000ac");
            FormShowParameter formShowParam = evt.getFormShowParameter();
            formShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_COMPANY_CALLBACK));
            return new QFilter("id", "in", (Object)authOrgIds);
        });
        BasedataEdit companyF7 = (BasedataEdit)this.getView().getControl("company");
        companyF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = company != null ? company.getPkValue().toString() : "";
            boolean isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            LOGGER.info("isChange:{},returnData:{},pk:{}", new Object[]{isChange, returnData, pk});
            if (isChange) {
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_COMPANY_CALLBACK);
            }
        });
        BasedataEdit parentOrgF7 = (BasedataEdit)this.getControl("parentorg");
        parentOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_PARENTORG_CALLBACK));
            DynamicObject[] acctGroups = null;
            if (!EmptyUtil.isEmpty((DynamicObject)company)) {
                acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"currency,company,bankacct", (QFilter[])new QFilter[]{new QFilter("enable", "in", (Object)"1"), new QFilter("entrys.bankacct.company", "in", (Object)company.getLong("id"))});
            }
            ArrayList<Long> companyIds = new ArrayList<Long>();
            if (acctGroups != null) {
                for (void var9_9 : acctGroups) {
                    companyIds.add(var9_9.getLong("company.id"));
                }
            }
            param.setCustomParam("range", companyIds);
        });
        parentOrgF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = parentOrg != null ? parentOrg.getPkValue().toString() : "";
            boolean isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            LOGGER.info("isChange:{},returnData:{},pk:{}", new Object[]{isChange, returnData, pk});
            if (isChange) {
                this.getPageCache().put(CHANGE_PARENTORG_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_PARENTORG_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_PARENTORG_CALLBACK);
            }
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"currency", evt -> {
            FormShowParameter formShowParam = evt.getFormShowParameter();
            formShowParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_CURRENCY_CALLBACK));
            DynamicObject[] acctGroups = null;
            if (!EmptyUtil.isEmpty((DynamicObject)company)) {
                acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"currency,company,bankacct", (QFilter[])new QFilter[]{new QFilter("enable", "in", (Object)"1"), new QFilter("entrys.bankacct.company", "in", (Object)company.getLong("id"))});
            }
            ArrayList<Long> currencyIds = new ArrayList<Long>();
            if (acctGroups != null) {
                for (void var10_10 : acctGroups) {
                    if (EmptyUtil.isEmpty((DynamicObject)parentOrg) || parentOrg.getLong("id") != var10_10.getLong("company.id")) continue;
                    currencyIds.add(var10_10.getLong("currency.id"));
                }
            }
            return new QFilter("id", "in", currencyIds);
        });
        BasedataEdit currencyF7 = (BasedataEdit)this.getView().getControl("currency");
        currencyF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = currency != null ? currency.getPkValue().toString() : "";
            boolean isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            LOGGER.info("isChange:{},returnData:{},pk:{}", new Object[]{isChange, returnData, pk});
            if (isChange) {
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_CURRENCY_CALLBACK);
            }
        });
        BasedataEdit subAcctF7 = (BasedataEdit)this.getControl("subacct");
        subAcctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Map<String, Object>> acctGroupList = this.loadAcctGroup();
            ArrayList<Long> subAcctIds = new ArrayList<Long>();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            for (Map<String, Object> map : acctGroupList) {
                for (Map.Entry<String, Object> data : map.entrySet()) {
                    if (!data.getKey().equals("subacct")) continue;
                    subAcctIds.add((Long)data.getValue());
                }
            }
            QFilter idFilter = new QFilter("id", "in", subAcctIds);
            qFilters.add(new QFilter("acctstatus", "not in", (Object)new String[]{BankAcctStatusEnum.CLOSED.getValue(), BankAcctStatusEnum.FREEZE.getValue()}));
            qFilters.add(idFilter);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        });
        BasedataEdit accountGroupF7 = (BasedataEdit)this.getControl("acctgrp");
        accountGroupF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            int index = this.getModel().getEntryCurrentRowIndex("entrys");
            DynamicObject subAcct = (DynamicObject)this.getModel().getValue("subacct", index);
            if (subAcct == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u3002", (String)"ApplyTransBillEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (parentOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bcd\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ApplyTransBillEdit_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qFilterList.add(new QFilter("entrys.bankacct.id", "=", (Object)subAcct.getLong("id")));
            qFilterList.add(new QFilter("currency.id", "=", (Object)model.getDataEntity().getLong("currency.id")));
            qFilterList.add(new QFilter("enable", "in", (Object)"1"));
            qFilterList.add(new QFilter("company", "=", parentOrg.getPkValue()));
            showParameter.getListFilterParameter().getQFilters().addAll(qFilterList);
        });
        accountGroupF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            Object returnData = afterF7SelectEvent.getInputValue();
            int index = this.getModel().getEntryCurrentRowIndex("entrys");
            LOGGER.info("returnData:{},currentRowIndex:{}", returnData, (Object)index);
            DynamicObject acctGroup = null;
            if (returnData != null) {
                acctGroup = BusinessDataServiceHelper.loadSingle((String)"fca_acctgroup", (String)"accountbank,bankacct,inneracct,company", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(returnData.toString()))});
            }
            DynamicObject subAcct = (DynamicObject)this.getModel().getValue("subacct", index);
            this.getModel().setValue("inneracct", null, index);
            this.getModel().setValue("pbankacct", null, index);
            if (acctGroup != null) {
                DynamicObject acctGroupCompany;
                if (acctGroup.getDynamicObject("accountbank") != null) {
                    this.getModel().setValue("pbankacct", (Object)acctGroup.getDynamicObject("accountbank").getLong("id"), index);
                }
                if (subAcct != null && (acctGroupCompany = acctGroup.getDynamicObject("company")) != null && currency != null) {
                    HashSet<Object> bankAccountIds = new HashSet<Object>(1);
                    bankAccountIds.add(subAcct.getPkValue());
                    Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
                    if (orgInnerAccountMap.containsKey(acctGroupCompany.getPkValue())) {
                        DynamicObjectCollection currencies;
                        List currencyIdList;
                        DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(acctGroupCompany.getPkValue())).get(subAcct.getPkValue());
                        if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                            innerAccount = null;
                        }
                        this.getModel().setValue("inneracct", (Object)innerAccount, index);
                    }
                }
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String targetBill;
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String type = op.getType();
        Map parameter = op.getParameter();
        String entityId = this.getView().getFormShowParameter().getFormId();
        if ("push".equalsIgnoreCase(type) && EmptyUtil.isNoEmpty((Object)parameter) && !operateKey.endsWith("_nofrdcheck") && ("fca_transupbill".equalsIgnoreCase(targetBill = (String)parameter.get("targetbill")) || "fca_transdownbill".equalsIgnoreCase(targetBill))) {
            DynamicObject[] selectedObj;
            for (DynamicObject data : selectedObj = BusinessDataServiceHelper.load((String)entityId, (String)"billstatus, entrys.pbankacct, entrys.subacct, entrys.isgeneratebill", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getDataEntity().getPkValue())})) {
                if (!BillStatusEnum.AUDIT.getValue().equals(data.getString("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u9700\u5df2\u5ba1\u6838\uff0c\u624d\u5141\u8bb8\u4e0b\u63a8\u3002", (String)"ApplyTransBillEdit_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
                for (DynamicObject obj : entries) {
                    DynamicObject pAccount = obj.getDynamicObject("pbankacct");
                    String pAccountStatus = "";
                    if (pAccount != null) {
                        pAccountStatus = pAccount.getString("acctstatus");
                    }
                    String subAccountStatus = "";
                    DynamicObject subAccount = obj.getDynamicObject("subacct");
                    if (subAccount != null) {
                        subAccountStatus = subAccount.getString("acctstatus");
                    }
                    if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                        if (StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)entityId)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        }
                        if (StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)entityId)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_3", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        }
                        args.setCancel(true);
                    }
                    if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)entityId)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u201c%1$s\u201d\u7684\u8d26\u6237\u72b6\u6001\u4e3a\u201c\u51bb\u7ed3\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_6", (String)"tmc-fca-formplugin", (Object[])new Object[0]), pAccount == null ? "" : pAccount.getString("bankaccountnumber")));
                        args.setCancel(true);
                    }
                    if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                        if (StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)entityId)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_4", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                        }
                        if (StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)entityId)) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237%s\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0b\u62e8\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_5", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                        }
                        args.setCancel(true);
                    }
                    if (!StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) || !StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)entityId)) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u201c%s\u201d\u5f53\u524d\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u53d1\u8d77\u4e0a\u5212\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"ApplyTransBillList_7", (String)"tmc-fca-formplugin", (Object[])new Object[0]), subAccount == null ? "" : subAccount.getString("bankaccountnumber")));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        RequestContext reqContext = RequestContext.get();
        model.setValue("createuser", (Object)reqContext.getCurrUserId());
        this.initCompany();
        if (null == this.getModel().getValue("transdate")) {
            this.getModel().setValue("transdate", this.getModel().getValue("bizdate"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldStatus();
        this.loadFields();
        this.setSubInnerAcctOnLoad();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("createuser", (Object)RequestContext.get().getCurrUserId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        IDataModel model = this.getModel();
        Date currentDate = DateUtils.getCurrentDate();
        int rowIndex = valSet[0].getRowIndex();
        switch (propName) {
            case "bizdate": {
                Date bizDate;
                if (!EmptyUtil.isEmpty((Object)propValue) && (bizDate = (Date)propValue).after(currentDate)) {
                    this.getView().showTipNotification(new FcaBizResource().getTipBizdate());
                    model.setValue("bizdate", null);
                }
                if (null != model.getValue("transdate")) break;
                model.setValue("transdate", model.getValue("bizdate"));
                break;
            }
            case "parentorg": 
            case "currency": {
                if (!EmptyUtil.isEmpty((Object)propValue)) break;
                this.getModel().deleteEntryData("entrys");
                this.getView().invokeOperation("newentry");
                break;
            }
            case "applyamt": {
                this.calApplySumAmt();
                break;
            }
            case "subacct": {
                this.subAcctChange(propValue, rowIndex);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_COMPANY_CALLBACK)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                String pkOld;
                ListSelectedRow selectedRow = returnData.get(0);
                Object pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = company != null ? company.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_COMPANY_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_COMPANY_CALLBACK);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_PARENTORG_CALLBACK)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                String pkOld;
                ListSelectedRow selectedRow = returnData.get(0);
                Object pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = parentOrg != null ? parentOrg.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_PARENTORG_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_PARENTORG_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_PARENTORG_CALLBACK);
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)CHANGE_CURRENCY_CALLBACK)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                String pkOld;
                ListSelectedRow selectedRow = returnData.get(0);
                Object pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = currency != null ? currency.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_CURRENCY_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_CURRENCY_CALLBACK);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.calApplySumAmt();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        IPageCache pageCache = this.getPageCache();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String pk;
            if (callBackId.equals(CHANGE_COMPANY_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_COMPANY_CALLBACK);
                LOGGER.info("pk:{}", (Object)pk);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK);
                this.getPageCache().remove(CHANGE_COMPANY_CALLBACK_OLD);
                this.getModel().setValue("company", (Object)pk);
                this.companyChange();
            }
            if (callBackId.equals(CHANGE_PARENTORG_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_PARENTORG_CALLBACK);
                this.getPageCache().remove(CHANGE_PARENTORG_CALLBACK);
                this.getPageCache().remove(CHANGE_PARENTORG_CALLBACK_OLD);
                this.getModel().setValue("parentorg", (Object)pk);
                this.parentOrgChange();
            }
            if (callBackId.equals(CHANGE_CURRENCY_CALLBACK)) {
                pk = this.getPageCache().get(CHANGE_CURRENCY_CALLBACK);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK_OLD);
                this.getModel().setValue("currency", (Object)pk);
                String name = this.getModel().getDataEntity().getDataEntityType().getName();
                if ("fca_applytransdownbill".equals(name) && StringUtils.isNotBlank((Object)this.getModel().getValue("sourcebilltype"))) {
                    DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entrys");
                    for (int i = 0; i < entry.size(); ++i) {
                        this.getModel().setValue("subacct", null, i);
                        this.getModel().setValue("acctgrp", null, i);
                        this.getModel().setValue("pbankacct", null, i);
                    }
                    return;
                }
                this.loadTransDetl();
            }
        } else {
            String oldPk;
            if (callBackId.equals(CHANGE_COMPANY_CALLBACK)) {
                oldPk = this.getPageCache().get(CHANGE_COMPANY_CALLBACK_OLD);
                LOGGER.info("oldPk:{}", (Object)oldPk);
                this.getModel().setValue("company", (Object)oldPk);
                pageCache.remove(CHANGE_COMPANY_CALLBACK_OLD);
                pageCache.remove(CHANGE_COMPANY_CALLBACK);
            }
            if (callBackId.equals(CHANGE_PARENTORG_CALLBACK)) {
                oldPk = this.getPageCache().get(CHANGE_PARENTORG_CALLBACK_OLD);
                LOGGER.info("oldPk:{}", (Object)oldPk);
                this.getModel().setValue("parentorg", (Object)oldPk);
                pageCache.remove(CHANGE_PARENTORG_CALLBACK_OLD);
                pageCache.remove(CHANGE_PARENTORG_CALLBACK);
            }
            if (callBackId.equals(CHANGE_CURRENCY_CALLBACK)) {
                oldPk = this.getPageCache().get(CHANGE_CURRENCY_CALLBACK_OLD);
                LOGGER.info("oldPk:{}", (Object)oldPk);
                this.getModel().setValue("currency", (Object)oldPk);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK_OLD);
                this.getPageCache().remove(CHANGE_CURRENCY_CALLBACK);
            }
        }
    }

    private void initCompany() {
        String appId = this.getView().getFormShowParameter().getAppId();
        IDataModel model = this.getModel();
        String entityName = model.getDataEntityType().getName();
        Long loginOrgId = RequestContext.get().getOrgId();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            DynamicObject transApplyBill;
            DynamicObject currentOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)entityName, (String)"47156aff000000ac");
            if (loginOrgId.longValue() != currentOrg.getLong("id") && null != (transApplyBill = this.getRecTransApplyBill("company", new QFilter[0]))) {
                currentOrg = transApplyBill.getDynamicObject("company");
            }
            model.setValue("company", (Object)currentOrg);
        }
        this.companyChange();
    }

    private void companyChange() {
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return;
        }
        DynamicObjectCollection acctGroups = QueryServiceHelper.query((String)"fca_acctgroup", (String)"company", (QFilter[])new QFilter[]{new QFilter("entrys.bankacct.company", "in", (Object)company.getLong("id"))}, (String)"isdefault desc");
        List parentOrg = acctGroups.stream().map(o -> o.getLong("company")).distinct().collect(Collectors.toList());
        if (parentOrg.size() == 1) {
            model.setValue("parentorg", parentOrg.get(0));
        } else if (parentOrg.size() > 1) {
            QFilter companyFilter = new QFilter("company", "=", (Object)company.getLong("id"));
            DynamicObject applyTransBill = this.getRecTransApplyBill("parentorg", companyFilter);
            if (null != applyTransBill) {
                model.setValue("parentorg", applyTransBill.getDynamicObject("parentorg").getPkValue());
            } else {
                model.setValue("parentorg", parentOrg.get(0));
            }
        } else {
            model.setValue("parentorg", null);
        }
        this.parentOrgChange();
    }

    private void parentOrgChange() {
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
        if (EmptyUtil.isEmpty((DynamicObject)company) || EmptyUtil.isEmpty((DynamicObject)parentOrg)) {
            model.setValue("currency", null);
        } else {
            DynamicObject[] acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"currency,company,bankacct", (QFilter[])new QFilter[]{new QFilter("enable", "in", (Object)"1"), new QFilter("entrys.bankacct.company", "in", (Object)company.getLong("id")), new QFilter("company", "in", (Object)parentOrg.getLong("id"))});
            List currencys = Arrays.stream(acctGroups).map(o -> o.getDynamicObject("currency")).distinct().collect(Collectors.toList());
            if (currencys.size() == 1) {
                model.setValue("currency", ((DynamicObject)currencys.get(0)).getPkValue());
            } else if (currencys.size() > 1) {
                QFilter parentOrgFilter;
                String selectProps = "company,currency,parentorg";
                QFilter companyFilter = new QFilter("company", "=", (Object)company.getLong("id"));
                DynamicObject recTransApplyBill = this.getRecTransApplyBill(selectProps, companyFilter, parentOrgFilter = new QFilter("parentorg", "=", (Object)parentOrg.getLong("id")));
                if (null != recTransApplyBill) {
                    model.setValue("currency", recTransApplyBill.getDynamicObject("currency").getPkValue());
                } else {
                    model.setValue("currency", ((DynamicObject)currencys.get(0)).getPkValue());
                }
            } else {
                model.setValue("currency", null);
            }
        }
        String name = model.getDataEntity().getDataEntityType().getName();
        if ("fca_applytransdownbill".equals(name) && StringUtils.isNotBlank((Object)this.getModel().getValue("sourcebilltype"))) {
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entrys");
            for (int i = 0; i < entry.size(); ++i) {
                this.getModel().setValue("acctgrp", null, i);
                this.getModel().setValue("pbankacct", null, i);
            }
            return;
        }
        this.loadTransDetl();
    }

    private DynamicObject getRecTransApplyBill(String selectProperties, QFilter ... filters) {
        DynamicObject transApplyBill = null;
        QFilter userFilter = new QFilter("createuser", "=", (Object)RequestContext.get().getCurrUserId());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
        filterList.add(userFilter);
        DynamicObject[] transApplyBills = TmcDataServiceHelper.load((String)this.getModel().getDataEntityType().getName(), (String)selectProperties, (QFilter[])filterList.toArray(new QFilter[0]), (String)"createtime desc", (int)1);
        if (transApplyBills.length == 1) {
            transApplyBill = transApplyBills[0];
        }
        return transApplyBill;
    }

    private void initFieldStatus() {
        Object scene = this.getView().getFormShowParameter().getCustomParam("SCENE");
        AmountEdit transAmtEdit = (AmountEdit)this.getControl("transamt");
        transAmtEdit.setMustInput(scene != null && scene.equals("AUDITFLOW"));
    }

    private void loadTransDetl() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        boolean isAdd = SysParameterHelp.getFcaParameterBoolean((long)org.getLong("id"), (String)"defaultentry");
        this.getModel().deleteEntryData("entrys");
        if (isAdd) {
            List<Map<String, Object>> transBillDetls = this.loadAcctGroup();
            TmcViewInputHelper.batchFillEntity((String)"entrys", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), transBillDetls);
            this.calApplySumAmt();
        } else {
            this.getView().invokeOperation("newentry");
        }
    }

    private List<Map<String, Object>> loadAcctGroup() {
        ArrayList<Map<String, Object>> transBillDetls = new ArrayList<Map<String, Object>>();
        IDataModel model = this.getModel();
        String name = model.getDataEntity().getDataEntityType().getName();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!(EmptyUtil.isEmpty((DynamicObject)company) || EmptyUtil.isEmpty((DynamicObject)parentOrg) || EmptyUtil.isEmpty((DynamicObject)currency))) {
            QFilter compFilter = new QFilter("company", "in", parentOrg.getPkValue());
            QFilter currFilter = new QFilter("currency", "in", currency.getPkValue());
            QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
            DynamicObject[] acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"accountbank,bankacct,inneracct,currency, company,isdefault,entrys", (QFilter[])new QFilter[]{compFilter, currFilter, enableFilter}, (String)"entrys.bankacct asc");
            HashMap<Long, Set> map = new HashMap<Long, Set>(16);
            for (DynamicObject acctGroup : acctGroups) {
                long pk = acctGroup.getLong("id");
                if (!acctGroup.getBoolean("isdefault")) continue;
                DynamicObjectCollection sonGroups = acctGroup.getDynamicObjectCollection("entrys");
                for (DynamicObject sonGroup : sonGroups) {
                    DynamicObject bankAcct = sonGroup.getDynamicObject("bankacct");
                    if (bankAcct == null || "fca_applytransdownbill".equals(name) && "out".equals(bankAcct.getString("accttype")) || "fca_applytransupbill".equals(name) && "in".equals(bankAcct.getString("accttype"))) continue;
                    map.computeIfAbsent(sonGroup.getDynamicObject("bankacct").getLong("id"), k -> new HashSet());
                    map.computeIfPresent(sonGroup.getDynamicObject("bankacct").getLong("id"), (k, v) -> {
                        v.add(pk);
                        return v;
                    });
                }
            }
            for (DynamicObject acctGroup : acctGroups) {
                AcctGroupRelInnerAcctHelper.fillInnerAccounts((DynamicObject)acctGroup);
                DynamicObjectCollection sonGroups = acctGroup.getDynamicObjectCollection("entrys");
                for (DynamicObject sonGroup : sonGroups) {
                    Set defaultGroupIdSet;
                    DynamicObject bankAcct = sonGroup.getDynamicObject("bankacct");
                    if (bankAcct == null || "fca_applytransdownbill".equals(name) && "in".equals(bankAcct.getString("accttype")) || "fca_applytransupbill".equals(name) && "out".equals(bankAcct.getString("accttype")) || (defaultGroupIdSet = (Set)map.get(sonGroup.getDynamicObject("bankacct").getLong("id"))) != null && !defaultGroupIdSet.isEmpty() && !defaultGroupIdSet.contains(acctGroup.getLong("id")) || sonGroup.getDynamicObject("bankacct").getLong("company.id") != company.getLong("id")) continue;
                    String acctStatus = sonGroup.getString("bankacct.acctstatus");
                    if (BankAcctStatusEnum.CLOSED.getValue().equals(acctStatus) || BankAcctStatusEnum.FREEZE.getValue().equals(acctStatus)) continue;
                    HashMap<String, Long> dataMap = new HashMap<String, Long>(6);
                    dataMap.put("subacct", sonGroup.getLong("bankacct.id"));
                    dataMap.put("pbankacct", acctGroup.getLong("accountbank.id"));
                    dataMap.put("inneracct", sonGroup.getLong("inneracct.id"));
                    dataMap.put("acctgrp", acctGroup.getLong("id"));
                    transBillDetls.add(dataMap);
                }
            }
        }
        return transBillDetls;
    }

    private void calApplySumAmt() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entityList = model.getEntryEntity("entrys");
        BigDecimal transApplySumAmt = entityList.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("applyamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("amount", (Object)transApplySumAmt);
    }

    private void subAcctChange(Object propValue, int rowIndex) {
        if (!EmptyUtil.isEmpty((Object)propValue)) {
            DynamicObject[] acctGroups;
            DynamicObject subAcct = (DynamicObject)propValue;
            DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            qFilterList.add(new QFilter("entrys.bankacct.id", "=", (Object)subAcct.getLong("id")));
            qFilterList.add(new QFilter("currency.id", "=", (Object)this.getModel().getDataEntity().getLong("currency.id")));
            qFilterList.add(new QFilter("enable", "in", (Object)"1"));
            if (parentOrg != null) {
                qFilterList.add(new QFilter("company", "=", parentOrg.getPkValue()));
            }
            if ((acctGroups = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"accountbank, bankacct, inneracct, company, currency", (QFilter[])qFilterList.toArray(new QFilter[0]))).length == 1) {
                this.getModel().setValue("inneracct", null, rowIndex);
                this.getModel().setValue("pbankacct", null, rowIndex);
                DynamicObject acctGroup = acctGroups[0];
                if (acctGroup.getDynamicObject("accountbank") != null) {
                    this.getModel().setValue("pbankacct", (Object)acctGroup.getDynamicObject("accountbank").getLong("id"), rowIndex);
                }
                DynamicObject acctGroupCompany = acctGroup.getDynamicObject("company");
                DynamicObject currency = acctGroup.getDynamicObject("currency");
                if (acctGroupCompany != null && currency != null) {
                    HashSet<Object> bankAccountIds = new HashSet<Object>(1);
                    bankAccountIds.add(subAcct.getPkValue());
                    Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
                    if (orgInnerAccountMap.containsKey(acctGroupCompany.getPkValue())) {
                        DynamicObjectCollection currencies;
                        List currencyIdList;
                        DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(acctGroupCompany.getPkValue())).get(subAcct.getPkValue());
                        if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                            innerAccount = null;
                        }
                        this.getModel().setValue("inneracct", (Object)innerAccount, rowIndex);
                    }
                }
                this.getModel().setValue("acctgrp", (Object)acctGroup.getLong("id"), rowIndex);
            }
        }
    }

    private void setSubInnerAcctOnLoad() {
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entrys");
            Set bankAccountIds = entries.stream().filter(d -> d.get("subacct") != null).map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            Map orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
            this.getModel().beginInit();
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject subAcct = (DynamicObject)this.getModel().getValue("subacct", i);
                if (currency != null && subAcct != null && parentOrg != null && orgInnerAccountMap.containsKey(parentOrg.getPkValue())) {
                    DynamicObjectCollection currencies;
                    List currencyIdList;
                    DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(parentOrg.getPkValue())).get(subAcct.getPkValue());
                    if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                        innerAccount = null;
                    }
                    this.getModel().setValue("inneracct", (Object)innerAccount, i);
                    continue;
                }
                this.getModel().setValue("inneracct", null, i);
            }
            this.getModel().endInit();
            this.getView().updateView("entrys");
        }
    }

    private void showChangeConfirmDialog(String key) {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        this.getView().showConfirm(new FcaBizResource().getTipConfirm(), MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
    }

    private void loadFields() {
        Object scene = this.getView().getFormShowParameter().getCustomParam("SCENE");
        DynamicObject appTransBill = this.getModel().getDataEntity();
        if ("AUDITFLOW".equals(scene)) {
            AmountEdit amtControl = (AmountEdit)this.getControl("applyamt");
            amtControl.setMustInput(true);
            DynamicObjectCollection entrys = appTransBill.getDynamicObjectCollection("entrys");
            int len = entrys.size();
            for (int i = 0; i < len; ++i) {
                BigDecimal transAmt = ((DynamicObject)entrys.get(i)).getBigDecimal("transamt");
                if (null != transAmt && transAmt.compareTo(Constants.ZERO) != 0) continue;
                this.getModel().setValue("transamt", (Object)((DynamicObject)entrys.get(i)).getBigDecimal("applyamt"), i);
            }
        }
    }
}

