/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.applytransbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.service.model.BalanceModelService;
import kd.tmc.fca.common.helper.AmtCalcHelper;

public class ApplyTransBillEntryEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateBalance();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "subacct": {
                this.updateSubBalance(new int[]{rowIndex});
                break;
            }
            case "inneracct": {
                this.updateInnerBalance(new int[]{rowIndex});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryEntity;
        int[] selectRows;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String opKey = source.getOperateKey();
        if ("refreshbalance".equals(opKey) && (selectRows = (entryEntity = (EntryGrid)this.getView().getControl("entrys")).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApplyTransBillEntryEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entrys");
            int[] selectRows = entryEntity.getSelectRows();
            this.updateSubBalance(selectRows);
            this.updateInnerBalance(selectRows);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int[] selectRows = Arrays.stream(e.getRowDataEntities()).mapToInt(RowDataEntity::getRowIndex).toArray();
        this.updateSubBalance(selectRows);
        this.updateInnerBalance(selectRows);
    }

    private void updateBalance() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        if (!entry.isEmpty()) {
            ArrayList<Integer> rowIndexList = new ArrayList<Integer>(entry.size());
            for (int i = 0; i < entry.size(); ++i) {
                rowIndexList.add(i);
            }
            int[] selectRows = rowIndexList.stream().mapToInt(Integer::intValue).toArray();
            this.updateSubBalance(selectRows);
            this.updateInnerBalance(selectRows);
        }
    }

    private void updateSubBalance(int[] selectRows) {
        boolean isChanged = this.getModel().getDataChanged();
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long pkId = this.getModel().getDataEntity().getLong("id");
        if (org == null || currency == null) {
            this.getModel().beginInit();
            this.getModel().setValue("subcurbalance", null);
            this.getModel().setValue("subvalbalance", null);
            this.getModel().endInit();
            this.getView().updateView("entrys");
            return;
        }
        Long currencyId = currency.getLong("id");
        Long orgId = org.getLong("id");
        String entityKey = this.getModel().getDataEntity().getDataEntityType().getName();
        String balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
        BalanceModelService balanceModelService = new BalanceModelService();
        this.getModel().beginInit();
        for (int i : selectRows) {
            DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("subacct", i);
            if (bankAcct != null) {
                BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId.longValue());
                BigDecimal currentBalance = bizBalanceModelBean.getAmount();
                BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount((String)entityKey, (DynamicObject)bankAcct, (Long)currencyId, (Long)orgId, (Long)pkId, (BigDecimal)currentBalance);
                this.getModel().setValue("subcurbalance", (Object)currentBalance, i);
                this.getModel().setValue("subvalbalance", (Object)usableBalance, i);
                continue;
            }
            this.getModel().setValue("subcurbalance", null, i);
            this.getModel().setValue("subvalbalance", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entrys");
        this.getModel().setDataChanged(isChanged);
    }

    private void updateInnerBalance(int[] selectRows) {
        boolean isChanged = this.getModel().getDataChanged();
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long pkId = this.getModel().getDataEntity().getLong("id");
        if (org == null || currency == null) {
            this.getModel().beginInit();
            this.getModel().setValue("innercurbalance", null);
            this.getModel().setValue("innervalbalance", null);
            this.getModel().endInit();
            this.getView().updateView("entrys");
            return;
        }
        Long currencyId = currency.getLong("id");
        Long orgId = org.getLong("id");
        String entityKey = this.getModel().getDataEntity().getDataEntityType().getName();
        BalanceModelService balanceModelService = new BalanceModelService();
        this.getModel().beginInit();
        for (int i : selectRows) {
            DynamicObject innerBankAcct = (DynamicObject)this.getModel().getValue("inneracct", i);
            if (innerBankAcct != null) {
                DynamicObject bankAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)innerBankAcct);
                BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(BalanceTypeEnum.BALANCE.getValue(), bankAcct.getLong("id"), currencyId.longValue());
                BigDecimal currentBalance = bizBalanceModelBean.getAmount();
                BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount((String)entityKey, (DynamicObject)bankAcct, (Long)currencyId, (Long)orgId, (Long)pkId, (BigDecimal)currentBalance);
                this.getModel().setValue("innercurbalance", (Object)currentBalance, i);
                this.getModel().setValue("innervalbalance", (Object)usableBalance, i);
                continue;
            }
            this.getModel().setValue("innercurbalance", null, i);
            this.getModel().setValue("innervalbalance", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entrys");
        this.getModel().setDataChanged(isChanged);
    }
}

