/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.autotrans;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaOperNameEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;
import kd.tmc.fca.formplugin.provider.GetListDataProvider;
import org.apache.commons.lang.ObjectUtils;

public class AutoTransEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private Log logger = LogFactory.getLog(AutoTransEdit.class);
    private static final String[][] REQUIRED_FIELDS = new String[][]{{"number", "number"}, {"name", "name"}, {"executor", "executor"}, {"sheduleplanid", "txtdesc"}};

    public void registerListener(EventObject e) {
        this.logger.info("testLog registerListener========  ");
        super.registerListener(e);
        this.registerLogFilter();
        this.addClickListeners(new String[]{"txtdesc"});
        BillList cardEntry = (BillList)this.getView().getControl("showlogentry");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        final BillList cardbilllist = (BillList)this.getControl("billlistap");
        BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
        if (EmptyUtil.isEmpty((Object)cardbilllist) || EmptyUtil.isEmpty((Object)acctgroupbilllist)) {
            return;
        }
        cardbilllist.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRow selectCar = evt.getCurrentListSelectedRow();
                if (EmptyUtil.isEmpty((Object)selectCar)) {
                    ListSelectedRowCollection allRow = cardbilllist.getCurrentListAllRowCollection();
                    if (EmptyUtil.isNoEmpty((Object)allRow)) {
                        cardbilllist.clearSelection();
                        cardbilllist.selectRows(0);
                        ListSelectedRow selectedRow = allRow.get(0);
                        if (EmptyUtil.isNoEmpty((Object)selectedRow)) {
                            Object primaryKey = selectedRow.getPrimaryKeyValue();
                            AutoTransEdit.this.loadListData(primaryKey);
                        }
                    }
                } else {
                    Object primaryKey = selectCar.getPrimaryKeyValue();
                    AutoTransEdit.this.loadListData(primaryKey);
                }
            }
        });
        cardbilllist.addHyperClickListener(evt -> {
            Object focusRowPkId = ((BillList)evt.getSource()).getFocusRowPkId();
            String fieldName = evt.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            switch (fieldName) {
                case "acctgroupnumber": {
                    showParameter.setFormId("fca_acctgroup");
                    showParameter.setPkId(focusRowPkId);
                    this.linkShow(showParameter);
                    break;
                }
            }
        });
        acctgroupbilllist.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            Object entryPk = acctgroupbilllist.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
            switch (fieldName) {
                case "bankacct_number": {
                    String entrbankacctsql = "select fentrybankacctid from t_fca_acctgroup_entrys  where fentryid=?";
                    List entrbankacctid = (List)DB.query((DBRoute)DBRouteConst.TMC, (String)entrbankacctsql, (Object[])new Object[]{entryPk}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                        public List<String> handle(ResultSet resultSet) throws Exception {
                            ArrayList<String> entrbankacctid = new ArrayList<String>(resultSet.getRow() + 1);
                            while (resultSet.next()) {
                                entrbankacctid.add(resultSet.getString(1));
                            }
                            return entrbankacctid;
                        }
                    });
                    showParameter.setPkId(entrbankacctid.get(0));
                    showParameter.setFormId("bd_accountbanks");
                    this.linkShow(showParameter);
                    break;
                }
                case "inneracct_number": {
                    DynamicObject innerAcct;
                    String sql = "select fentrybankacctid, fcompanyid from t_fca_acctgroup_entrys t inner join t_fca_acctgroup t1 on t.fid = t1.fid where fentryid=?";
                    AtomicReference entryBankAccountId = new AtomicReference();
                    AtomicReference companyId = new AtomicReference();
                    DB.query((DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[]{entryPk}, resultSet -> {
                        while (resultSet.next()) {
                            entryBankAccountId.set(resultSet.getLong("fentrybankacctid"));
                            companyId.set(resultSet.getLong("fcompanyid"));
                        }
                        return null;
                    });
                    if (entryBankAccountId.get() == null || companyId.get() == null || (innerAcct = BusinessDataServiceHelper.loadSingle((String)"ifm_inneracct", (String)"relationacc", (QFilter[])new QFilter("relationacc.fbasedataid.id", "=", entryBankAccountId.get()).and(new QFilter("org", "=", companyId.get())).toArray())) == null) break;
                    showParameter.setPkId(innerAcct.getPkValue());
                    showParameter.setFormId("ifm_inneracct");
                    this.linkShow(showParameter);
                    break;
                }
            }
        });
        acctgroupbilllist.addSetFilterListener(setFilterEvent -> {
            if (this.getModel().getValue("acctgroup") != null) {
                DynamicObject acctGroup = (DynamicObject)this.getModel().getValue("acctgroup");
                QFilter acctgroupFilter = new QFilter("id", "=", acctGroup.getPkValue());
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                acctgroupFilter.and(new QFilter("entrys.autotransup", "=", pkValue).or(new QFilter("entrys.autotransdown", "=", pkValue)));
                setFilterEvent.getQFilters().add(acctgroupFilter);
            }
        });
    }

    private void registerLogFilter() {
        BillList cardEntry = (BillList)this.getView().getControl("showlogentry");
        cardEntry.addSetFilterListener(setFilterEvent -> {
            setFilterEvent.addCustomQFilter(new QFilter("autotrans", "=", this.getModel().getValue("number")));
            setFilterEvent.setOrderBy("excetime desc");
        });
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        this.registerLogFilter();
    }

    void loadListData(Object primaryKey) {
        BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
        this.getModel().setValue("acctgroup", primaryKey);
        DynamicObject accountbankDO = TmcDataServiceHelper.loadSingle((Object)primaryKey, (String)"fca_acctgroup", (String)"accountbank.bank, accountbank.acctstatus");
        if (accountbankDO != null) {
            if (accountbankDO.getLocaleString("accountbank.bank.name") != null) {
                this.getModel().setValue("bank", (Object)accountbankDO.getLocaleString("accountbank.bank.name").getLocaleValue());
            }
            String acctstatus = accountbankDO.getString("accountbank.acctstatus");
            this.getModel().setValue("acctstatus", (Object)BankAcctStatusEnum.getName((String)acctstatus));
        }
        QFilter acctgroupFilter = new QFilter("id", "=", primaryKey);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        acctgroupFilter.and(new QFilter("entrys.autotransup", "=", pkValue).or(new QFilter("entrys.autotransdown", "=", pkValue)));
        acctgroupbilllist.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new GetListDataProvider()));
        acctgroupbilllist.setFilter(acctgroupFilter);
        acctgroupbilllist.refresh();
    }

    private void linkShow(BaseShowParameter showParameter) {
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if ("execdetl".equals(key)) {
            this.toShowLog(evt);
        }
    }

    private void toShowLog(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("fca_autotranslog");
            showParameter.setPkId(((BillList)evt.getSource()).getFocusRowPkId());
            showParameter.setStatusValue(OperationStatus.VIEW.getValue());
            ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)ShowType.MainNewTabPage, (Object)ShowType.NewTabPage);
            showParameter.getOpenStyle().setShowType(showType);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChanged = this.getModel().getDataChanged();
        this.getPageCache().put("showlog", "0");
        String type = (String)this.getModel().getValue("type");
        this.initOperaBox(type);
        this.getView().setVisible(Boolean.valueOf(FcaTransTypeEnum.TRANSFER.getValue().equals(type)), new String[]{"transferdetail"});
        if ("ADDNEW".equals(this.getView().getFormShowParameter().getStatus().toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applist"});
            boolean exists = false;
            String sheduleplanid = (String)this.getModel().getValue("sheduleplanid");
            if (StringUtils.isNotBlank((CharSequence)sheduleplanid)) {
                exists = TmcDataServiceHelper.exists((String)"fca_autotrans", (QFilter[])new QFilter[]{new QFilter("sheduleplanid", "=", (Object)sheduleplanid)});
            }
            if (!exists) {
                SplitContainer control = (SplitContainer)this.getControl("splitcontainer");
                control.hidePanel(SplitDirection.right, true);
            }
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tbn_executeschema", "tbn_stopexecute", "tbn_refresh"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        QFilter typeFilter = new QFilter("autotrans", "=", this.getModel().getDataEntity().get("number"));
        boolean exists = TmcDataServiceHelper.exists((String)"fca_autotranslog", (QFilter[])new QFilter[]{typeFilter});
        if (exists) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
        }
        if (!FcaTransTypeEnum.TRANSFER.getValue().equals(type)) {
            Label label = (Label)this.getView().getControl("count");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            BillList acctgroupbilllist = (BillList)this.getControl("acctgroupbilllist");
            BillList billlistap = (BillList)this.getControl("billlistap");
            if ((Long)pkValue != 0L) {
                QFilter autotransFilter = new QFilter("entrys.autotransup", "=", pkValue).or(new QFilter("entrys.autotransdown", "=", pkValue));
                QFilter autotransEnableFilter = autotransFilter.and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()));
                boolean acctexists = TmcDataServiceHelper.exists((String)"fca_acctgroup", (QFilter[])new QFilter[]{autotransEnableFilter});
                if (acctexists) {
                    billlistap.setFilter(autotransEnableFilter);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"applist"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap"});
                }
                Object[] acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"id,name", (QFilter[])new QFilter[]{autotransEnableFilter});
                if (!EmptyUtil.isEmpty((Object[])acctGroups)) {
                    acctgroupbilllist.setFilter(autotransEnableFilter);
                    acctgroupbilllist.refresh();
                    ListSelectedRowCollection currRows = acctgroupbilllist.getCurrentListAllRowCollection();
                    String total = String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u6bcd\u5b50\u8d26\u6237\u7ec4\uff0c\u5171%2$s\u4e2a\u5b50\u8d26\u6237\u3002", (String)"AutoTransEdit_01", (String)"tmc-fca-formplugin", (Object[])new Object[0]), acctGroups.length, currRows.size());
                    label.setText(total);
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"applist"});
                }
            } else {
                billlistap.setFilter(new QFilter("name", "=", null));
            }
            billlistap.refresh();
            ListSelectedRowCollection allRow = billlistap.getCurrentListAllRowCollection();
            if (EmptyUtil.isNoEmpty((Object)allRow)) {
                billlistap.clearSelection();
                billlistap.selectRows(0);
                ListSelectedRow selectedRow = allRow.get(0);
                if (EmptyUtil.isNoEmpty((Object)selectedRow)) {
                    Object primaryKey = selectedRow.getPrimaryKeyValue();
                    this.loadListData(primaryKey);
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applist"});
        }
        this.getModel().setDataChanged(dataChanged);
    }

    protected void loadAutoTransLog() {
        BillList cardEntry = (BillList)this.getView().getControl("showlogentry");
        cardEntry.refreshData();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("txtdesc".equalsIgnoreCase(key)) {
            IBillModel billmodel = (IBillModel)this.getModel();
            long id = (Long)billmodel.getValue("id");
            if (StringUtils.isBlank((Object)id) || id == 0L) {
                String tableName = billmodel.getDataEntityType().getAlias();
                long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
                id = ids[0];
                billmodel.getDataEntity().set("id", (Object)id);
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setAppId("iep");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("sch_schedule");
            String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
            if (scheduleId == null || scheduleId.trim().length() == 0) {
                parameter.setStatus(OperationStatus.ADDNEW);
                String idJson = "{\"intellSchemaidList\":[{\"Id\":" + id + "}]}";
                parameter.setCustomParam("paramjsonstr", (Object)idJson);
                parameter.setCustomParam("taskclassname", (Object)"kd.fi.iep.task.IntellExceTask");
                parameter.setCustomParam("taskdefineid", (Object)"/=H=I/HPK3MH");
                parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212\u3002", (String)"AutoTransEdit_03", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                parameter.setCustomParam("tasknumber", (Object)("iep_autocreate" + System.currentTimeMillis()));
                parameter.setCustomParam("taskappnumber", (Object)"iep");
                DynamicObject executor = (DynamicObject)billmodel.getValue("executor");
                if (executor != null) {
                    parameter.setCustomParam("executor", executor.get("id"));
                }
            } else {
                parameter.setPkId((Object)scheduleId);
                parameter.setStatus(OperationStatus.EDIT);
            }
            parameter.setHasRight(true);
            parameter.setCustomParam("frombiz", (Object)"true");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
            StyleCss css1 = new StyleCss();
            css1.setWidth("800");
            css1.setHeight("700");
            parameter.getOpenStyle().setInlineStyleCss(css1);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isExist;
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        Object scheduleId = this.getModel().getValue("sheduleplanid");
        if (StringUtils.isNotBlank((Object)scheduleId) && !(isExist = QueryServiceHelper.exists((String)"fca_autotrans", (Object)id))) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sch_schedule"), (Object[])new Object[]{scheduleId});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        DynamicObject scheduleInfo;
        Object rtn;
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("newshedule") && (rtn = e.getReturnData()) != null && (scheduleInfo = (DynamicObject)rtn) != null) {
            Date starttime = scheduleInfo.getDate("starttime");
            this.getModel().setValue("starttime", (Object)starttime);
            Date endtime = scheduleInfo.getDate("endtime");
            this.getModel().setValue("endtime", (Object)endtime);
            String txtdesc = (String)scheduleInfo.get("txtdesc");
            if (txtdesc.length() > 255) {
                txtdesc = txtdesc.substring(0, 200) + "...";
            }
            this.getModel().setValue("txtdesc", (Object)txtdesc);
            String sheduleplanid = (String)scheduleInfo.get("id");
            this.getModel().setValue("sheduleplanid", (Object)sheduleplanid);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && (oper = (AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            this.initDataFilter();
            if (!this.checkDraft()) {
                args.cancel = true;
            }
        }
    }

    private void initDataFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || !filteList.isEmpty()) {
            return;
        }
        SimpleFilterRow simpleFilterRow = new SimpleFilterRow();
        ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>();
        FilterValue filterValue = new FilterValue();
        filterValue.setValue(this.getModel().getValue("number"));
        filterValues.add(filterValue);
        simpleFilterRow.setValue(filterValues);
        simpleFilterRow.setCompareType("67");
        simpleFilterRow.setFieldName("number");
        simpleFilterRow.setLogic("0");
        filteList.add(simpleFilterRow);
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        this.getModel().setValue("datafilter", (Object)filterJson);
    }

    private boolean checkDraft() {
        IDataModel datamodel = this.getView().getModel();
        Object number = datamodel.getValue("number");
        String errField = null;
        for (int i = 0; i < REQUIRED_FIELDS.length; ++i) {
            String field = REQUIRED_FIELDS[i][0];
            Object val = this.getModel().getValue(field);
            if (val != null && !StringUtils.isBlank((Object)val)) continue;
            FieldEdit control = (FieldEdit)this.getControl(REQUIRED_FIELDS[i][1]);
            errField = control.getProperty().getDisplayName().toString();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"AutoTransEdit_04", (String)"tmc-fca-formplugin", (Object[])new Object[0]), errField));
            control.setFocus(true);
            return false;
        }
        long id = (Long)datamodel.getValue("id");
        DynamicObject checkNumber = QueryServiceHelper.queryOne((String)"fca_autotrans", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        if (checkNumber != null && id != checkNumber.getLong("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AutoTransEdit_05", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String sheduleplanid;
        boolean exists;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperateKey().equals("save")) {
            String newValueStr;
            String oldValue = this.getPageCache().get("executorId");
            IDataModel dataModel = this.getModel();
            Object newValue = dataModel.getValue("executor_id");
            String string = newValueStr = StringUtils.isBlank((Object)newValue) ? "0" : newValue.toString();
            if (!newValueStr.equals(oldValue)) {
                String sheduleplanid2 = (String)this.getModel().getValue("sheduleplanid");
                if (StringUtils.isBlank((CharSequence)sheduleplanid2)) {
                    return;
                }
                DynamicObject sch = TmcDataServiceHelper.loadSingle((Object)sheduleplanid2, (String)"sch_schedule");
                sch.set("name", this.getModel().getValue("name"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sch});
                DynamicObject schJob = sch.getDynamicObject("job");
                if (schJob == null) {
                    return;
                }
                DynamicObject[] jobs = TmcDataServiceHelper.load((String)"sch_job", (String)"id, runbyuser, runbylang", (QFilter[])new QFilter[]{new QFilter("id", "=", schJob.get("id"))});
                if (jobs == null || jobs.length == 0) {
                    return;
                }
                MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                DynamicObject userInfo = new DynamicObject((DynamicObjectType)userType);
                userInfo.set("id", (Object)Long.valueOf(newValueStr));
                jobs[0].set("name", this.getModel().getValue("name"));
                jobs[0].set("runbyuser", (Object)userInfo);
                jobs[0].set("runbylang", (Object)Lang.get().toString());
                OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (DynamicObject[])new DynamicObject[]{jobs[0]}, (OperateOption)OperateOption.create());
                this.getPageCache().put("executorId", newValueStr);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tbn_executeschema", "tbn_stopexecute", "tbn_refresh"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            SplitContainer control = (SplitContainer)this.getControl("splitcontainer");
            control.hidePanel(SplitDirection.right, false);
            this.loadAutoTransLog();
        } else if (afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperateKey().equals("executeschema")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
            SplitContainer control = (SplitContainer)this.getControl("splitcontainer");
            control.hidePanel(SplitDirection.right, false);
            this.loadAutoTransLog();
        } else if (!afterDoOperationEventArgs.getOperateKey().equals("save") && !(exists = TmcDataServiceHelper.exists((String)"fca_autotrans", (QFilter[])new QFilter[]{new QFilter("sheduleplanid", "=", (Object)(sheduleplanid = (String)this.getModel().getValue("sheduleplanid")))})) && EmptyUtil.isNotEmpty((CharSequence)sheduleplanid) && ExecutorService.getInstance() != null) {
            DynamicObject sch = TmcDataServiceHelper.loadSingle((Object)sheduleplanid, (String)"sch_schedule");
            DynamicObject schJob = sch.getDynamicObject("job");
            if (schJob != null) {
                String jobId = schJob.getString("id");
                ExecutorService.getInstance().getObjectFactory().getJobDao().delete(jobId);
            }
            ExecutorService.getInstance().getObjectFactory().getScheduleDao().delete(sheduleplanid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("type".equals(e.getProperty().getName())) {
            this.getView().setVisible(Boolean.valueOf(FcaTransTypeEnum.TRANSFER.getValue().equals(e.getChangeSet()[0].getNewValue())), new String[]{"transferdetail"});
            this.initOperaBox((String)e.getChangeSet()[0].getNewValue());
        }
    }

    private void initOperaBox(String type) {
        ArrayList<ComboItem> bankVersionItems = new ArrayList<ComboItem>();
        if (FcaTransTypeEnum.TRANSFER.getValue().equals(type)) {
            bankVersionItems.add(new ComboItem(new LocaleString(FcaOperNameEnum.SAVE_TRANSFER_APPLY.getName()), FcaOperNameEnum.SAVE_TRANSFER_APPLY.getValue()));
        } else {
            bankVersionItems.add(new ComboItem(new LocaleString(FcaOperNameEnum.DOSUBMITBEI.getName()), FcaOperNameEnum.DOSUBMITBEI.getValue()));
            bankVersionItems.add(new ComboItem(new LocaleString(FcaOperNameEnum.DOSAVE.getName()), FcaOperNameEnum.DOSAVE.getValue()));
        }
        ComboEdit opera = (ComboEdit)this.getControl("opername");
        opera.setComboItems(bankVersionItems);
    }
}

