/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.autotrans;

import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.ExecstatusEnum;
import kd.tmc.fca.common.enums.FcaOperNameEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;

public class AutoTransLogEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid control = (EntryGrid)this.getControl("entry");
        control.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid control1 = (EntryGrid)this.getControl("entry2");
        control1.addHyperClickListener((HyperLinkClickListener)this);
        ((TextEdit)this.getView().getControl("autotrans")).addButtonClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject autoTransLog = this.getModel().getDataEntity();
        String type = autoTransLog.getString("type");
        boolean isTransfer = FcaTransTypeEnum.TRANSFER.getValue().equals(type);
        this.getView().setVisible(Boolean.valueOf(!isTransfer), new String[]{"entry"});
        this.getView().setVisible(Boolean.valueOf(isTransfer), new String[]{"entry2"});
        if (isTransfer) {
            return;
        }
        DynamicObjectCollection entrys = autoTransLog.getDynamicObjectCollection("entry");
        List bills = entrys.stream().filter(v -> v.getString("status").equals(ExecstatusEnum.SUCCESS.getValue())).map(v -> v.getString("billno")).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(bills)) {
            String entityName = type.equals("transup") ? "fca_transupbill" : (type.equals("transdown") ? "fca_transdownbill" : "");
            Object[] transBills = TmcDataServiceHelper.load((String)entityName, (String)"billno,entrys,paystatus,subacct", (QFilter[])new QFilter[]{new QFilter("billno", "in", bills)});
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String billno = entry.getString("billno");
                String status = entry.getString("status");
                if (!status.equals(ExecstatusEnum.SUCCESS.getValue())) continue;
                String execDetl = "";
                if (EmptyUtil.isEmpty((Object[])transBills)) {
                    execDetl = ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5df2\u6210\u529f\u751f\u6210\uff0c\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"AutoTransLogEdit_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]);
                } else {
                    DynamicObject transBill = Stream.of(transBills).filter(v -> v.getString("billno").equals(billno)).findFirst().orElse(null);
                    if (null == transBill) {
                        execDetl = ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5df2\u6210\u529f\u751f\u6210\uff0c\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"AutoTransLogEdit_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]);
                    } else {
                        DynamicObjectCollection billEntrys = transBill.getDynamicObjectCollection("entrys");
                        Optional<DynamicObject> option = billEntrys.stream().filter(v -> v.getDynamicObject("subacct").getPkValue().equals(entry.getDynamicObject("sbankacct").getPkValue())).findFirst();
                        if (option.isPresent()) {
                            String payStatus = FcaTransPayStatusEnum.getName((String)option.get().getString("paystatus"));
                            execDetl = EmptyUtil.isEmpty((String)payStatus) ? entry.getString("detail") : String.format(ResManager.loadKDString((String)"\u5212\u62e8\u5355\u751f\u6210\u6210\u529f\uff0c\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\uff1a%s\u3002", (String)"AutoTransLogEdit_3", (String)"tmc-fca-formplugin", (Object[])new Object[0]), payStatus);
                        }
                    }
                }
                this.getModel().setValue("detail", (Object)execDetl, i);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key;
        switch (key = evt.getFieldName()) {
            case "billno": 
            case "e_billno": {
                String type = this.getModel().getDataEntity().getString("type");
                String entityName = null;
                String billNoKey = "billno";
                String entryKey = "entry";
                if (FcaTransTypeEnum.TRANSUP.getValue().equals(type)) {
                    entityName = "fca_transupbill";
                } else if (FcaTransTypeEnum.TRANSDOWN.getValue().equals(type)) {
                    entityName = "fca_transdownbill";
                } else if (FcaTransTypeEnum.TRANSFER.getValue().equals(type)) {
                    billNoKey = "e_billno";
                    entryKey = "entry2";
                    String operateName = this.getModel().getDataEntity().getString("opername");
                    if (FcaOperNameEnum.SAVE_TRANSFER_APPLY.getValue().equals(operateName) || FcaOperNameEnum.SUBMIT_TRANSFER_APPLY.getValue().equals(operateName)) {
                        entityName = "cas_transferapply";
                    } else if (FcaOperNameEnum.SAVE_TRANSFER.getValue().equals(operateName) || FcaOperNameEnum.SAVE_TRANSFER_SUBMIT_BEI.getValue().equals(operateName)) {
                        entityName = "cas_paybill_spanmainpart";
                    }
                }
                if (!EmptyUtil.isNoEmpty((String)entityName)) break;
                int rowIndex = evt.getRowIndex();
                DynamicObject entryRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
                DynamicObject transBill = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)entryRow.getString(billNoKey))});
                if (EmptyUtil.isEmpty((DynamicObject)transBill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"AutoTransLogEdit_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                this.showForm(entityName, transBill);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control key = (Control)evt.getSource();
        String keyName = key.getKey();
        if ("autotrans".equals(keyName)) {
            String number = this.getModel().getDataEntity().getString("autotrans");
            DynamicObject autotrans = TmcDataServiceHelper.loadSingle((String)"fca_autotrans", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            this.showForm("fca_autotrans", autotrans);
        }
    }

    private void showForm(String entityName, DynamicObject targetObj) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId(entityName);
        parameter.setPkId(targetObj.getPkValue());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

