/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class DownRuleEdit
extends AbstractBasePlugIn
implements ClickListener {
    private static final String NON_FIELDS = "non_fields";
    private static final int MAX_LENGTH = 1024;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"e_datafilterdesc"});
        this.fillOrgF7();
    }

    private void fillOrgF7() {
        BasedataEdit uOrgF7 = (BasedataEdit)this.getControl("u_org");
        uOrgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection orges = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"fca_downrule", (String)"47156aff000000ac");
            ArrayList<Long> orgList = new ArrayList<Long>(orges.size());
            for (DynamicObject org : orges) {
                orgList.add(org.getLong("id"));
            }
            showParameter.setCustomParam("range", orgList);
            DynamicObjectCollection uEntry = this.getModel().getEntryEntity("org_entry");
            int row = evt.getRow();
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)uEntry)) {
                ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
                for (int i = 0; i < uEntry.size(); ++i) {
                    DynamicObject uEntryDO = (DynamicObject)uEntry.get(i);
                    if (i == row || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO) || !EmptyUtil.isNoEmpty((DynamicObject)uEntryDO.getDynamicObject("u_org"))) continue;
                    yetChooseIdList.add((Long)uEntryDO.getDynamicObject("u_org").getPkValue());
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgList).and(new QFilter("id", "not in", yetChooseIdList)));
            } else {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", orgList));
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "e_datafilterdesc": {
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.fillFields();
                this.showConditionForm(index, this.getPageCache().get("e_datafilter"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "e_datafilterdesc": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getPageCache().put("e_datafilter", "");
                this.getModel().setValue("e_datafilter", (Object)"", rowIndex);
                this.getModel().setValue("e_datafilter_TAG", (Object)"", rowIndex);
                break;
            }
        }
    }

    private void showConditionForm(int rowIndex, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fca_condition");
        String conditionJson = (String)this.getModel().getValue("e_datafilter_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", "fca_applytransdownbill");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String functionXml = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)functionXml)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            functionXml = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", functionXml);
        }
        showParameter.getCustomParams().put("functiontypes", functionXml);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "e_datafilter"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("e_datafilter".equals(e.getActionId())) {
            this.receiveExpressionSet(e);
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue("e_datafilter", (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue("e_datafilter_TAG", (Object)str, row);
                String desc = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desc = filterObj.getExprTran();
                }
                if (desc.length() > 1024) {
                    desc = desc.substring(0, 1024);
                }
                this.getModel().setValue("e_datafilterdesc", (Object)desc, row);
            }
        }
    }

    private void fillFields() {
        MainEntityType srcMainEntityType = EntityMetadataCache.getDataEntityType((String)"fca_applytransdownbill");
        if (srcMainEntityType == null) {
            this.getPageCache().put("e_datafilter", "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainEntityType);
            option.setReadEntryEntity(false);
            option.setExprType(ExpressionType.Condition);
            option.setFieldType(null);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put("e_datafilter", toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }
}

