/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transbill;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillChgPayEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"paychan", (CharSequence)propName)) {
            Object newPayChannel = e.getChangeSet()[0].getNewValue();
            this.getModel().beginInit();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entrys");
            for (int i = 0; i < entries.size(); ++i) {
                this.getModel().setValue("subpaychan", newPayChannel, i);
            }
            this.getModel().endInit();
            this.getView().updateView("entrys");
        }
    }

    private Pair<String, Boolean> addEntrys(DynamicObject transBill) {
        DynamicObjectCollection entrys = transBill.getDynamicObjectCollection("entrys");
        String paychanel = null;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("subacct_company", new Object[0]).addField("subacct", new Object[0]).addField("transamt", new Object[0]).addField("remark", new Object[0]).addField("subpaychan", new Object[0]).addField("sourceentryid", new Object[0]);
        boolean hasEntry = false;
        boolean isOpenBeiAll = true;
        for (DynamicObject entry : entrys) {
            DynamicObject bankAcct;
            String state = entry.getString("state");
            String payStatus = entry.getString("paystatus");
            if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransDetailStatusEnum.DELETE.getValue().equals(state) || !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus)) continue;
            paychanel = entry.getString("paychanel");
            vs.addRow(new Object[]{entry.getDynamicObject("subacct_company").getPkValue(), entry.getDynamicObject("subacct").getPkValue(), entry.get("transamt"), entry.get("remark"), paychanel, entry.getPkValue()});
            hasEntry = true;
            if (!isOpenBeiAll || !"fca_transupbill".equals(transBill.getDataEntityType().getName()) || (bankAcct = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("subacct").getPkValue(), (String)"bd_accountbanks")).getBoolean("issetbankinterface")) continue;
            isOpenBeiAll = false;
        }
        if (!hasEntry) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4ed8\u6b3e\u5931\u8d25\u7684\u660e\u7ec6\uff0c\u65e0\u6cd5\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillChgPayEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return Pair.of((Object)"", (Object)Boolean.FALSE);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entrys", vs);
        this.getView().updateView("entrys");
        return Pair.of(paychanel, (Object)isOpenBeiAll);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChanged = this.getModel().getDataChanged();
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam("sourceType");
        if (EmptyUtil.isEmpty((String)sourceType)) {
            String paychan = (String)this.getModel().getValue("paychan");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            if (FcaTransPayChanEnum.BEI.getValue().equals(paychan)) {
                items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.BEI.getName()), FcaTransPayChanEnum.BEI.getValue()));
            }
            if (FcaTransPayChanEnum.ONLINE.getValue().equals(paychan)) {
                items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.ONLINE.getName()), FcaTransPayChanEnum.ONLINE.getValue()));
            }
            if (FcaTransPayChanEnum.COUNTER.getValue().equals(paychan)) {
                items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.COUNTER.getName()), FcaTransPayChanEnum.COUNTER.getValue()));
            }
            ComboEdit paychanEdit = (ComboEdit)this.getControl("paychan");
            paychanEdit.setComboItems(items);
            if (!EmptyUtil.isEmpty(items)) {
                this.getModel().setValue("paychan", (Object)((ComboItem)items.get(0)).getValue());
            }
            return;
        }
        Long sourceId = (Long)this.getView().getFormShowParameter().getCustomParam("sourceId");
        DynamicObject transBill = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceId, (String)sourceType);
        IDataModel m = this.getModel();
        m.setValue("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        m.setValue("company", transBill.getDynamicObject("company").getPkValue());
        m.setValue("accountbank", transBill.getDynamicObject("accountbank").getPkValue());
        m.setValue("amount", transBill.get("amount"));
        m.setValue("currency", transBill.getDynamicObject("currency").getPkValue());
        m.setValue("sourcebillno", transBill.get("billno"));
        m.setValue("sourcebillid", transBill.getPkValue());
        m.setValue("sourcebilltype", (Object)sourceType);
        Pair<String, Boolean> entryPair = this.addEntrys(transBill);
        m.setValue("prevpaychan", entryPair.getLeft());
        DynamicObject acct = (DynamicObject)this.getModel().getValue("accountbank");
        boolean isOpenBei = acct.getBoolean("issetbankinterface");
        ComboEdit paychanEdit = (ComboEdit)this.getControl("paychan");
        String prePaychan = (String)this.getModel().getValue("prevpaychan");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (isOpenBei && !FcaTransPayChanEnum.BEI.getValue().equals(prePaychan) && "fca_transdownbill".equals(transBill.getDataEntityType().getName())) {
            items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.BEI.getName()), FcaTransPayChanEnum.BEI.getValue()));
        } else if (!FcaTransPayChanEnum.BEI.getValue().equals(prePaychan) && "fca_transupbill".equals(transBill.getDataEntityType().getName()) && ((Boolean)entryPair.getRight()).booleanValue()) {
            items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.BEI.getName()), FcaTransPayChanEnum.BEI.getValue()));
        }
        if (!FcaTransPayChanEnum.ONLINE.getValue().equals(prePaychan)) {
            items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.ONLINE.getName()), FcaTransPayChanEnum.ONLINE.getValue()));
        }
        if (!FcaTransPayChanEnum.COUNTER.getValue().equals(prePaychan)) {
            items.add(new ComboItem(new LocaleString(FcaTransPayChanEnum.COUNTER.getName()), FcaTransPayChanEnum.COUNTER.getValue()));
        }
        paychanEdit.setComboItems(items);
        this.getModel().setDataChanged(dataChanged);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }
}

