/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transbill;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.property.FcaTransBillProp;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.model.BalanceModelService;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.helper.AcctGroupRelInnerAcctHelper;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.AmtValidateHelper;
import kd.tmc.fca.common.helper.SystemParameterHelper;
import kd.tmc.fca.common.util.SysParameterHelp;

public class TransBillEdit
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(TransBillEdit.class);
    public static final String CHANGE_ACCTGROUP_CALLBACK = "CHANGE_ACCTGROUP_CALLBACK";
    public static final String CHANGE_ACCTGROUP_CALLBACK_OLD = "CHANGE_ACCTGROUP_CALLBACK_OLD";
    public static final String DISCARD_PAY_CALLBACK = "DISCARD_PAY_CALLBACK";
    public static final String PAY_CALLBACK = "PAY_CALLBACK";
    public static final String ISUNACCTGROUP = "isunacctgroup";
    private static final String[] staticNameArr = new String[]{"bar_refresh", "bar_save", "bar_del", "bardiscard", "bar_submit", "barcopy", "barcheck", "tblchecksource"};
    private static final String[] staticNameArr2 = new String[]{"bar_refresh", "bar_unsubmit", "bar_audit", "barcopy", "barcheck", "tblchecksource"};
    private static final String[] staticNameArr3 = new String[]{"bar_refresh", "bar_unaudit", "barpay", "barpaybei", "barpayconfirm", "barchange", "barchangepaytype", "bardiscarddetail", "barcheck", "tblchecksource"};
    private static final String[] staticNameArr4 = new String[]{"bar_refresh", "barcopy", "barcheck", "tblchecksource"};
    private static final String[] staticNameArr5 = new String[]{"bar_refresh", "bar_refresh", "barpaycancel", "barcopy", "barcheck", "tblchecksource", "tblcheckbak"};
    private static final String[] button = new String[]{"generatevoucher", "deletevoucher", "previewvoucher"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"company", evt -> new QFilter("id", "in", this.getAuthAcctGroupList()));
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"acctgrpid", evt -> {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (company == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"TransBillEdit_32", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return null;
            }
            evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANGE_ACCTGROUP_CALLBACK));
            return new QFilter("company", "=", (Object)company.getLong("id"));
        });
        DynamicObject accountGroup = (DynamicObject)this.getModel().getValue("acctgrpid");
        BasedataEdit accountGroupF7 = (BasedataEdit)this.getView().getControl("acctgrpid");
        accountGroupF7.addAfterF7SelectListener(afterF7SelectEvent -> {
            boolean isChange;
            Object returnData = afterF7SelectEvent.getInputValue();
            String pk = accountGroup != null ? accountGroup.getPkValue().toString() : "";
            boolean bl = isChange = returnData != null && !Objects.equals(returnData.toString(), pk);
            if (isChange) {
                this.getPageCache().put(CHANGE_ACCTGROUP_CALLBACK, returnData.toString());
                this.getPageCache().put(CHANGE_ACCTGROUP_CALLBACK_OLD, pk);
                this.showChangeConfirmDialog(CHANGE_ACCTGROUP_CALLBACK);
            }
        });
        if (this.enableBankAcct()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountbank"});
            TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"accountbank", evt -> {
                DynamicObject company = (DynamicObject)this.getModel().getValue("company");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (company == null || currency == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d44\u91d1\u7ec4\u7ec7\u3001\u5e01\u79cd\u3002", (String)"TransBillEdit_25", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return null;
                }
                return new QFilter("id", "in", this.getAcctBankIds(company, currency));
            });
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountbank"});
        }
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"subacct", evt -> {
            DynamicObject acctGroup = (DynamicObject)this.getModel().getValue("acctgrpid");
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("accountbank");
            if (company == null || bankAcct == null || acctGroup == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\u540e\u518d\u5f55\u5165\u660e\u7ec6\uff1a\u6bcd\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\uff0c\u6bcd\u5b50\u8d26\u6237\u7ec4\uff0c\u6bcd\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u3002", (String)"TransBillEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return null;
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String sourceType = (String)this.getModel().getValue("sourcetype");
            boolean isMultiSelect = FcaTransSourceTypeEnum.MANUAL.getValue().equals(sourceType) || FcaTransSourceTypeEnum.AUTOTRAN.getValue().equals(sourceType);
            showParameter.setMultiSelect(isMultiSelect);
            List subAcctList = acctGroup.getDynamicObjectCollection("entrys").stream().map(dynamicObject -> (DynamicObject)dynamicObject.get("bankacct")).collect(Collectors.toList());
            if (subAcctList.isEmpty()) {
                return null;
            }
            QFilter bankAcctIdFilter = new QFilter("id", "in", subAcctList.stream().filter(Objects::nonNull).map(dynamicObject -> dynamicObject.get("id")).collect(Collectors.toList()));
            bankAcctIdFilter.and(new QFilter("acctstatus", "not in", (Object)new String[]{BankAcctStatusEnum.CLOSED.getValue(), BankAcctStatusEnum.FREEZE.getValue()}));
            return bankAcctIdFilter;
        });
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"inneracct", evt -> {
            if (Objects.isNull(this.getModel().getValue("subacct_company"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b50\u8d26\u6237\u8d44\u91d1\u7ec4\u7ec7\u201c\u3002", (String)"TransBillEdit_26", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return null;
            }
            QFilter companyFilter = new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("subacct_company")).getPkValue());
            QFilter cnyFilter = new QFilter("currency.fbasedataid.id", "=", ((DynamicObject)this.getModel().getValue("currency")).getPkValue());
            QFilter innerAccQFilter = new QFilter("finorgtype", "=", (Object)"1");
            companyFilter.and(innerAccQFilter).and(cnyFilter).and(this.getAccountFilter());
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (company != null) {
                QFilter typeFilter = new QFilter("finorgtype.type", "=", (Object)"1");
                QFilter orgFilter = new QFilter("org.id", "=", company.getPkValue());
                DynamicObjectCollection bdFinorginfo = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{typeFilter.and(orgFilter)});
                if (bdFinorginfo.isEmpty()) {
                    return companyFilter;
                }
                List bds = bdFinorginfo.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
                companyFilter.and(new QFilter("bank", "in", bds));
            }
            return companyFilter;
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountbank"});
        if (this.enableBankAcct()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountbank"});
        }
        if (org != null) {
            this.initAcctGroupAndBanKAndCur();
            if (null == this.getModel().getValue("transbilldate")) {
                this.filltranbillDate();
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection bankIdDos;
        Map<Long, DynamicObject> idMapBank;
        Set bankIdSet;
        super.afterImportData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && EmptyUtil.isNoEmpty(bankIdSet = entryEntity.stream().map(o -> {
            DynamicObject bank;
            DynamicObject subAcct = o.getDynamicObject("subacct");
            if (EmptyUtil.isNoEmpty((DynamicObject)subAcct) && EmptyUtil.isNoEmpty((DynamicObject)(bank = subAcct.getDynamicObject("bank")))) {
                return bank.getPkValue();
            }
            return 0;
        }).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty(idMapBank = (bankIdDos = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank.id beBankId,bebank.country.id countryid,bebank.provincetxt,bebank.citytxt", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIdSet)})).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v)))) {
            for (DynamicObject entry : entryEntity) {
                DynamicObject bankDo;
                DynamicObject subAcct = entry.getDynamicObject("subacct");
                if (!EmptyUtil.isNoEmpty((DynamicObject)subAcct)) continue;
                entry.set("subacct_company", (Object)subAcct.getDynamicObject("company"));
                DynamicObject bank = subAcct.getDynamicObject("bank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bank) || !EmptyUtil.isNoEmpty((DynamicObject)(bankDo = idMapBank.get(bank.getPkValue())))) continue;
                entry.set("entrycountry_id", (Object)bankDo.getLong("countryid"));
                entry.set("entryprovince", bankDo.get("bebank.provincetxt"));
                entry.set("entrycity", bankDo.get("bebank.citytxt"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        String formId;
        super.afterBindData(e);
        boolean isChanged = this.getModel().getDataChanged();
        this.handleSourceType();
        this.handleTbmainButton();
        this.setEntrtySumAmount();
        this.handleBtnShow();
        this.calcRefTransAmts();
        this.calcTotalAmtAndCount();
        Object billstatus = this.getModel().getValue("billstatus");
        if (this.isBotpNew() || BillStatusEnum.SAVE.getValue().equals(billstatus) || BillStatusEnum.SUBMIT.getValue().equals(billstatus)) {
            DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
            if (accountBank != null) {
                this.initBankInfo(accountBank.getDynamicObject("bank"), "", 0);
            }
            this.setEntryRecBankInfo();
        }
        if ("fca_transdownbill".equals(formId = this.getModel().getDataEntity().getDataEntityType().getName())) {
            this.updateBalance();
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountbank"});
        if (this.enableBankAcct()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"accountbank"});
        }
        this.getModel().setDataChanged(isChanged);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        super.afterDoOperation(afterDoOperationEventArgs);
        this.handleSourceType();
        HashMap refButtons = new HashMap();
        refButtons.put("barpayconfirm", null);
        refButtons.put("paycancel", null);
        refButtons.put("barpaybei", null);
        refButtons.put("discard", null);
        refButtons.put("discarddetail", null);
        refButtons.put("bar_submit", null);
        refButtons.put("bar_unsubmit", null);
        refButtons.put("unsubmit", null);
        refButtons.put("bar_audit", null);
        refButtons.put("bar_unaudit", null);
        refButtons.put("unaudit", null);
        refButtons.put("bardiscarddetail", null);
        refButtons.put("save", null);
        refButtons.put("audit", null);
        refButtons.put("submit", null);
        if (refButtons.containsKey(opKey) && afterDoOperationEventArgs.getOperationResult().getValidateResult().isSuccess() && !"save".equals(opKey) && !"submit".equals(opKey)) {
            this.getView().invokeOperation("refresh");
        }
        if (refButtons.containsKey(opKey)) {
            this.handleTbmainButton();
        }
        this.handleBtnShow();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("accountbank".equals(propName)) {
            this.updateAcctBank();
            this.initPayChannel();
            String formId = this.getModel().getDataEntity().getDataEntityType().getName();
            if ("fca_transdownbill".equals(formId)) {
                this.updateBalance();
            }
        } else if ("transamt".equals(propName) || "state".equals(propName)) {
            this.calcTotalAmtAndCount();
        } else if ("subacct".equals(propName)) {
            Object newValue = changeSet[0].getNewValue();
            int currentIndex = changeSet[0].getRowIndex();
            if (newValue != null) {
                DynamicObject newSubAcct = (DynamicObject)newValue;
                this.getModel().setValue("subacct_company", newSubAcct.getDynamicObject("company").getPkValue(), currentIndex);
                this.initBankInfo(newSubAcct.getDynamicObject("bank"), "entry", currentIndex);
            } else {
                this.getModel().setValue("subacct_company", null, currentIndex);
                this.initBankInfo(null, "entry", currentIndex);
            }
            this.calcRefTransAmt(currentIndex);
            this.initPayChannel();
        } else if ("paychanel".equals(propName)) {
            this.updatePayChannel(changeSet[0]);
        } else if ("acctgrpid".equals(propName)) {
            DynamicObject acctGroup = (DynamicObject)changeSet[0].getNewValue();
            if (acctGroup == null) {
                this.clearEntry();
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("currency", null);
            } else {
                this.getModel().setValue("accountbank", acctGroup.get("accountbank"));
                this.getModel().setValue("currency", acctGroup.get("currency"));
            }
        } else if ("inneracct".equals(propName)) {
            Object newValue = changeSet[0].getNewValue();
            this.getModel().setValue("inneracctbank", newValue, changeSet[0].getRowIndex());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tracebankupbill": 
            case "tracebankdownbill": {
                this.traceBankbill(key);
                break;
            }
            case "barchangepaytype2": {
                this.changepay();
                break;
            }
            case "barpaycancel": {
                this.cancelPay();
                break;
            }
            case "transdetailbill": {
                this.transDetailBill();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String matchFlag;
        String itemKey = evt.getItemKey();
        Object billStatus = this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"barpayconfirm")) {
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"TransBillEdit_30", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object sourceType = this.getModel().getValue("sourcetype");
            if (FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(sourceType)) {
                this.getView().invokeOperation("barpayconfirm");
            } else {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("fca_transpaydlg");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAY_CALLBACK));
                para.getOpenStyle().setShowType(ShowType.Modal);
                para.setCustomParam("paydate", null);
                this.getView().showForm(para);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bardiscarddetail")) {
            String matchFlag2 = (String)this.getModel().getValue("matchflag");
            boolean isMatchByHead = (Boolean)this.getModel().getValue("ismatchbyhead");
            if (isMatchByHead && !"0".equalsIgnoreCase(matchFlag2)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u6807\u8bc6\u4e3a\u201c\u672a\u5339\u914d\u201d\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"TransBillEdit_27", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int[] selectRows = ((EntryGrid)this.getControl("entrys")).getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5212\u62e8\u660e\u7ec6\uff0c\u518d\u4f5c\u5e9f\u652f\u4ed8\u660e\u7ec6\u3002", (String)"TransBillEdit_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean flag = this.chenkChgOrDiscard(ResManager.loadKDString((String)"\u4f5c\u5e9f\u652f\u4ed8\u660e\u7ec6", (String)"TransBillEdit_3", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            if (!flag) {
                evt.setCancel(true);
                return;
            }
            HashMap selectRowMap = new HashMap(selectRows.length);
            for (int row : selectRows) {
                selectRowMap.put(row, null);
            }
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entrys");
            int index = 0;
            for (DynamicObject entry : entries) {
                if (!selectRowMap.containsKey(index++)) continue;
                String payStatus = entry.getString("paystatus");
                String state = entry.getString("state");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransDetailStatusEnum.DELETE.getValue().equals(state)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u7b2c%1$d\u6761\u5212\u62e8\u660e\u7ec6\u5df2\u7ecf%2$s\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u8be5\u6761\u660e\u7ec6\u3002", (String)"TransBillEdit_4", (String)"tmc-fca-formplugin", (Object[])new Object[0]), index, FcaTransDetailStatusEnum.getName((String)state)));
                    evt.setCancel(true);
                    return;
                }
                if (!FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u7b2c%1$d\u6761\u5212\u62e8\u4ed8\u6b3e\u72b6\u6001\u4e0d\u4e3a\u4ea4\u6613\u5931\u8d25\u6216\u51c6\u5907\u63d0\u4ea4\uff0c\u4e0d\u80fd\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillEdit_6", (String)"tmc-fca-formplugin", (Object[])new Object[0]), index));
                    evt.setCancel(true);
                    return;
                }
                if ("0".equals(entry.getString("entrymatchflag"))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u7b2c%1$d\u6761\u660e\u7ec6\u5339\u914d\u6807\u8bc6\u4e0d\u4e3a\u672a\u5339\u914d\uff0c\u4e0d\u80fd\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillEdit_31", (String)"tmc-fca-formplugin", (Object[])new Object[0]), index));
                evt.setCancel(true);
                return;
            }
            FormShowParameter para = new FormShowParameter();
            para.setFormId("fca_transdiscarddlg");
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DISCARD_PAY_CALLBACK));
            para.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(para);
        } else if ("barchangepaytype2".equals(itemKey)) {
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"changepaychannel", (String)this.getModel().getDataEntity().getDataEntityType().getName(), (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                evt.setCancel(true);
            }
        } else if ("bardiscard".equals(itemKey) && !"0".equalsIgnoreCase(matchFlag = (String)this.getModel().getValue("matchflag"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u6807\u8bc6\u4e3a\u201c\u672a\u5339\u914d\u201d\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"TransBillEdit_27", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entry;
        int[] rows;
        boolean flag;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"newentry")) {
            Object bankAcct = this.getModel().getValue("accountbank");
            if (bankAcct == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5728\u6dfb\u52a0\u660e\u7ec6\u524d\uff0c\u8bf7\u5148\u5f55\u5165\u6bcd\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u3002", (String)"TransBillEdit_11", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)opKey, (CharSequence)"deleteentry") && !(flag = this.deleteEntry(rows = (entry = (EntryGrid)this.getControl("entrys")).getSelectRows()))) {
            args.setCancel(true);
        }
    }

    private boolean chenkChgOrDiscard(String title) {
        Object billStatus = this.getModel().getValue("billstatus");
        if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd%s\u3002", (String)"TransBillEdit_12", (String)"tmc-fca-formplugin", (Object[])new Object[0]), title));
            return false;
        }
        boolean ischangepaych = (Boolean)this.getModel().getValue("ischangepaych");
        if (ischangepaych) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5%s\u3002", (String)"TransBillEdit_13", (String)"tmc-fca-formplugin", (Object[])new Object[0]), title));
            return false;
        }
        return true;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        logger.info("TransBillEdit afterDeleteRow begin.............");
        this.calcTotalAmtAndCount();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        logger.info("TransBillEdit afterAddRow begin.............");
        this.initPayChannel();
        this.calcTotalAmtAndCount();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (CHANGE_ACCTGROUP_CALLBACK.equals(callBackId)) {
                String pk = this.getPageCache().get(CHANGE_ACCTGROUP_CALLBACK);
                this.getPageCache().remove(CHANGE_ACCTGROUP_CALLBACK);
                this.getPageCache().remove(CHANGE_ACCTGROUP_CALLBACK_OLD);
                this.getModel().setValue("acctgrpid", (Object)pk);
                this.clearEntry();
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("acctgrpid");
                if (dynamicObject == null) {
                    this.getModel().setValue("accountbank", null);
                    this.getModel().setValue("currency", null);
                    return;
                }
                this.getModel().setValue("accountbank", dynamicObject.get("accountbank"));
                this.getModel().setValue("currency", dynamicObject.get("currency"));
                this.updateAcctBank();
            } else if ("bar_unaudit".equals(callBackId)) {
                this.getView().invokeOperation("unaudit");
            } else if ("bar_unsubmit".equals(callBackId)) {
                this.getView().invokeOperation("unsubmit");
            } else if ("barpaycancel".equals(callBackId)) {
                this.getView().invokeOperation("paycancel");
            } else if ("CONFIRM_CANCELPAY_CALLBACK".equals(callBackId)) {
                this.getView().invokeOperation("paycancel");
            }
        } else if (CHANGE_ACCTGROUP_CALLBACK.equals(callBackId)) {
            String oldPk = this.getPageCache().get(CHANGE_ACCTGROUP_CALLBACK_OLD);
            this.getModel().setValue("acctgrpid", (Object)oldPk);
            this.getPageCache().remove(CHANGE_ACCTGROUP_CALLBACK_OLD);
            this.getPageCache().remove(CHANGE_ACCTGROUP_CALLBACK);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)DISCARD_PAY_CALLBACK)) {
            ParamMap data = (ParamMap)closedCallBackEvent.getReturnData();
            if (data != null) {
                String reason = (String)data.get("reason");
                int[] selectRows = ((EntryGrid)this.getControl("entrys")).getSelectRows();
                OperateOption create = OperateOption.create();
                List rowIndexes = Arrays.stream(selectRows).mapToObj(String::valueOf).collect(Collectors.toList());
                create.setVariableValue("discardIndex", String.join((CharSequence)",", rowIndexes));
                create.setVariableValue("reason", reason);
                OperationResult operationResult = this.getView().invokeOperation("discarddetail", create);
                if (operationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                }
            }
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)PAY_CALLBACK)) {
            ParamMap data = (ParamMap)closedCallBackEvent.getReturnData();
            if (data != null) {
                Date payDate = (Date)data.get("payDate");
                OperateOption op = OperateOption.create();
                op.setVariableValue("paydate", DateUtils.formatString((Date)payDate, (String)"yyyyMMdd"));
                this.getView().invokeOperation("barpayconfirm", op);
            }
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)CHANGE_ACCTGROUP_CALLBACK)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            DynamicObject accountGroup = (DynamicObject)this.getModel().getValue("acctgrpid");
            if (EmptyUtil.isNoEmpty((Object)returnData)) {
                String pkOld;
                ListSelectedRow selectedRow = returnData.get(0);
                Object pk = selectedRow.getPrimaryKeyValue();
                String string = pkOld = accountGroup != null ? accountGroup.getPkValue().toString() : "";
                if (pk.equals(pkOld)) {
                    return;
                }
                this.getPageCache().put(CHANGE_ACCTGROUP_CALLBACK, pk.toString());
                this.getPageCache().put(CHANGE_ACCTGROUP_CALLBACK_OLD, pkOld);
                this.showChangeConfirmDialog(CHANGE_ACCTGROUP_CALLBACK);
            }
        }
    }

    private boolean deleteEntry(int[] rows) {
        int i;
        DynamicObjectCollection entities = this.getModel().getEntryEntity("entrys");
        for (i = 0; i < rows.length; ++i) {
            DynamicObject entry = (DynamicObject)entities.get(rows[i]);
            Object state = entry.get("state");
            if (FcaTransDetailStatusEnum.NORMAL.getValue().equals(state)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c", (String)"TransBillEdit_14", (String)"tmc-fca-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u4e0d\u662f\u6b63\u5e38\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TransBillEdit_15", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().beginInit();
        for (i = 0; i < rows.length; ++i) {
            int row = rows[i];
            this.getModel().setValue("state", (Object)FcaTransDetailStatusEnum.DELETE.getValue(), row);
        }
        this.getModel().endInit();
        return true;
    }

    private void showChangeConfirmDialog(String key) {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5982\u679c\u4fee\u6539\u4f1a\u6e05\u7a7a\u548c\u5237\u65b0\u5df2\u6709\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransBillEdit_16", (String)"tmc-fca-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entrys");
        DynamicObject accountbank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (company != null && accountbank != null && currency != null) {
            this.getView().invokeOperation("newentry");
            this.initPayChannel();
        }
    }

    private void updateAcctBank() {
        Object bank = this.getModel().getValue("accountbank");
        DynamicObject newBankAcct = (DynamicObject)bank;
        if (newBankAcct != null) {
            this.initBankInfo(newBankAcct.getDynamicObject("bank"), "", 0);
            this.getModel().setValue("bank", newBankAcct.getDynamicObject("bank").getPkValue());
        } else {
            this.initBankInfo(null, "", 0);
            this.getModel().setValue("bank", null);
        }
    }

    private boolean updatePayChannel(ChangeData payChannelObj) {
        String newPayChannel = (String)payChannelObj.getNewValue();
        if (payChannelObj.getDataEntity().get("subacct") == null) {
            this.getModel().beginInit();
            this.getModel().setValue("paychanel", null, payChannelObj.getDataEntity().getInt("seq") - 1);
            this.getModel().endInit();
            this.getView().updateView("paychanel", payChannelObj.getDataEntity().getInt("seq") - 1);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\uff0c\u7136\u540e\u518d\u9009\u62e9\u652f\u4ed8\u6e20\u9053\u3002", (String)"TransBillEdit_17", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        int index = 0;
        for (DynamicObject entry : entrys) {
            String state = entry.getString("state");
            String payChanel = entry.getString("paychanel");
            if (!FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) && !FcaTransPayChanEnum.BEI.getValue().equals(payChanel)) {
                this.getModel().beginInit();
                this.getModel().setValue("paychanel", (Object)newPayChannel, index);
                this.getModel().endInit();
                this.getView().updateView("paychanel", index);
            }
            ++index;
        }
        return true;
    }

    private void initPayChannel() {
        String entityName = this.getModel().getDataEntityType().getName();
        if ("fca_transupbill".equals(entityName)) {
            this.initPayChannelUp();
        } else {
            this.initPayChannelDown();
        }
    }

    private void initPayChannelUp() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        ArrayList<Integer> noSetList = new ArrayList<Integer>();
        String defaultPayChanel = FcaTransPayChanEnum.ONLINE.getValue();
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            if (entry.get("subacct") == null) continue;
            String payChanel = entry.getString("paychanel");
            DynamicObject subAcct = entry.getDynamicObject("subacct");
            boolean isOpenBei = subAcct.getBoolean("issetbankinterface");
            if (!EmptyUtil.isEmpty((String)payChanel)) {
                if (!isOpenBei) {
                    defaultPayChanel = payChanel;
                    this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"paychanel"});
                    continue;
                }
                this.getModel().beginInit();
                this.getModel().setValue("paychanel", (Object)FcaTransPayChanEnum.BEI.getValue(), i);
                this.getModel().endInit();
                this.getView().updateView("paychanel", i);
                continue;
            }
            if (isOpenBei) {
                this.getModel().beginInit();
                this.getModel().setValue("paychanel", (Object)FcaTransPayChanEnum.BEI.getValue(), i);
                this.getModel().endInit();
                this.getView().updateView("paychanel", i);
                continue;
            }
            noSetList.add(i);
        }
        if (!EmptyUtil.isEmpty(noSetList)) {
            for (Integer i : noSetList) {
                this.getModel().beginInit();
                this.getModel().setValue("paychanel", (Object)defaultPayChanel, i.intValue());
                this.getModel().endInit();
                this.getView().updateView("paychanel", i.intValue());
            }
        }
    }

    private void initPayChannelDown() {
        DynamicObject acct = (DynamicObject)this.getModel().getValue("accountbank");
        if (acct == null) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        boolean isOpenBei = acct.getBoolean("issetbankinterface");
        String payChannel = isOpenBei ? FcaTransPayChanEnum.BEI.getValue() : FcaTransPayChanEnum.ONLINE.getValue();
        for (int i = 0; i < entrys.size(); ++i) {
            this.getModel().beginInit();
            this.getModel().setValue("paychanel", (Object)payChannel, i);
            this.getModel().endInit();
            this.getView().updateView("paychanel", i);
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("paystatus", i))) {
                this.getModel().setValue("paystatus", (Object)FcaTransPayStatusEnum.INIT.getValue(), i);
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("state", i))) {
                this.getModel().setValue("state", (Object)FcaTransDetailStatusEnum.NORMAL.getValue(), i);
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"paychanel"});
        }
    }

    private List<Object> getAuthAcctGroupList() {
        List authOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter companyIdFilter = new QFilter("company", "in", (Object)authOrgList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection authAcctGroupList = QueryServiceHelper.query((String)"fca_acctgroup", (String)"company", (QFilter[])new QFilter[]{companyIdFilter, enableFilter});
        return authAcctGroupList.stream().map(o -> o.get("company")).distinct().collect(Collectors.toList());
    }

    private void calcTotalAmtAndCount() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        BigDecimal totalAmt = BigDecimal.ZERO;
        int totalCount = 0;
        for (DynamicObject entry : entrys) {
            String state = entry.getString("state");
            logger.info(" calcTotalAmtAndCount  totalCount: " + totalCount + "  state:" + state + "  TRANSAMT:  " + entry.getBigDecimal("transamt"));
            if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransDetailStatusEnum.DELETE.getValue().equals(state)) continue;
            totalAmt = totalAmt.add(entry.getBigDecimal("transamt"));
            ++totalCount;
        }
        this.getModel().setValue("amount", (Object)totalAmt);
        this.setEntrtySumAmount();
        this.getModel().setValue("transcount", (Object)totalCount);
    }

    private void setEntrtySumAmount() {
        Object cObj = this.getModel().getValue("currency");
        int amtPrecision = 2;
        if (cObj != null) {
            DynamicObject currency = (DynamicObject)cObj;
            amtPrecision = currency.getInt("amtprecision");
        }
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrys");
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put("transamt", TmcBusinessBaseHelper.formatDecimal((BigDecimal)amount, (int)amtPrecision));
        entryGrid.setFloatButtomData(floatButtomData);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        int index = 0;
        boolean discardFlag = false;
        for (DynamicObject entry : entrys) {
            ++index;
            String state = entry.getString("state");
            if (!FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) continue;
            discardFlag = true;
            this.getView().setEnable(Boolean.valueOf(false), index - 1, new String[]{"subacct", "transamt", "remark", "paychanel"});
        }
        if (discardFlag) {
            TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])new String[]{"company", "accountbank", "currency"});
        }
    }

    private void calcRefTransAmt(int rowIndex) {
        DynamicObject strategy;
        DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject subAcct = (DynamicObject)this.getModel().getValue("subacct", rowIndex);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject subAcctCompany = (DynamicObject)this.getModel().getValue("subacct_company", rowIndex);
        DynamicObject accountGroup = (DynamicObject)this.getModel().getValue("acctgrpid");
        BigDecimal refAmt = BigDecimal.ZERO;
        if (bankAcct != null && subAcct != null && currency != null && (strategy = AmtValidateHelper.getStrategy((DynamicObject)accountGroup, (DynamicObject)subAcct)) != null) {
            String entityName = this.getModel().getDataEntityType().getName();
            refAmt = "fca_transupbill".equals(entityName) ? AmtCalcHelper.getBillTransUpRefTransAmt((DynamicObject)subAcct, (Object)currency.getPkValue(), (DynamicObject)strategy, (long)((Long)subAcctCompany.getPkValue())) : AmtCalcHelper.getBillTransDownRefTransAmt((DynamicObject)subAcct, (Object)currency.getPkValue(), (DynamicObject)strategy);
        }
        this.getModel().setValue("referamt", (Object)refAmt, rowIndex);
    }

    private void handleSourceType() {
        Object sourceType = this.getModel().getValue("sourcetype");
        if (FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) {
            TmcViewInputHelper.registerShowingStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"newentry", "copyentry"}, (String)"billstatus", (String[])new String[0]);
            TmcViewInputHelper.registerShowingStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"delentry"}, (String)"billstatus", (String[])new String[]{BillStatusEnum.SAVE.getValue()});
        } else {
            TmcViewInputHelper.registerShowingStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"refreshbalance", "newentry", "copyentry", "delentry"}, (String)"billstatus", (String[])new String[]{BillStatusEnum.SAVE.getValue()});
            TmcViewInputHelper.registerShowingStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"referamt"}, (String)"billstatus", (String[])new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()});
        }
        TmcViewInputHelper.registerShowingStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"paystatus", "payuser", "submitpaytime", "payreturninfo", "payreturntime", "paydate"}, (String)"billstatus", (String[])new String[]{BillStatusEnum.AUDIT.getValue(), BillStatusEnum.PAYING.getValue(), BillStatusEnum.PAYED.getValue()});
        TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"entrys"}, (String)"billstatus", (String[])new String[]{BillStatusEnum.DISCARD.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.PAYING.getValue(), BillStatusEnum.PAYED.getValue()});
    }

    private void handleTbmainButton() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        String[] propNameArr = new String[]{};
        Object id = this.getModel().getValue("id");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            propNameArr = id == null || (Long)id == 0L ? new String[]{"bar_save", "bar_submit"} : staticNameArr;
        } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            propNameArr = staticNameArr2;
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            propNameArr = staticNameArr3;
        } else if (BillStatusEnum.PAYING.getValue().equals(billStatus)) {
            propNameArr = staticNameArr4;
        } else if (BillStatusEnum.PAYED.getValue().equals(billStatus)) {
            propNameArr = staticNameArr5;
        } else if (BillStatusEnum.DISCARD.getValue().equals(billStatus)) {
            propNameArr = new String[]{"bar_refresh", "barcopy"};
        }
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])FcaTransBillProp.TBMAIN_AUTH_BUTTONS, (boolean)true);
        String[] dePropNames = this.getDePropNames(propNameArr);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])dePropNames, (boolean)false);
        this.getView().updateView("tbmain");
    }

    private String[] getDePropNames(String[] propNameArr) {
        ArrayList<String> propList = new ArrayList<String>();
        HashMap propNameMap = new HashMap(propNameArr.length);
        for (String p : propNameArr) {
            propNameMap.put(p, null);
        }
        for (String p : FcaTransBillProp.TBMAIN_AUTH_BUTTONS) {
            if (propNameMap.containsKey(p)) continue;
            propList.add(p);
        }
        String[] propArr = new String[propList.size()];
        propArr = propList.toArray(propArr);
        return propArr;
    }

    private void changepay() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setCustomParam("sourceId", (Object)((Long)this.getModel().getValue("id")));
        showParameter.setCustomParam("sourceType", (Object)this.getModel().getDataEntityType().getName());
        showParameter.setFormId("fca_transchgbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void traceBankbill(String sourceBillType) {
        String targetBillType = null;
        targetBillType = sourceBillType.equalsIgnoreCase("tracebankupbill") ? "bei_banktransupbill" : "bei_banktransdownbill";
        Long billId = (Long)this.getModel().getValue("id");
        if (billId == null || billId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"TransBillEdit_18", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)targetBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId)}, (String)"createtime desc");
        if (targetBills.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"TransBillEdit_19", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (targetBills.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)targetBills.get(0)).get("id"));
            showParameter.setFormId(targetBillType);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(targetBillType);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            HashSet<Object> pks = new HashSet<Object>(targetBills.size());
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void transDetailBill() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (entrys == null || entrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5212\u62e8\u660e\u7ec6\u4fe1\u606f\u3002", (String)"TransBillEdit_28", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> entryIdList = new ArrayList<String>(10);
        for (DynamicObject entry : entrys) {
            entryIdList.add(entry.getPkValue().toString());
        }
        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id, bankcheckflag", (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", entryIdList)});
        if (targetBills.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u3002", (String)"TransBillEdit_29", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        } else if (targetBills.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("ifm_transdetail");
            showParameter.setPkId(((DynamicObject)targetBills.get(0)).get("id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ifm_transdetail");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter filter = new QFilter("bankcheckflag", "in", entryIdList);
            parameter.getListFilterParameter().setFilter(filter);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void handleBtnShow() {
        DynamicObject transBill = this.getModel().getDataEntity();
        String billstatus = transBill.getString("billstatus");
        String targetKey = "C,P,D";
        this.getView().setVisible(Boolean.valueOf(targetKey.contains(billstatus)), button);
    }

    private void cancelPay() {
        String billno = (String)this.getModel().getValue("billno");
        String entityName = this.getModel().getDataEntityType().getName();
        DynamicObject payObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,billno,isvoucher,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (payObj != null) {
            boolean isv = payObj.getBoolean("isvoucher");
            if (isv) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"TransBillEdit_20", (String)"tmc-fca-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"TransBillEdit_21", (String)"tmc-fca-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBalance() {
        Long orgId = this.getPk("company");
        DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("accountbank");
        Long currencyId = this.getPk("currency");
        try {
            this.getModel().beginInit();
            if (orgId == null || bankAcct == null || currencyId == null) {
                this.getModel().setValue("balance", (Object)BigDecimal.ZERO);
                return;
            }
            String balanceType = SystemParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
            String entityKey = this.getModel().getDataEntity().getDataEntityType().getName();
            Long pkId = this.getModel().getDataEntity().getLong("id");
            BalanceModelService balanceModelService = new BalanceModelService();
            BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId.longValue());
            BigDecimal currentBalance = bizBalanceModelBean.getAmount();
            BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount((String)entityKey, (DynamicObject)bankAcct, (Long)currencyId, (Long)orgId, (Long)pkId, (BigDecimal)currentBalance);
            this.getModel().setValue("balance", (Object)usableBalance);
        }
        catch (Exception err) {
            this.getModel().setValue("balance", (Object)BigDecimal.ZERO);
            logger.error("\u6bcd\u8d26\u6237\u53ef\u7528\u4f59\u989d\u5237\u65b0\u9519\u8bef", (Throwable)err);
        }
        finally {
            this.getModel().endInit();
            this.getView().updateView("balance");
        }
    }

    private void filltranbillDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(sdf.format(this.getModel().getValue("createtime")));
            this.getModel().setValue("transbilldate", (Object)date);
        }
        catch (ParseException parseException) {
            logger.error("e:", (Throwable)parseException);
        }
    }

    private DynamicObject getDynamicObject(String key) {
        Object value = this.getModel().getValue(key);
        return value != null ? (DynamicObject)value : null;
    }

    private Long getPk(String key) {
        DynamicObject baseData = this.getDynamicObject(key);
        return baseData == null ? null : (Long)baseData.getPkValue();
    }

    private void calcRefTransAmts() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            this.calcRefTransAmt(i);
        }
    }

    private QFilter getAccountFilter() {
        String[] temp = new String[]{"normal", "closing"};
        QFilter statusFilter = new QFilter("acctstatus", "in", (Object)temp);
        QFilter acctClassifyFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        return statusFilter.and(acctClassifyFilter);
    }

    private void setEntryRecBankInfo() {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entrys");
        if (entrys != null && !entrys.isEmpty()) {
            List bankIds = entrys.stream().map(o -> {
                DynamicObject bank;
                DynamicObject acctBank = o.getDynamicObject("subacct");
                if (acctBank != null && (bank = acctBank.getDynamicObject("bank")) != null) {
                    return (Long)bank.getPkValue();
                }
                return 0L;
            }).collect(Collectors.toList());
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank.id beBankId,bebank.country.id countryid,bebank.provincetxt,bebank.citytxt", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)});
            HashMap<Object, DynamicObject> idMapObject = new HashMap<Object, DynamicObject>(10);
            if (banks != null && !banks.isEmpty()) {
                for (DynamicObject bank : banks) {
                    idMapObject.put(bank.get("id"), bank);
                }
            }
            for (DynamicObject entry : entrys) {
                DynamicObject bank;
                DynamicObject bankDo;
                DynamicObject subAcct = entry.getDynamicObject("subacct");
                if (subAcct == null || (bankDo = subAcct.getDynamicObject("bank")) == null || (bank = (DynamicObject)idMapObject.get(bankDo.getPkValue())) == null) continue;
                int index = entry.getInt("seq") - 1;
                this.getModel().setValue("entrycountry", (Object)bank.getLong("countryid"), index);
                this.getModel().setValue("entryprovince", bank.get("bebank.provincetxt"), index);
                this.getModel().setValue("entrycity", bank.get("bebank.citytxt"), index);
            }
        }
    }

    private boolean isBotpNew() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        String sourceBillType = (String)this.getModel().getValue("sourcetype");
        return !sourceBillType.equalsIgnoreCase("manual") && EmptyUtil.isEmpty((Object)billShowParameter.getPkId());
    }

    private List<Long> getAcctBankIds(DynamicObject com, DynamicObject currency) {
        QFilter qFilter = AcctGroupRelInnerAcctHelper.virtualAcctQfNew();
        qFilter.and(new QFilter("acctstatus", "not in", (Object)new String[]{BankAcctStatusEnum.CLOSED.getValue(), BankAcctStatusEnum.FREEZE.getValue()}));
        qFilter.and(new QFilter("finorgtype", "!=", (Object)"1"));
        qFilter.and(new QFilter("currency.fbasedataid.id", "in", currency.getPkValue()));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)com.getLong("id")));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.isEmpty()) {
            return new ArrayList<Long>();
        }
        return dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private boolean enableBankAcct() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        if (org == null) {
            return false;
        }
        return SysParameterHelp.getFcaParameterBoolean((long)org.getLong("id"), (String)ISUNACCTGROUP);
    }

    private void initAcctGroupAndBanKAndCur() {
        DynamicObjectCollection acctGroups = this.getAuthAcctGroup();
        if (acctGroups.isEmpty()) {
            return;
        }
        this.getModel().setValue("acctgrpid", ((DynamicObject)acctGroups.get(0)).get("id"));
        this.getModel().setValue("accountbank", ((DynamicObject)acctGroups.get(0)).get("accountbank"));
        this.getModel().setValue("currency", ((DynamicObject)acctGroups.get(0)).get("currency"));
        this.updateAcctBank();
    }

    private DynamicObjectCollection getAuthAcctGroup() {
        Object compId;
        DynamicObject comp = (DynamicObject)this.getModel().getValue("company");
        Object object = compId = comp != null ? comp.getPkValue() : null;
        if (compId == null) {
            return new DynamicObjectCollection();
        }
        QFilter companyFilter = new QFilter("company", "=", compId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        return QueryServiceHelper.query((String)"fca_acctgroup", (String)"id, accountbank, currency", (QFilter[])new QFilter[]{companyFilter, enableFilter}, (String)"isdefault desc, createtime desc");
    }

    private void initBankInfo(Object bank, String entry, int currentIndex) {
        String countryProp = entry + "country";
        String provinceProp = entry + "province";
        String cityProp = entry + "city";
        if (bank == null) {
            if (EmptyUtil.isEmpty((String)entry)) {
                this.getModel().setValue(countryProp, null);
                this.getModel().setValue(provinceProp, null);
                this.getModel().setValue(cityProp, null);
            } else {
                this.getModel().setValue(countryProp, null, currentIndex);
                this.getModel().setValue(provinceProp, null, currentIndex);
                this.getModel().setValue(cityProp, null, currentIndex);
            }
        } else {
            DynamicObject bankDo = (DynamicObject)bank;
            DynamicObject bankInfo = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"bebank.id,bebank.country,bebank.provincetxt,bebank.citytxt", (QFilter[])new QFilter[]{new QFilter("id", "=", bankDo.getPkValue())});
            this.setRecBankInfo(bankInfo, entry, currentIndex);
        }
    }

    private void setRecBankInfo(DynamicObject bankInfo, String entry, int currentIndex) {
        if (bankInfo != null) {
            String countryProp = entry + "country";
            String provinceProp = entry + "province";
            String cityProp = entry + "city";
            Long country = bankInfo.getLong("bebank.country");
            String provinceTxt = bankInfo.getString("bebank.provincetxt");
            String cityTxt = bankInfo.getString("bebank.cityTxt");
            if (EmptyUtil.isEmpty((String)entry)) {
                this.getModel().setValue(countryProp, (Object)country);
                this.getModel().setValue(provinceProp, (Object)provinceTxt);
                this.getModel().setValue(cityProp, (Object)cityTxt);
            } else {
                this.getModel().setValue(countryProp, (Object)country, currentIndex);
                this.getModel().setValue(provinceProp, (Object)provinceTxt, currentIndex);
                this.getModel().setValue(cityProp, (Object)cityTxt, currentIndex);
            }
        }
    }
}

