/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.service.model.BalanceModelService;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.helper.TransBillHelper;

public class TransBillEntryEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        if (!entry.isEmpty()) {
            boolean isChanged = this.getModel().getDataChanged();
            ArrayList<Integer> rowIndexList = new ArrayList<Integer>(entry.size());
            for (int i = 0; i < entry.size(); ++i) {
                rowIndexList.add(i);
            }
            this.setSubInnerAcctOnLoad();
            int[] selectRows = rowIndexList.stream().mapToInt(Integer::intValue).toArray();
            this.updateBalance(selectRows);
            this.updateInnerBalance(selectRows);
            this.getModel().setDataChanged(isChanged);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fieldKey) {
            case "subacct": {
                Map orgInnerAccountMap = null;
                if (newValue != null) {
                    DynamicObject subAcct = (DynamicObject)newValue;
                    HashSet<Object> bankAccountIds = new HashSet<Object>(1);
                    bankAccountIds.add(subAcct.getPkValue());
                    orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
                }
                this.getModel().setValue("inneracctbank", null, rowIndex);
                this.setSubInnerAcct(rowIndex, orgInnerAccountMap);
                this.updateBalance(new int[]{rowIndex});
                break;
            }
            case "inneracctbank": {
                this.updateInnerBalance(new int[]{rowIndex});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryEntity;
        int[] selectRows;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String opKey = source.getOperateKey();
        if ("refreshbalance".equals(opKey) && (selectRows = (entryEntity = (EntryGrid)this.getView().getControl("entrys")).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TransBillEntryEdit_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("refreshbalance".equals(opKey)) {
            EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entrys");
            int[] selectRows = entryEntity.getSelectRows();
            this.updateBalance(selectRows);
            this.updateInnerBalance(selectRows);
        }
    }

    private void updateBalance(int[] selectRows) {
        boolean isChanged = this.getModel().getDataChanged();
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long pkId = this.getModel().getDataEntity().getLong("id");
        if (org == null || currency == null) {
            this.getModel().setValue("subcurbalance", null);
            this.getModel().setValue("subvalbalance", null);
            return;
        }
        Long currencyId = currency.getLong("id");
        Long orgId = org.getLong("id");
        String entityKey = this.getModel().getDataEntity().getDataEntityType().getName();
        String balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.FCS.getId(), (long)orgId, (String)"balancevalue");
        BalanceModelService balanceModelService = new BalanceModelService();
        this.getModel().beginInit();
        for (int i : selectRows) {
            DynamicObject bankAcct = (DynamicObject)this.getModel().getValue("subacct", i);
            if (bankAcct != null) {
                BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(balanceType, bankAcct.getLong("id"), currencyId.longValue());
                BigDecimal currentBalance = bizBalanceModelBean.getAmount();
                BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount((String)entityKey, (DynamicObject)bankAcct, (Long)currencyId, (Long)orgId, (Long)pkId, (BigDecimal)currentBalance);
                this.getModel().setValue("subcurbalance", (Object)currentBalance, i);
                this.getModel().setValue("subvalbalance", (Object)usableBalance, i);
                continue;
            }
            this.getModel().setValue("subcurbalance", null, i);
            this.getModel().setValue("subvalbalance", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entrys");
        this.getModel().setDataChanged(isChanged);
    }

    private void updateInnerBalance(int[] selectRows) {
        boolean isChanged = this.getModel().getDataChanged();
        DynamicObject org = (DynamicObject)this.getModel().getValue("company");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long pkId = this.getModel().getDataEntity().getLong("id");
        if (org == null || currency == null) {
            this.getModel().beginInit();
            this.getModel().setValue("innercurbalance", null);
            this.getModel().setValue("innervalbalance", null);
            this.getModel().endInit();
            this.getView().updateView("entrys");
            return;
        }
        Long currencyId = currency.getLong("id");
        Long orgId = org.getLong("id");
        String entityKey = this.getModel().getDataEntity().getDataEntityType().getName();
        BalanceModelService balanceModelService = new BalanceModelService();
        this.getModel().beginInit();
        for (int i : selectRows) {
            DynamicObject innerBankAcct = (DynamicObject)this.getModel().getValue("inneracctbank", i);
            if (innerBankAcct != null) {
                BizBalanceModelBean bizBalanceModelBean = balanceModelService.getRunningBalance(BalanceTypeEnum.BALANCE.getValue(), innerBankAcct.getLong("id"), currencyId.longValue());
                BigDecimal currentBalance = bizBalanceModelBean.getAmount();
                BigDecimal usableBalance = AmtCalcHelper.getBalanceModelAmount((String)entityKey, (DynamicObject)innerBankAcct, (Long)currencyId, (Long)orgId, (Long)pkId, (BigDecimal)currentBalance);
                this.getModel().setValue("innercurbalance", (Object)currentBalance, i);
                this.getModel().setValue("innervalbalance", (Object)usableBalance, i);
                continue;
            }
            this.getModel().setValue("innercurbalance", null, i);
            this.getModel().setValue("innervalbalance", null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entrys");
        this.getModel().setDataChanged(isChanged);
    }

    private void setSubInnerAcct(int index, Map<Object, Map<Object, DynamicObject>> orgInnerAccountMap) {
        if (this.getModel().getValue("subacct", index) != null && this.getModel().getValue("company", index) != null && this.getModel().getValue("currency", index) != null && orgInnerAccountMap != null) {
            DynamicObjectCollection currencies;
            List currencyIdList;
            DynamicObject subAcct = (DynamicObject)this.getModel().getValue("subacct", index);
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject innerAccount = null;
            if (orgInnerAccountMap.containsKey(company.getPkValue()) && (innerAccount = orgInnerAccountMap.get(company.getPkValue()).get(subAcct.getPkValue())) != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                innerAccount = null;
            }
            if (innerAccount == null) {
                this.getModel().setValue("inneracct", null, index);
            } else {
                DynamicObject bankAcctByInnerAcct = TmcAccountHelper.getBankAcctByInnerAcct(innerAccount);
                this.getModel().setValue("inneracct", (Object)bankAcctByInnerAcct, index);
            }
        } else {
            this.getModel().setValue("inneracct", null, index);
        }
    }

    private void setSubInnerAcctOnLoad() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entrys");
        Map orgInnerAccountMap = null;
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            Set bankAccountIds = entries.stream().filter(d -> d.getDynamicObject("subacct") != null && d.get("inneracctbank") == null).map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        }
        for (int i = 0; i < entries.size(); ++i) {
            if (this.getModel().getValue("inneracctbank", i) == null) {
                this.setSubInnerAcct(i, orgInnerAccountMap);
                continue;
            }
            this.getModel().beginInit();
            this.getModel().setValue("inneracct", this.getModel().getValue("inneracctbank", i), i);
            this.getModel().endInit();
            this.getView().updateView("inneracct", i);
        }
    }
}

