/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.formplugin.transbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.errorcode.TransErrorCode;
import kd.tmc.fca.common.exception.FcaException;

public class TransBillList
extends AbstractListPlugin {
    public static final String CONFIRM_ADD_UP_CALLBACK = "CONFIRM_ADD_UP_CALLBACK";
    public static final String CONFIRM_ADD_DOWN_CALLBACK = "CONFIRM_ADD_DOWN_CALLBACK";
    public static final String PAY_CALLBACK = "PAY_CALLBACK";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListShowParameter showParam = (ListShowParameter)this.getView().getFormShowParameter();
        String entityId = showParam.getBillFormId();
        if (StringUtils.equals((CharSequence)"tblnew", (CharSequence)itemKey)) {
            QFilter genStateFilter;
            QFilter companyFilter;
            String applyEntityId = "fca_transupbill".equals(entityId) ? "fca_applytransupbill" : "fca_applytransdownbill";
            Long userId = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            List authIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)applyEntityId, (String)"47150e89000000ac");
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            int count = TmcDataServiceHelper.count((String)applyEntityId, (QFilter[])new QFilter[]{statusFilter, companyFilter = new QFilter("parentorg.id", "in", (Object)authIdList), genStateFilter = new QFilter("entrys.isgeneratebill", "=", (Object)Boolean.FALSE)});
            if (count > 0) {
                if ("fca_applytransupbill".equals(applyEntityId)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u672a\u5904\u7406\u7684\u4e0a\u5212\u7533\u8bf7\u4efb\u52a1\uff0c\u662f\u5426\u524d\u5f80\u5904\u7406\uff1f", (String)"TransBillList_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u60a8\u540d\u4e0b\u6709%d\u4e2a\u672a\u5904\u7406\u7684\u4e0a\u5212\u7533\u8bf7\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5728\u8c03\u5ea6\u4e2d\u5fc3\u5904\u7406\uff0c\u70b9\u51fb\u201c\u662f\u201d\u5c06\u7acb\u5373\u6253\u5f00\u8be5\u4efb\u52a1\u5217\u8868\u3002\u5982\u9700\u7ee7\u7eed\u624b\u5de5\u521b\u5efa\u4e0a\u5212\u5355\uff0c\u8bf7\u70b9\u51fb\u201c\u5426\u201d\u3002", (String)"TransBillList_1", (String)"tmc-fca-formplugin", (Object[])new Object[0]), count), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_ADD_UP_CALLBACK, (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u672a\u5904\u7406\u7684\u8bf7\u6b3e\u7533\u8bf7\u4efb\u52a1\uff0c\u662f\u5426\u7acb\u5373\u524d\u5f80\u5904\u7406\u3002", (String)"TransBillList_2", (String)"tmc-fca-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u60a8\u540d\u4e0b\u6709%d\u4e2a\u672a\u5904\u7406\u7684\u8bf7\u6b3e\u7533\u8bf7\u4efb\u52a1\uff0c\u8bf7\u53ca\u65f6\u5728\u8c03\u5ea6\u4e2d\u5fc3\u5904\u7406\uff0c\u70b9\u51fb\u201c\u662f\u201d\u5c06\u7acb\u5373\u6253\u5f00\u8be5\u4efb\u52a1\u5217\u8868\u3002\u5982\u9700\u7ee7\u7eed\u624b\u5de5\u521b\u5efa\u4e0b\u62e8\u5355\uff0c\u8bf7\u70b9\u51fb\u201c\u5426\u201d\u3002", (String)"TransBillList_3", (String)"tmc-fca-formplugin", (Object[])new Object[0]), count), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_ADD_DOWN_CALLBACK, (IFormPlugin)this));
                }
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"barpayconfirm")) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (!selectedRows.isEmpty()) {
                DynamicObjectCollection bill = QueryServiceHelper.query((String)entityId, (String)"sourcetype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
                if (bill.isEmpty()) {
                    evt.setCancel(true);
                } else {
                    Set sourceTypeSet = bill.stream().map(d -> d.getString("sourcetype")).collect(Collectors.toSet());
                    if (sourceTypeSet.size() == 1 && (sourceTypeSet.contains(FcaTransSourceTypeEnum.PAYPASSIVE.getValue()) || sourceTypeSet.contains(FcaTransSourceTypeEnum.RECINITIATIVE.getValue()))) {
                        this.getView().invokeOperation("barpayconfirm");
                    } else {
                        FormShowParameter para = new FormShowParameter();
                        para.setFormId("fca_transpaydlg");
                        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAY_CALLBACK));
                        para.getOpenStyle().setShowType(ShowType.Modal);
                        para.setCustomParam("paydate", null);
                        this.getView().showForm(para);
                    }
                }
            } else {
                evt.setCancel(true);
            }
        }
    }

    private void goApplyTransupList(String status) {
        RequestContext context;
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean isperm = TmcOrgDataHelper.hasPermission((String)appId, (long)(context = RequestContext.get()).getCurrUserId(), (long)context.getOrgId(), (String)"fca_control_index", (String)"04PGH52CSKRY");
        if (!isperm) {
            throw new FcaException(new TransErrorCode().MUSTUNTRANSUPQX());
        }
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_applytransupbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "=", (Object)status);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        para.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCaption(ResManager.loadKDString((String)"\u672a\u5904\u7406\u4e0a\u5212\u7533\u8bf7\u5355", (String)"TransBillList_4", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private void goApplyTransdownList(String status) {
        RequestContext context;
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean isperm = TmcOrgDataHelper.hasPermission((String)appId, (long)(context = RequestContext.get()).getCurrUserId(), (long)context.getOrgId(), (String)"fca_control_index", (String)"04PGNGN13ZLV");
        if (!isperm) {
            throw new FcaException(new TransErrorCode().MUSTUNTRANSDOWNQX());
        }
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fca_applytransdownbill");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        QFilter filter = new QFilter("billstatus", "=", (Object)status);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        para.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        para.setCustomParam("isUnTreated", (Object)Boolean.TRUE);
        para.setCaption(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8bf7\u6b3e\u7533\u8bf7\u5355", (String)"TransBillList_5", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == res) {
            if ("unsubmit".equals(id)) {
                this.getView().invokeOperation("unsubmit");
            } else if (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_ADD_UP_CALLBACK)) {
                this.goApplyTransupList(BillStatusEnum.SUBMIT.getValue());
            } else if (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_ADD_DOWN_CALLBACK)) {
                this.goApplyTransdownList(BillStatusEnum.SUBMIT.getValue());
            } else if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_CANCELPAY_CALLBACK")) {
                this.getView().invokeOperation("paycancel");
            }
        } else if (MessageBoxResult.No == res && (StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_ADD_UP_CALLBACK) || StringUtils.equals((CharSequence)id, (CharSequence)CONFIRM_ADD_DOWN_CALLBACK))) {
            this.getView().invokeOperation("new");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isshowfilterbarap;
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object param = formShowParameter.getCustomParam("filter");
        if (null != param) {
            String[] filterElements = param.toString().split(":");
            if (filterElements.length != 2) {
                return;
            }
            String property = filterElements[0];
            String value = filterElements[1];
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (null != value && commonFilter.getFieldName().equals(property)) {
                    if (EmptyUtil.isEmpty((String)value)) continue;
                    List<String> defaultValues = Arrays.asList(value.split(","));
                    commonFilter.setDefaultValues(defaultValues);
                    continue;
                }
                commonFilter.setDefaultValue(null);
            }
        }
        if ("no".equals(isshowfilterbarap = (String)formShowParameter.getCustomParam("isshowfilterbarap"))) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                commonFilter.setDefaultValue("");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "changepaychannel": 
            case "discardpaydtl": {
                this.validateSelectSingle(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "barpayconfirm": 
            case "barpaybei": 
            case "barpaycancel": 
            case "paycancel": 
            case "syncbankbillstatus": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "changepaychannel": {
                this.showChangeBill(afterDoOperationEventArgs);
                break;
            }
            case "discardpaydtl": {
                this.showCurrenctBill(afterDoOperationEventArgs);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ParamMap data;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)PAY_CALLBACK) && (data = (ParamMap)closedCallBackEvent.getReturnData()) != null) {
            Date payDate = (Date)data.get("payDate");
            OperateOption op = OperateOption.create();
            op.setVariableValue("paydate", DateUtils.formatString((Date)payDate, (String)"yyyyMMdd"));
            this.getView().invokeOperation("barpayconfirm", op);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("paycancel".equalsIgnoreCase(itemKey)) {
            this.cancelPay();
        } else if ("transdetailbill".equalsIgnoreCase(itemKey)) {
            this.transDetailBill();
        }
    }

    private void cancelPay() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExchangeBillList_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
        } else {
            LinkedList<Long> paymentBillPks = new LinkedList<Long>();
            for (ListSelectedRow selectedRow : selectedRows) {
                paymentBillPks.add((Long)selectedRow.getPrimaryKeyValue());
            }
            String entityName = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            QFilter payPidFilter = new QFilter("id", "in", paymentBillPks);
            DynamicObjectCollection payBills = QueryServiceHelper.query((String)entityName, (String)"id, billno, isvoucher, billstatus", (QFilter[])new QFilter[]{payPidFilter});
            StringBuilder sb = new StringBuilder();
            int flag = 0;
            for (DynamicObject obj : payBills) {
                if (!obj.getBoolean("isvoucher")) continue;
                ++flag;
                String billno = obj.getString("billno");
                sb.append(String.format(ResManager.loadKDString((String)"(%1$s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"TransBillList_7", (String)"tmc-fca-formplugin", (Object[])new Object[0]), billno));
                sb.append("\r\n");
            }
            if (flag == 1) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"TransBillList_8", (String)"tmc-fca-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else if (flag > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%d\u4e2a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"TransBillList_9", (String)"tmc-fca-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"TransBillList_10", (String)"tmc-fca-formplugin", (Object[])new Object[0]), flag), sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            }
        }
    }

    private void transDetailBill() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityId = billList.getBillFormId();
        Object[] selectedRowPks = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedRowPks == null || selectedRowPks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExchangeBillList_0", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] transBills = BusinessDataServiceHelper.load((Object[])selectedRowPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
        ArrayList entryIdList = new ArrayList(10);
        for (DynamicObject transBill : transBills) {
            DynamicObjectCollection entrys = transBill.getDynamicObjectCollection("entrys");
            entryIdList.addAll(entrys.stream().map(v -> v.getPkValue().toString()).collect(Collectors.toList()));
        }
        DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)"ifm_transdetail", (String)"id,bankcheckflag", (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", entryIdList)});
        if (targetBills == null || targetBills.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u3002", (String)"TransBillList_11", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (targetBills.length == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("ifm_transdetail");
            showParameter.setPkId(targetBills[0].get("id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ifm_transdetail");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter filter = new QFilter("bankcheckflag", "in", entryIdList);
            parameter.getListFilterParameter().setFilter(filter);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void validateSelectSingle(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TransBillList_12", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Set idSet = selectedRows.stream().map(r -> r.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (idSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"TransBillList_13", (String)"tmc-fca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void showChangeBill(AfterDoOperationEventArgs args) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (EmptyUtil.isEmpty((Collection)successPkIds)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        showParameter.setCustomParam("sourceId", successPkIds.get(0));
        showParameter.setCustomParam("sourceType", (Object)listShowParameter.getBillFormId());
        showParameter.setFormId("fca_transchgbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showCurrenctBill(AfterDoOperationEventArgs args) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (EmptyUtil.isEmpty((Collection)successPkIds)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        showParameter.setFormId(listShowParameter.getBillFormId());
        showParameter.setPkId(successPkIds.get(0));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

