/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.ebservice.api;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.sync.IPayBillSyncStatusService;
import kd.tmc.fca.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fca.business.ebservice.service.sync.PayBillSyncStatusServiceFactory;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final String OP_SYNVPAYBILLSTATUS = "syncPayBillStatus";
    private static final Log LOGGER = LogFactory.getLog(EBServiceFacadeImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusResult syncPayBillStatus(String entityName, SyncStatusInfo info) {
        LOGGER.info("EBServiceFacadeImpl syncPayBillStatus begin entityName:{} info:{}", (Object)entityName, (Object)SerializationUtils.toJsonString((Object)info));
        String id = String.valueOf(info.getPayBillId());
        boolean lock = MutexServiceHelper.request((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
        if (!lock) {
            DynamicObject payBill = QueryServiceHelper.queryOne((String)entityName, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)info.getPayBillId())});
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(new TmcErrorCode().BILL_MUTEX_LOCK_WITH_NUMBER(payBill.getString("billno")).getMessage());
            result.setStatusCode(EBResultStatusCode.ERROR);
            return result;
        }
        try {
            IPayBillSyncStatusService service = PayBillSyncStatusServiceFactory.createSyncStatusService(entityName);
            SyncStatusResult result = service.syncStatus(info);
            return result;
        }
        catch (Exception e) {
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setStatusCode(EBResultStatusCode.ERROR);
            SyncStatusResult syncStatusResult = result;
            return syncStatusResult;
        }
        finally {
            MutexServiceHelper.release((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
            LOGGER.info("EBServiceFacadeImpl syncPayBillStatus end");
        }
    }
}

