/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.ebservice.service.sync.impl;

import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.sync.IPayBillSyncStatusService;

public abstract class AbstractPayBillSyncStatusService
implements IPayBillSyncStatusService {
    private static final Log logger = LogFactory.getLog(AbstractPayBillSyncStatusService.class);

    public SyncStatusResult syncStatus(SyncStatusInfo info) {
        SyncStatusResult result = new SyncStatusResult();
        StringBuilder errMsg = new StringBuilder();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.doSyncStatusMainProcess(info);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                result.setErrMsg(e.getMessage());
                result.setStatusCode(EBResultStatusCode.ROLLBACK);
                SyncStatusResult syncStatusResult = result;
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return syncStatusResult;
            }
        }
        if (errMsg.length() > 0) {
            result.setStatusCode(EBResultStatusCode.ERROR);
            result.setErrMsg(errMsg.toString());
        } else {
            result.setStatusCode(EBResultStatusCode.SUCCESS);
        }
        return result;
    }

    protected abstract void doSyncStatusMainProcess(SyncStatusInfo var1);

    protected abstract List<IBranchProcess> getBranchProcess();

    static interface IBranchProcess {
        public String doBranchProcessWithoutException();

        public String getProcessName();
    }
}

