/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.ebservice.service.sync.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusDetail;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.fca.business.ebservice.service.sync.impl.AbstractPayBillSyncStatusService;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.property.DetailStatus;

public class TransBillSyncStatusService
extends AbstractPayBillSyncStatusService {
    private static final Log LOGGER = LogFactory.getLog(TransBillSyncStatusService.class);
    private DynamicObject transBill;

    @Override
    protected void doSyncStatusMainProcess(SyncStatusInfo info) {
        LOGGER.info("TransBillSyncStatusService doSyncStatusMainProcess begin");
        Long payBillId = info.getPayBillId();
        this.transBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)info.getEntityType());
        if (this.transBill == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u636e:[%1$s-%2$s]", (String)"TransBillSyncStatusService_0", (String)"tmc-fca-business", (Object[])new Object[0]), info.getEntityType(), info.getPayBillId()));
        }
        DynamicObjectCollection entries = this.transBill.getDynamicObjectCollection("entrys");
        HashMap<String, DetailStatus> detailMap = new HashMap<String, DetailStatus>();
        for (SyncStatusDetail detail : info.getDetailList()) {
            Long entryId = detail.getPayBillEntryId();
            for (DynamicObject entry : entries) {
                if (!entry.getPkValue().equals(entryId)) continue;
                DetailStatus status = new DetailStatus();
                status.setPayStatus(FcaTransPayStatusEnum.beiBankStatusTransfor((String)detail.getBankEntryPayStatus()));
                status.setPayReturninfo(detail.getBankMsg());
                status.setBankcheckflag(detail.getBankDetailSeqId());
                status.setPayDate(detail.getPayDate());
                detailMap.put(entryId.toString(), status);
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("detailMap", JSON.toJSONString(detailMap));
        option.setVariableValue("dateType", info.getEntityType());
        option.setVariableValue("source", "sync");
        if ("fca_transupbill".equals(info.getEntityType())) {
            option.setVariableValue("isLock", "true");
        }
        TmcOperateServiceHelper.execOperate((String)"sync", (String)info.getEntityType(), (DynamicObject[])new DynamicObject[]{this.transBill}, (OperateOption)option);
        LOGGER.info("TransBillSyncStatusService doSyncStatusMainProcess end");
    }

    @Override
    protected List<AbstractPayBillSyncStatusService.IBranchProcess> getBranchProcess() {
        return Collections.singletonList(this.syncCasBill());
    }

    private AbstractPayBillSyncStatusService.IBranchProcess syncCasBill() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                return null;
            }

            @Override
            public String getProcessName() {
                return "syncCasBill";
            }
        };
    }
}

