/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.acctgroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fca.common.helper.AcctGroupRelInnerAcctHelper;
import kd.tmc.fca.common.helper.CodeRuleHelper;
import kd.tmc.fca.common.helper.SystemParameterHelper;
import kd.tmc.fca.common.helper.TransBillHelper;

public class SynLinkPayRelationService
extends AbstractTmcBizOppService {
    private List<DynamicObject> saveList = new ArrayList<DynamicObject>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("accountbank");
        selector.add("currency");
        selector.add("company");
        selector.add("bankacct");
        selector.add("inneracct");
        selector.add("org");
        selector.add("id");
        selector.add("entryentity.e_account");
        selector.add("entryentity.e_parentacct");
        selector.add("entryentity.e_internalacct");
        return selector;
    }

    /*
     * Could not resolve type clashes
     */
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            if (!dataEntity.getBoolean("enable")) {
                return;
            }
            DynamicObjectCollection entrysRows = (DynamicObjectCollection)dataEntity.get("entrys");
            DynamicObject currency = (DynamicObject)dataEntity.get("currency");
            DynamicObject company = (DynamicObject)dataEntity.get("company");
            DynamicObject accountbank = (DynamicObject)dataEntity.get("accountbank");
            Object currpk = currency.getPkValue();
            String op = (String)this.getOperationVariable().get("opkey");
            boolean issynlinkpay = SystemParameterHelper.getAppBoolParameter((String)TmcAppEnum.FCA.getId(), (long)((Long)company.getPkValue()), (String)"issynlinkpay");
            if (!"synlinkpay".equals(op) && !issynlinkpay) continue;
            AcctGroupRelInnerAcctHelper.fillInnerAccounts((DynamicObject)dataEntity);
            Map<Object, List<DynamicObject>> sonCompanyMap = entrysRows.stream().filter(e -> e.get("bankacct") != null).collect(Collectors.groupingBy(e -> e.getDynamicObject("bankacct").getDynamicObject("company").getPkValue()));
            Map<Object, DynamicObject> sonAcctMap = entrysRows.stream().filter(e -> e.get("bankacct") != null).collect(Collectors.toMap(e -> e.getDynamicObject("bankacct").getPkValue(), e -> e.getDynamicObject("bankacct"), (e1, e2) -> e1));
            for (Map.Entry<Object, List<DynamicObject>> sonCompanyEntry : sonCompanyMap.entrySet()) {
                DynamicObject linkPayBill;
                HashMap<Long, List> map = new HashMap<Long, List>(16);
                HashMap<Long, Object> innerAcctIdMap = new HashMap<Long, Object>(entrysRows.size());
                HashMap<Long, Object> parentAcctIdMap = new HashMap<Long, Object>(entrysRows.size());
                ArrayList<Long> nonExistentList = new ArrayList<Long>(10);
                Map innerAcctMap = TransBillHelper.getBankAcctByInnerAcct(sonCompanyEntry.getValue().stream().filter(e -> e.getDynamicObject("inneracct") != null).map(e -> e.getDynamicObject("inneracct")).collect(Collectors.toSet()));
                for (DynamicObject row : sonCompanyEntry.getValue()) {
                    DynamicObject entryBankAcct = row.getDynamicObject("bankacct");
                    if (entryBankAcct == null) continue;
                    DynamicObject[] bankAcctId = entryBankAcct.getLong("id");
                    DynamicObject innerAcct = row.getDynamicObject("inneracct");
                    Object innerId = null;
                    if (innerAcct != null && innerAcctMap.get(innerAcct.getPkValue()) != null) {
                        innerId = ((DynamicObject)innerAcctMap.get(innerAcct.getPkValue())).getPkValue();
                    }
                    innerAcctIdMap.put((Long)bankAcctId, innerId);
                    parentAcctIdMap.put((Long)bankAcctId, accountbank == null ? null : accountbank.getPkValue());
                }
                QFilter qfilter1 = new QFilter("currency", "=", currpk);
                QFilter qfilter2 = new QFilter("entryentity.e_account", "in", innerAcctIdMap.keySet());
                DynamicObject[] linkpays = BusinessDataServiceHelper.load((String)"am_linkpayrelation", (String)"id,entryentity.e_account,entryentity.e_internalacct,entryentity.e_parentacct", (QFilter[])new QFilter[]{qfilter1, qfilter2});
                if (linkpays.length > 0) {
                    for (Map.Entry entry : innerAcctIdMap.entrySet()) {
                        DynamicObject linkpay;
                        DynamicObjectCollection entrys;
                        boolean anyMatchFlag = false;
                        DynamicObject[] dynamicObjectArray = linkpays;
                        int n = dynamicObjectArray.length;
                        for (int i = 0; i < n && !(anyMatchFlag = (entrys = (linkpay = dynamicObjectArray[i]).getDynamicObjectCollection("entryentity")).stream().anyMatch(a -> Objects.equals(entry.getValue(), a.getDynamicObject("e_internalacct") == null ? null : a.getDynamicObject("e_internalacct").getPkValue()) && Objects.equals(parentAcctIdMap.get(entry.getKey()), a.getDynamicObject("e_parentacct") == null ? null : a.getDynamicObject("e_parentacct").getPkValue()) && Objects.equals(entry.getKey(), a.getDynamicObject("e_account") == null ? null : a.getDynamicObject("e_account").getPkValue()))); ++i) {
                        }
                        if (anyMatchFlag) continue;
                        nonExistentList.add((Long)entry.getKey());
                    }
                    for (DynamicObject linkpay : linkpays) {
                        DynamicObjectCollection entryentity = linkpay.getDynamicObjectCollection("entryentity");
                        for (DynamicObject e3 : entryentity) {
                            map.computeIfAbsent(linkpay.getLong("id"), k -> new ArrayList());
                            map.computeIfPresent(linkpay.getLong("id"), (k, v) -> {
                                if (e3.getDynamicObject("e_account") != null) {
                                    v.add(e3.getDynamicObject("e_account").getPkValue());
                                }
                                return v;
                            });
                        }
                    }
                } else {
                    nonExistentList.addAll(innerAcctIdMap.keySet());
                }
                if (map.size() == 0) {
                    linkPayBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_linkpayrelation"));
                    linkPayBill.set("currency", currpk);
                    linkPayBill.set("org", sonCompanyEntry.getKey());
                    linkPayBill.set("number", (Object)CodeRuleHelper.generateNumber((String)"am_linkpayrelation", (DynamicObject)linkPayBill, null, null));
                    Object newBillIds = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"am_linkpayrelation").getAlias(), (int)1);
                    linkPayBill.set("id", (Object)((long)newBillIds[0]));
                    linkPayBill.set("masterid", (Object)((long)newBillIds[0]));
                    linkPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                    linkPayBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    linkPayBill.set("status", (Object)"A");
                    linkPayBill.set("enable", (Object)"0");
                    linkPayBill.set("acctpaymodel", (Object)"0");
                    linkPayBill.set("comment", (Object)ResManager.getLocaleString((String)"\u6bcd\u5b50\u8d26\u6237\u7ec4\u540c\u6b65\u751f\u6210\u3002", (String)"SynLinkPayRelationService_0", (String)"tmc-fca-business"));
                    this.buildEntry(nonExistentList, linkPayBill, innerAcctIdMap, parentAcctIdMap, sonAcctMap);
                    continue;
                }
                if (map.size() == 1) {
                    linkPayBill = BusinessDataServiceHelper.loadSingle((String)"am_linkpayrelation", (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())});
                    this.buildEntry(nonExistentList, linkPayBill, innerAcctIdMap, parentAcctIdMap, sonAcctMap);
                    continue;
                }
                for (Map.Entry entry : map.entrySet()) {
                    List<Long> nonExistentList1;
                    Object key = entry.getKey();
                    List value = (List)entry.getValue();
                    if (value.containsAll(nonExistentList)) {
                        nonExistentList1 = nonExistentList.stream().filter(value::contains).collect(Collectors.toList());
                        linkPayBill = BusinessDataServiceHelper.loadSingle(key, (String)"am_linkpayrelation");
                        this.buildEntry(nonExistentList1, linkPayBill, innerAcctIdMap, parentAcctIdMap, sonAcctMap);
                        continue;
                    }
                    nonExistentList1 = nonExistentList.stream().filter(value::contains).collect(Collectors.toList());
                    linkPayBill = BusinessDataServiceHelper.loadSingle(key, (String)"am_linkpayrelation");
                    this.buildEntry(nonExistentList1, linkPayBill, innerAcctIdMap, parentAcctIdMap, sonAcctMap);
                    nonExistentList.removeAll(nonExistentList1);
                }
                if (nonExistentList.isEmpty()) continue;
                linkPayBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"am_linkpayrelation"));
                linkPayBill.set("currency", currpk);
                linkPayBill.set("org", company.getPkValue());
                linkPayBill.set("number", (Object)CodeRuleHelper.generateNumber((String)"am_linkpayrelation", (DynamicObject)linkPayBill, null, null));
                long[] newbillIds = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"am_linkpayrelation").getAlias(), (int)1);
                linkPayBill.set("id", (Object)newbillIds[0]);
                linkPayBill.set("masterid", (Object)newbillIds[0]);
                linkPayBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                linkPayBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                linkPayBill.set("status", (Object)"A");
                linkPayBill.set("enable", (Object)"0");
                linkPayBill.set("acctpaymodel", (Object)"0");
                linkPayBill.set("comment", (Object)ResManager.getLocaleString((String)"\u6bcd\u5b50\u8d26\u6237\u7ec4\u540c\u6b65\u751f\u6210\u3002", (String)"SynLinkPayRelationService_0", (String)"tmc-fca-business"));
                this.buildEntry(nonExistentList, linkPayBill, innerAcctIdMap, parentAcctIdMap, sonAcctMap);
            }
        }
        if (!this.saveList.isEmpty()) {
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])this.saveList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void buildEntry(List<Long> nonExistentList, DynamicObject linkPayBill, Map<Long, Object> innerAcctIdMap, Map<Long, Object> parentAcctIdMap, Map<Object, DynamicObject> sonAcctMap) {
        if (!nonExistentList.isEmpty()) {
            for (Long entryAcctId : nonExistentList) {
                DynamicObject entry = linkPayBill.getDynamicObjectCollection("entryentity").addNew();
                DynamicObject entryAcct = sonAcctMap.get(entryAcctId);
                if (entryAcct != null) {
                    entry.set("e_account", (Object)entryAcctId);
                    entry.set("e_acctname", entryAcct.get("acctname"));
                    entry.set("e_bank", entryAcct.get("bank.name"));
                }
                entry.set("e_parentacct", parentAcctIdMap.get(entryAcctId));
                entry.set("e_internalacct", innerAcctIdMap.get(entryAcctId));
            }
            this.saveList.add(linkPayBill);
        }
    }
}

