/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.applytransbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fca.common.helper.TransBillHelper;

public class ApplyTransBillSubmitService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(ApplyTransBillSubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applyamt");
        selector.add("transamt");
        selector.add("transamount");
        selector.add("amount");
        selector.add("currency");
        selector.add("parentorg");
        selector.add("subacct");
        selector.add("inneracct");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("ApplyTransBillSubmitService begin");
        List list = Arrays.stream(dataEntities).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("subacct") != null)).collect(Collectors.toList());
        Map orgInnerAccountMap = new HashMap(16);
        if (!list.isEmpty()) {
            Set bankAccountIds = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
        }
        for (DynamicObject applyTransBill : dataEntities) {
            DynamicObject currency = applyTransBill.getDynamicObject("currency");
            DynamicObject parentOrg = applyTransBill.getDynamicObject("parentorg");
            DynamicObjectCollection details = applyTransBill.getDynamicObjectCollection("entrys");
            details.removeIf(v -> v.getBigDecimal("applyamt").compareTo(Constants.ZERO) <= 0);
            details.forEach(v -> {
                v.set("transamt", null);
                v.set("transamt", v.get("applyamt"));
            });
            BigDecimal transSumAmt = details.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("transamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyTransBill.set("transamount", (Object)transSumAmt);
            BigDecimal transApplySumAmt = details.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("applyamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyTransBill.set("amount", (Object)transApplySumAmt);
            if (currency == null || orgInnerAccountMap == null || parentOrg == null || !orgInnerAccountMap.containsKey(parentOrg.getPkValue())) continue;
            for (DynamicObject detail : details) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                if (detail.getDynamicObject("subacct") == null) continue;
                DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(parentOrg.getPkValue())).get(detail.getDynamicObject("subacct").getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                detail.set("inneracct", (Object)innerAccount);
            }
        }
        LOGGER.info("ApplyTransBillSubmitService end");
    }
}

