/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.autotrans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class AutoTransDelService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        List intellExceIds = Stream.of(dataEntities).map(v -> v.getString("id")).collect(Collectors.toList());
        List intellExceIdsNew = intellExceIds.stream().map(o -> Long.parseLong(o.trim())).collect(Collectors.toList());
        DynamicObject[] intellExces = TmcDataServiceHelper.load((String)"gl_intellexecschema", (String)"id,sheduleplanid", (QFilter[])new QFilter[]{new QFilter("id", "in", intellExceIdsNew)});
        this.delintellExce(intellExces);
        List numbers = Stream.of(dataEntities).map(v -> v.getString("number")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)"fca_autotranslog", (QFilter[])new QFilter[]{new QFilter("autotrans", "in", numbers)});
    }

    private void delintellExce(DynamicObject[] intellExces) {
        this.delSch(intellExces);
        List intellExceIds = Stream.of(intellExces).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("intelschemaid", "in", intellExceIds)};
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"gl_intellexecschema", (QFilter[])new QFilter[]{new QFilter("id", "in", intellExceIds)});
            DeleteServiceHelper.delete((String)"gl_intellexecdetaillog", (QFilter[])filters);
            DeleteServiceHelper.delete((String)"gl_intellopersumlog", (QFilter[])filters);
            DeleteServiceHelper.delete((String)"gl_intelschemasumlog", (QFilter[])filters);
        }
    }

    private void delSch(DynamicObject[] intellExces) {
        ArrayList scheduleIds = new ArrayList();
        Arrays.asList(intellExces).stream().forEach(v -> scheduleIds.add(v.get("sheduleplanid")));
        DynamicObject[] schedules = TmcDataServiceHelper.load((String)"sch_schedule", (String)"id,job", (QFilter[])new QFilter[]{new QFilter("id", "in", scheduleIds)});
        ArrayList jobIds = new ArrayList();
        Arrays.asList(schedules).stream().forEach(v -> jobIds.add(v.getDynamicObject("job").getPkValue()));
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter[]{new QFilter("id", "in", jobIds)});
            DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])new QFilter[]{new QFilter("id", "in", scheduleIds)});
        }
    }
}

