/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.autotrans;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;

public class AutoTransSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("starttime");
        selector.add("endtime");
        selector.add("txtdesc");
        selector.add("status");
        selector.add("creator");
        selector.add("modifier");
        selector.add("enable");
        selector.add("createtime");
        selector.add("modifytime");
        selector.add("masterid");
        selector.add("datafilter");
        selector.add("comment");
        selector.add("sheduleplanid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject autoTrans : dataEntities) {
            DynamicObject intellExecSchema = null;
            boolean exists = TmcDataServiceHelper.exists((Object)autoTrans.getPkValue(), (String)"fca_autotrans");
            intellExecSchema = !exists ? TmcDataServiceHelper.newDynamicObject((String)"gl_intellexecschema") : TmcDataServiceHelper.loadSingle((String)"gl_intellexecschema", (String)"datafilter,status,sheduleplanid,operationentry,oper,remark,creator,executor,modifier,enable,createtime,modifytime,responsibleperson,exceplan,masterid,endtime", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)autoTrans.getString("number"))});
            this.createExecSchema(autoTrans, intellExecSchema);
        }
    }

    private void createExecSchema(DynamicObject autoTrans, DynamicObject intellExecSchema) {
        intellExecSchema.set("number", (Object)autoTrans.getString("number"));
        intellExecSchema.set("name", (Object)autoTrans.getString("name"));
        intellExecSchema.set("status", (Object)"C");
        intellExecSchema.set("creator", autoTrans.getDynamicObject("creator").getPkValue());
        intellExecSchema.set("executor", autoTrans.getDynamicObject("creator").getPkValue());
        intellExecSchema.set("creator", autoTrans.getDynamicObject("creator").getPkValue());
        if (autoTrans.getDynamicObject("modifier") == null) {
            intellExecSchema.set("modifier", autoTrans.getDynamicObject("creator").getPkValue());
        } else {
            intellExecSchema.set("modifier", autoTrans.getDynamicObject("modifier").getPkValue());
        }
        intellExecSchema.set("enable", autoTrans.get("enable"));
        intellExecSchema.set("createtime", (Object)autoTrans.getDate("createtime"));
        intellExecSchema.set("modifytime", (Object)autoTrans.getDate("modifytime"));
        intellExecSchema.set("responsibleperson", autoTrans.getDynamicObject("creator").getPkValue());
        intellExecSchema.set("exceplan", autoTrans.get("txtdesc"));
        intellExecSchema.set("masterid", autoTrans.get("masterid"));
        intellExecSchema.set("endtime", (Object)autoTrans.getDate("endtime"));
        intellExecSchema.set("sheduleplanid", autoTrans.get("sheduleplanid"));
        String type = autoTrans.getString("type");
        DynamicObjectCollection entrys = intellExecSchema.getDynamicObjectCollection("operationentry");
        if (entrys.size() != 0) {
            DynamicObject entry = (DynamicObject)entrys.get(0);
            entry.set("remark", (Object)autoTrans.getString("comment"));
            entry.set("datafilter", (Object)autoTrans.getString("datafilter"));
        } else {
            intellExecSchema.set("id", autoTrans.get("id"));
            DynamicObject newRow = entrys.addNew();
            newRow.set("bussiness", (Object)"fca_autotrans");
            if (FcaTransTypeEnum.TRANSFER.getValue().equals(type)) {
                newRow.set("oper", (Object)"executetransfer");
            } else {
                newRow.set("oper", (Object)"execautotrans");
            }
            newRow.set("appid", (Object)"/WJL3RFSDXE9");
            newRow.set("entity", (Object)"fca_autotrans");
            newRow.set("remark", (Object)autoTrans.getString("comment"));
            newRow.set("datafilter", (Object)autoTrans.getString("datafilter"));
        }
        try (TXHandle tx = TX.requiresNew();){
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{intellExecSchema});
        }
    }
}

