/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.VoucherHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.ExecstatusEnum;
import kd.tmc.fca.common.enums.FcaOperNameEnum;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;
import kd.tmc.fca.common.helper.AcctGroupRelInnerAcctHelper;
import kd.tmc.fca.common.helper.AmtCalcHelper;
import kd.tmc.fca.common.resource.FcaBizResource;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillAutoService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransBillAutoService.class);
    private final Map<Object, DynamicObject> bankAndBeBankMap = new HashMap<Object, DynamicObject>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("opername");
        selector.add("number");
        selector.add("type");
        selector.add("name");
        selector.add("comment");
        selector.add("executor");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        this.processOnAutoTrans(dataEntities[0]);
    }

    private void processOnAutoTrans(DynamicObject autoTrans) {
        boolean isPay = FcaOperNameEnum.DOSUBMITBEI.getValue().equals(autoTrans.getString("opername"));
        boolean isUpFlag = FcaTransTypeEnum.TRANSUP.getValue().equals(autoTrans.getString("type"));
        String type = isUpFlag ? "autotransup" : "autotransdown";
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fca_autotranslog");
        log.set("autotrans", (Object)autoTrans.getString("number"));
        log.set("opername", (Object)autoTrans.getString("opername"));
        log.set("excetime", (Object)new Date());
        log.set("execstatus", (Object)ExecstatusEnum.SUCCESS.getValue());
        log.set("execdetl", (Object)"");
        log.set("type", (Object)autoTrans.getString("type"));
        try {
            Object[] acctGroups = TmcDataServiceHelper.load((String)"fca_acctgroup", (String)"id, number, company, accountbank, currency, bankacct, transtrategy, transtrategy.istransup, autotransup, autotransdown, inneracct, isdefault", (QFilter[])new QFilter[]{new QFilter("entrys." + type, "=", autoTrans.getPkValue()), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())}, (String)"number");
            if (EmptyUtil.isEmpty((Object[])acctGroups)) {
                String typeName = isUpFlag ? FcaBizResource.getAutoUp() : FcaBizResource.getAutoDown();
                log.set("execdetl", (Object)new LocaleString(new FcaBizResource().getAutoLogMain(0, 0, typeName)));
                TmcOperateServiceHelper.execOperate((String)"save", (String)"fca_autotranslog", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)OperateOption.create());
                return;
            }
            this.getBankInfos((DynamicObject[])acctGroups);
            Map<String, Pair<DynamicObject, List<DynamicObject>>> acctGroupMap = this.transfAcctGroups((DynamicObject[])acctGroups, log, isUpFlag, (Long)autoTrans.getPkValue());
            for (Pair<DynamicObject, List<DynamicObject>> pair : acctGroupMap.values()) {
                if (isUpFlag) {
                    this.genTransUpInfo((DynamicObject)pair.getLeft(), (List)pair.getRight(), isPay, log, autoTrans);
                    continue;
                }
                this.genTransDownInfo((DynamicObject)pair.getLeft(), (List)pair.getRight(), isPay, log, autoTrans);
            }
            this.saveLog(log, isUpFlag);
        }
        catch (Exception e) {
            logger.error("processOnAutoTrans exception: " + e);
            this.saveLog(log, isUpFlag);
        }
    }

    private void getBankInfos(DynamicObject[] acctGroups) {
        HashSet<Object> bankIdSet = new HashSet<Object>(10);
        for (DynamicObject acctGroup : acctGroups) {
            bankIdSet.add(acctGroup.getDynamicObject("accountbank").getDynamicObject("bank").getPkValue());
            DynamicObjectCollection entries = acctGroup.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                bankIdSet.add(entry.getDynamicObject("bankacct").getDynamicObject("bank").getPkValue());
            }
        }
        if (!bankIdSet.isEmpty()) {
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank.id beBankId,bebank.country.id countryid,bebank.provincetxt,bebank.citytxt", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIdSet)});
            for (DynamicObject bank : banks) {
                this.bankAndBeBankMap.put(bank.get("id"), bank);
            }
        }
    }

    private void saveLog(DynamicObject log, boolean isUpFlag) {
        String typeName;
        int succCount = 0;
        int failCount = 0;
        DynamicObjectCollection logEntrys = log.getDynamicObjectCollection("entry");
        for (DynamicObject logEntry : logEntrys) {
            if (ExecstatusEnum.SUCCESS.getValue().equals(logEntry.getString("status"))) {
                ++succCount;
                continue;
            }
            ++failCount;
        }
        String string = typeName = isUpFlag ? FcaBizResource.getAutoUp() : FcaBizResource.getAutoDown();
        if (failCount > 0) {
            log.set("execstatus", (Object)ExecstatusEnum.FAIL.getValue());
        }
        log.set("execdetl", (Object)new LocaleString(new FcaBizResource().getAutoLogMain(succCount, failCount, typeName)));
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fca_autotranslog", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)OperateOption.create());
    }

    private Map<String, Pair<DynamicObject, List<DynamicObject>>> transfAcctGroups(DynamicObject[] acctGroups, DynamicObject log, boolean isUpFlag, Long autoTransId) {
        HashMap<String, Pair<DynamicObject, List<DynamicObject>>> acctGroupEntryMap = new HashMap<String, Pair<DynamicObject, List<DynamicObject>>>(16);
        HashMap<Object, List> sonAccountIdMap = new HashMap<Object, List>(16);
        HashMap<Object, List> sonAccountIdDefaultMap = new HashMap<Object, List>(16);
        for (DynamicObject acctGroup : acctGroups) {
            boolean isDefault = acctGroup.getBoolean("isdefault");
            DynamicObjectCollection entries = acctGroup.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject autoTransfer = isUpFlag ? entry.getDynamicObject("autotransup") : entry.getDynamicObject("autotransdown");
                if (EmptyUtil.isEmpty((DynamicObject)autoTransfer) || ((Long)autoTransfer.getPkValue()).compareTo(autoTransId) != 0) continue;
                DynamicObject sonAccount = entry.getDynamicObject("bankacct");
                if (isDefault) {
                    sonAccountIdDefaultMap.computeIfAbsent(sonAccount.getPkValue(), k -> new ArrayList());
                    sonAccountIdDefaultMap.computeIfPresent(sonAccount.getPkValue(), (k, v) -> {
                        v.add(acctGroup.getPkValue());
                        return v;
                    });
                    continue;
                }
                sonAccountIdMap.computeIfAbsent(sonAccount.getPkValue(), k -> new ArrayList());
                sonAccountIdMap.computeIfPresent(sonAccount.getPkValue(), (k, v) -> {
                    v.add(acctGroup.getPkValue());
                    return v;
                });
            }
        }
        for (DynamicObject acctGroup : acctGroups) {
            List<DynamicObject> acctGroupEntry;
            String key = acctGroup.getPkValue().toString();
            Pair pair = (Pair)acctGroupEntryMap.get(key);
            if (pair == null) {
                acctGroupEntry = new ArrayList();
                acctGroupEntryMap.put(key, (Pair<DynamicObject, List<DynamicObject>>)Pair.of((Object)acctGroup, acctGroupEntry));
            } else {
                acctGroupEntry = (List)pair.getRight();
            }
            AcctGroupRelInnerAcctHelper.fillInnerAccounts((DynamicObject)acctGroup);
            DynamicObjectCollection entries = acctGroup.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject transtrategy;
                DynamicObject autotrans = isUpFlag ? entry.getDynamicObject("autotransup") : entry.getDynamicObject("autotransdown");
                if (EmptyUtil.isEmpty((DynamicObject)autotrans) || ((Long)autotrans.getPkValue()).compareTo(autoTransId) != 0) continue;
                DynamicObject sonAccount = entry.getDynamicObject("bankacct");
                if (sonAccountIdDefaultMap.containsKey(sonAccount.getPkValue())) {
                    if (((List)sonAccountIdDefaultMap.get(sonAccount.getPkValue())).size() > 1 || !((List)sonAccountIdDefaultMap.get(sonAccount.getPkValue())).contains(acctGroup.getPkValue())) {
                        this.createLogger(log, acctGroup, entry, ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5173\u8054\u591a\u4e2a\u6bcd\u5b50\u7ec4\u4e14\u975e\u552f\u4e00\u9ed8\u8ba4\u3002", (String)"TransBillAutoService_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                        continue;
                    }
                } else if (sonAccountIdMap.containsKey(sonAccount.getPkValue()) && (((List)sonAccountIdMap.get(sonAccount.getPkValue())).size() > 1 || !((List)sonAccountIdMap.get(sonAccount.getPkValue())).contains(acctGroup.getPkValue()))) {
                    this.createLogger(log, acctGroup, entry, ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5173\u8054\u591a\u4e2a\u6bcd\u5b50\u7ec4\u4e14\u975e\u552f\u4e00\u9ed8\u8ba4\u3002", (String)"TransBillAutoService_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                    continue;
                }
                if (!EmptyUtil.isEmpty((DynamicObject)(transtrategy = entry.getDynamicObject("transtrategy")))) {
                    transtrategy = TmcDataServiceHelper.loadSingle((Object)transtrategy.getPkValue(), (String)"fca_transtrategy");
                    entry.set("transtrategy", (Object)transtrategy);
                }
                acctGroupEntry.add(entry);
            }
        }
        return acctGroupEntryMap;
    }

    private DynamicObject genTransMain(DynamicObject acctGroup, String entityName, boolean isPay, DynamicObject autoTrans) {
        DynamicObject form = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        Long pkId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)entityName).getAlias());
        form.set("id", (Object)pkId);
        if (isPay) {
            form.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            form.set("auditor", (Object)autoTrans.getDynamicObject("executor"));
        } else {
            form.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        Object bankId = acctGroup.getDynamicObject("accountbank").getDynamicObject("bank").getPkValue();
        form.set("company", (Object)acctGroup.getDynamicObject("company"));
        form.set("accountbank", (Object)acctGroup.getDynamicObject("accountbank"));
        form.set("bank", bankId);
        form.set("currency", (Object)acctGroup.getDynamicObject("currency"));
        form.set("amount", (Object)BigDecimal.ZERO);
        form.set("transcount", (Object)0);
        form.set("transsucamt", (Object)BigDecimal.ZERO);
        form.set("transsuccount", (Object)0);
        form.set("sourcetype", (Object)FcaTransSourceTypeEnum.AUTOTRAN.getValue());
        form.set("acctgrpid", (Object)acctGroup);
        form.set("description", (Object)autoTrans.getString("comment"));
        form.set("creator", (Object)autoTrans.getDynamicObject("executor"));
        Date date = new Date();
        form.set("transbilldate", (Object)date);
        form.set("bizdate", (Object)date);
        DynamicObject bankInfo = this.bankAndBeBankMap.get(bankId);
        if (bankInfo != null) {
            form.set("country", (Object)bankInfo.getLong("countryid"));
            form.set("province", (Object)bankInfo.getString("bebank.provincetxt"));
            form.set("city", (Object)bankInfo.getString("bebank.cityTxt"));
        }
        DynamicObject paymentIdentify = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_paymentidentify", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"0"), new QFilter("isdefault", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
        form.set("payflag", (Object)paymentIdentify);
        return form;
    }

    private void fillBeBankInfo(DynamicObject subAcct, DynamicObject line) {
        DynamicObject dynamicObject = this.bankAndBeBankMap.get(subAcct.getDynamicObject("bank").getPkValue());
        if (dynamicObject != null) {
            line.set("entrycountry", dynamicObject.get("countryid"));
            line.set("entryprovince", dynamicObject.get("bebank.provincetxt"));
            line.set("entrycity", dynamicObject.get("bebank.citytxt"));
        }
    }

    private DynamicObject createLogger(DynamicObject log, DynamicObject acctGroup, DynamicObject acctGroupEntry, String msg, String status) {
        DynamicObject entry = this.createLogger(log, acctGroup, acctGroupEntry, msg);
        entry.set("status", (Object)status);
        return entry;
    }

    private DynamicObject createLogger(DynamicObject log, DynamicObject acctGroup, DynamicObject acctGroupEntry, String msg) {
        DynamicObjectCollection entrys = log.getDynamicObjectCollection("entry");
        DynamicObject entry = entrys.addNew();
        entry.set("acctgroup", acctGroup.getPkValue());
        entry.set("pbankacct", acctGroup.getDynamicObject("accountbank").getPkValue());
        entry.set("sbankacct", acctGroupEntry.getDynamicObject("bankacct").getPkValue());
        entry.set("inneracct", acctGroupEntry.get("inneracct"));
        entry.set("transtrategy", (Object)acctGroupEntry.getDynamicObject("transtrategy"));
        entry.set("status", (Object)ExecstatusEnum.FAIL.getValue());
        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 400) {
            msg = msg.substring(0, 400);
        }
        entry.set("detail", (Object)msg);
        return entry;
    }

    private void genTransDownInfo(DynamicObject acctGroup, List<DynamicObject> entries, boolean isPay, DynamicObject log, DynamicObject autoTrans) {
        String entityName = "fca_transdownbill";
        DynamicObject currency = acctGroup.getDynamicObject("currency");
        DynamicObject accountBank = acctGroup.getDynamicObject("accountbank");
        boolean masterIsOpenBei = accountBank.getBoolean("issetbankinterface");
        String payChanel = masterIsOpenBei ? FcaTransPayChanEnum.BEI.getValue() : FcaTransPayChanEnum.ONLINE.getValue();
        DynamicObject down = this.genTransMain(acctGroup, entityName, isPay, autoTrans);
        DynamicObjectCollection lineDown = down.getDynamicObjectCollection("entrys");
        HashMap<Long, List<DynamicObject>> logEntryMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject entry : entries) {
            if (isPay && !masterIsOpenBei) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoNoBeiDown());
                continue;
            }
            DynamicObject transtrategy = entry.getDynamicObject("transtrategy");
            if (transtrategy == null) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoNoStrategy());
                continue;
            }
            if (!transtrategy.getBoolean("enable")) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoEnableStrategy());
                continue;
            }
            DynamicObject subAcct = entry.getDynamicObject("bankacct");
            BigDecimal refAmt = AmtCalcHelper.getBillTransDownRefTransAmt((DynamicObject)subAcct, (Object)currency.getPkValue(), (DynamicObject)entry.getDynamicObject("transtrategy"));
            if (refAmt == null || refAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoRefAmtZero((BigDecimal)refAmt));
                continue;
            }
            DynamicObject line = lineDown.addNew();
            line.set("paychanel", (Object)payChanel);
            line.set("state", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
            line.set("paystatus", (Object)FcaTransPayStatusEnum.INIT.getValue());
            line.set("subacct", (Object)subAcct);
            line.set("subacct_company", (Object)subAcct.getDynamicObject("company"));
            line.set("referamt", (Object)refAmt);
            line.set("transamt", (Object)refAmt);
            line.set("iscashbill", (Object)"0");
            line.set("isifmbill", (Object)"0");
            line.set("isinneracccashbill", (Object)"0");
            line.set("inneracct", entry.get("inneracct"));
            this.fillBeBankInfo(subAcct, line);
            DynamicObject innerAcct = entry.getDynamicObject("inneracct");
            if (innerAcct != null) {
                DynamicObject bankAcctByInnerAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)innerAcct);
                line.set("inneracctbank", (Object)bankAcctByInnerAcct);
            }
            DynamicObject logEntry = this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoSuccDown(), ExecstatusEnum.SUCCESS.getValue());
            logEntry.set("billno", down.getPkValue());
            ArrayList<DynamicObject> logEntryList = (ArrayList<DynamicObject>)logEntryMap.get((Long)down.getPkValue());
            if (EmptyUtil.isEmpty((Collection)logEntryList)) {
                logEntryList = new ArrayList<DynamicObject>();
                logEntryMap.put((Long)down.getPkValue(), logEntryList);
            }
            logEntryList.add(logEntry);
            down.set("amount", (Object)refAmt.add(down.getBigDecimal("amount")));
            down.set("transcount", (Object)(down.getInt("transcount") + 1));
        }
        this.doSaveAndCommitBei(down, isPay, logEntryMap);
    }

    private void genTransUpInfo(DynamicObject acctGroup, List<DynamicObject> entries, boolean isPay, DynamicObject log, DynamicObject autoTrans) {
        String entityName = "fca_transupbill";
        DynamicObject currency = acctGroup.getDynamicObject("currency");
        DynamicObject upBill = this.genTransMain(acctGroup, entityName, isPay, autoTrans);
        DynamicObjectCollection lineUp = upBill.getDynamicObjectCollection("entrys");
        HashMap<Long, List<DynamicObject>> logEntryMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject entry : entries) {
            if (!BankAcctStatusEnum.NORMAL.getValue().equals(acctGroup.getDynamicObject("accountbank").getString("acctstatus"))) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoMasterAcctNormal());
                continue;
            }
            DynamicObject subAcct = entry.getDynamicObject("bankacct");
            if (!BankAcctStatusEnum.NORMAL.getValue().equals(subAcct.getString("acctstatus"))) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoChildAcctNormal());
                continue;
            }
            DynamicObject transTrategy = entry.getDynamicObject("transtrategy");
            if (transTrategy == null) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoNoStrategy());
                continue;
            }
            if (!transTrategy.getBoolean("enable")) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoEnableStrategy());
                continue;
            }
            boolean subIsOpenBei = subAcct.getBoolean("issetbankinterface");
            if (isPay && !subIsOpenBei) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoNoBeiUp());
                continue;
            }
            String paychanel = subIsOpenBei ? FcaTransPayChanEnum.BEI.getValue() : FcaTransPayChanEnum.ONLINE.getValue();
            DynamicObject subAcctCompany = (DynamicObject)entry.getDynamicObject("bankacct").get("company");
            BigDecimal refAmt = AmtCalcHelper.getBillTransUpRefTransAmt((DynamicObject)subAcct, (Object)currency.getPkValue(), (DynamicObject)entry.getDynamicObject("transtrategy"), (long)((Long)subAcctCompany.getPkValue()));
            if (refAmt == null || refAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoRefAmtZero((BigDecimal)refAmt));
                continue;
            }
            DynamicObject line = lineUp.addNew();
            line.set("paychanel", (Object)paychanel);
            line.set("state", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
            line.set("paystatus", (Object)FcaTransPayStatusEnum.INIT.getValue());
            line.set("subacct", (Object)subAcct);
            line.set("subacct_company", (Object)subAcct.getDynamicObject("company"));
            line.set("iscashbill", (Object)"0");
            line.set("isifmbill", (Object)"0");
            line.set("isinneracccashbill", (Object)"0");
            line.set("referamt", (Object)refAmt);
            line.set("transamt", (Object)refAmt);
            line.set("inneracct", entry.get("inneracct"));
            this.fillBeBankInfo(subAcct, line);
            DynamicObject innerAcct = entry.getDynamicObject("inneracct");
            if (innerAcct != null) {
                DynamicObject bankAcctByInnerAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)innerAcct);
                line.set("inneracctbank", (Object)bankAcctByInnerAcct);
            }
            DynamicObject logEntry = this.createLogger(log, acctGroup, entry, FcaBizResource.getAutoSuccUp(), ExecstatusEnum.SUCCESS.getValue());
            logEntry.set("billno", upBill.getPkValue());
            ArrayList<DynamicObject> logEntryList = (ArrayList<DynamicObject>)logEntryMap.get((Long)upBill.getPkValue());
            if (EmptyUtil.isEmpty((Collection)logEntryList)) {
                logEntryList = new ArrayList<DynamicObject>();
                logEntryMap.put((Long)upBill.getPkValue(), logEntryList);
            }
            logEntryList.add(logEntry);
            upBill.set("amount", (Object)refAmt.add(upBill.getBigDecimal("amount")));
            upBill.set("transcount", (Object)(upBill.getInt("transcount") + 1));
        }
        this.doSaveAndCommitBei(upBill, isPay, logEntryMap);
    }

    private void doSaveAndCommitBei(final DynamicObject bill, boolean isPay, Map<Long, List<DynamicObject>> logEntryMap) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entrys");
        if (entry.isEmpty()) {
            return;
        }
        Pair<Boolean, String> pair = this.doOper("save", bill);
        if (isPay && ((Boolean)pair.getLeft()).booleanValue()) {
            pair = this.doOper("autocommitbei", bill);
            if (!((Boolean)pair.getLeft()).booleanValue()) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("byAutoTrans", "true");
                TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)bill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)create);
            } else {
                List<Long> ids = Collections.singletonList(bill.getLong("id"));
                HashMap<Long, Long> billAndMainOrgId = new HashMap<Long, Long>(){
                    {
                        this.put(bill.getLong("id"), bill.getDynamicObject("company").getLong("id"));
                    }
                };
                VoucherHelper.voucherWhiteListOpe((String)bill.getDataEntityType().getName(), (String)"audit", ids, (Map)billAndMainOrgId, (boolean)true);
            }
        }
        this.doSaveAndCommitBeiLog(logEntryMap, pair, bill);
    }

    private Pair<Boolean, String> doOper(String opName, DynamicObject bill) {
        Pair pair;
        OperateOption create = OperateOption.create();
        create.setVariableValue("byAutoTrans", "true");
        create.setVariableValue("customsign", "fca_autotrans");
        int index = 1;
        if ("save".equals(opName)) {
            DynamicObjectCollection lines = bill.getDynamicObjectCollection("entrys");
            for (DynamicObject line : lines) {
                line.set("seq", (Object)index++);
            }
        }
        try {
            OperationResult result = TmcOperateServiceHelper.execOperate((String)opName, (String)bill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)create);
            pair = Pair.of((Object)result.isSuccess(), (Object)result.getMessage());
        }
        catch (Exception e) {
            logger.error("doOper opName:{}, entityName:{}, entity:{} error:", new Object[]{opName, bill.getDataEntityType().getName(), bill.getPkValue()});
            logger.error("error:", (Throwable)e);
            pair = Pair.of((Object)Boolean.FALSE, (Object)e.getMessage());
        }
        return pair;
    }

    private void doSaveAndCommitBeiLog(Map<Long, List<DynamicObject>> logEntryMap, Pair<Boolean, String> result, DynamicObject transBill) {
        List<DynamicObject> logEntryList = logEntryMap.get((Long)transBill.getPkValue());
        if (EmptyUtil.isEmpty(logEntryList)) {
            return;
        }
        if (((Boolean)result.getLeft()).booleanValue()) {
            for (DynamicObject logEntry : logEntryList) {
                logEntry.set("billno", transBill.get("billno"));
            }
        } else {
            for (DynamicObject logEntry : logEntryList) {
                String msg = (String)result.getRight();
                if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 400) {
                    msg = msg.substring(0, 400);
                }
                logEntry.set("detail", (Object)String.format(FcaBizResource.getAutoNoGen(), msg));
                logEntry.set("status", (Object)ExecstatusEnum.FAIL.getValue());
                logEntry.set("billno", null);
            }
        }
    }
}

