/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.opservice.transbill.observer.BillPayObserver;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.helper.TransBillPushHelper;
import kd.tmc.fca.common.property.DetailStatus;

public class TransBillPayService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(TransBillPayService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        selector.add("entrymatchflag");
        selector.add("bankcheckflag");
        selector.add("paydate");
        selector.add("submitpaytime");
        selector.add("sourcebillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("TransBillPayService process begin");
        String payDateStr = (String)this.getOperationVariable().get("paydate");
        Date payDate = null;
        Date systemTime = new Date();
        if (StringUtils.isNotBlank((CharSequence)payDateStr)) {
            payDate = DateUtils.stringToDate((String)payDateStr, (String)"yyyyMMdd");
        }
        Set detailIds = Arrays.stream(dataEntities).filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("sourcebillid")) && (FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(d.getString("sourcetype")) || FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(d.getString("sourcetype")))).map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        Map<Object, Object> detailMap = new HashMap(detailIds.size());
        if (!detailIds.isEmpty()) {
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id, biztime, bizdate", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            detailMap = details.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (e1, e2) -> e1));
        }
        LOGGER.info("detailMap : {}", detailMap);
        HashMap<String, DetailStatus> payDetailMap = new HashMap<String, DetailStatus>(16);
        for (DynamicObject data : dataEntities) {
            String sourceType = data.getString("sourcetype");
            Long sourceId = data.getLong("sourcebillid");
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                Object state = entry.get("state");
                Object payStatus = entry.get("paystatus");
                Date actualPayDate = payDate;
                Date actualSubmitPayTime = systemTime;
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) {
                    payDetailMap.put(String.valueOf(entry.getPkValue()), new DetailStatus(Boolean.TRUE.booleanValue(), entry.getString("discard_reason"), entry.getDynamicObject("discard_user"), entry.getDate("discard_time"), entry.getString("payreturninfo")));
                    continue;
                }
                if (!FcaTransDetailStatusEnum.NORMAL.getValue().equals(state) || FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) || FcaTransPayStatusEnum.BEIPROC.getValue().equals(payStatus)) continue;
                Long currentUserId = RequestContext.get().getCurrUserId();
                DetailStatus ds = new DetailStatus(FcaTransPayStatusEnum.PAYSUCCESS.getValue(), currentUserId);
                if (EmptyUtil.isNoEmpty((Long)sourceId) && (FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(sourceType))) {
                    DynamicObject detail = (DynamicObject)detailMap.get(sourceId);
                    actualPayDate = detail != null && detail.getDate("bizdate") != null ? detail.getDate("bizdate") : DateUtils.stringToDate((String)DateUtils.formatString((Date)systemTime, (String)"yyyyMMdd"), (String)"yyyyMMdd");
                    if (detail != null && detail.getDate("biztime") != null) {
                        actualSubmitPayTime = detail.getDate("biztime");
                    }
                } else if (payDate == null) {
                    actualPayDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)systemTime, (String)"yyyyMMdd"), (String)"yyyyMMdd");
                }
                if (!"0".equals(entry.getString("entrymatchflag"))) {
                    ds.setBankcheckflag(entry.getString("bankcheckflag"));
                }
                ds.setPayDate(actualPayDate);
                ds.setSubmitPayTime(actualSubmitPayTime);
                payDetailMap.put(String.valueOf(entry.getPkValue()), ds);
            }
            LOGGER.info("payDetailMap\uff1a{}", payDetailMap);
        }
        BillSyncInfoObservable billPayObservable = new BillSyncInfoObservable(Arrays.asList(dataEntities), payDetailMap);
        billPayObservable.addObserver(new BillPayObserver());
        billPayObservable.syncInfo();
    }
}

