/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.helper.TransBillHelper;

public class TransBillSubmitService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(TransBillSubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("sourcetype");
        selector.add("inneracctbank");
        selector.add("subacct");
        selector.add("transamt");
        selector.add("amount");
        selector.add("matchamount");
        selector.add("unmatchamount");
        selector.add("matchflag");
        selector.add("entrymatchamount");
        selector.add("entryunmatchamount");
        selector.add("entrymatchflag");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("TransBillSubmitService begin");
        List list = Arrays.stream(dataEntities).map(d -> d.getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> d.getDynamicObject("inneracctbank") == null && d.getDynamicObject("subacct") != null)).collect(Collectors.toList());
        Map orgInnerAccountMap = new HashMap(0);
        Map innerAcctMap = new HashMap(0);
        if (!list.isEmpty()) {
            Set bankAccountIds = list.stream().map(r -> r.getDynamicObject("subacct").getPkValue()).collect(Collectors.toSet());
            orgInnerAccountMap = TransBillHelper.getInnerAccount(bankAccountIds);
            HashSet innerAccounts = new HashSet(16);
            for (Map map : orgInnerAccountMap.values()) {
                map.forEach((k, v) -> innerAccounts.add(v));
            }
            innerAcctMap = TransBillHelper.getBankAcctByInnerAcct(innerAccounts);
        }
        for (DynamicObject transBill : dataEntities) {
            String source = transBill.getString("sourcetype");
            BigDecimal payAmount = transBill.getBigDecimal("amount");
            if (FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(source) || FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(source)) {
                transBill.set("matchamount", (Object)payAmount);
                transBill.set("unmatchamount", (Object)BigDecimal.ZERO);
                transBill.set("matchflag", (Object)"1");
            } else if (StringUtils.isBlank((CharSequence)transBill.getString("matchflag")) || "0".equals(transBill.getString("matchflag"))) {
                transBill.set("matchamount", (Object)BigDecimal.ZERO);
                transBill.set("unmatchamount", (Object)payAmount);
                transBill.set("matchflag", (Object)"0");
            }
            DynamicObject company = transBill.getDynamicObject("company");
            DynamicObject currency = transBill.getDynamicObject("currency");
            DynamicObjectCollection details = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject detail : details) {
                DynamicObjectCollection currencies;
                List currencyIdList;
                DynamicObject subAccount;
                BigDecimal transAmount = detail.getBigDecimal("transamt");
                if (FcaTransSourceTypeEnum.PAYPASSIVE.getValue().equals(source) || FcaTransSourceTypeEnum.RECINITIATIVE.getValue().equals(source)) {
                    detail.set("entrymatchamount", (Object)transAmount);
                    detail.set("entryunmatchamount", (Object)BigDecimal.ZERO);
                    detail.set("entrymatchflag", (Object)"1");
                } else if (detail.getString("entrymatchflag") == null || detail.getString("entrymatchflag").trim().length() < 1 || "0".equals(detail.getString("entrymatchflag"))) {
                    detail.set("entrymatchamount", (Object)BigDecimal.ZERO);
                    detail.set("entryunmatchamount", (Object)transAmount);
                    detail.set("entrymatchflag", (Object)"0");
                }
                if (company == null || currency == null || !orgInnerAccountMap.containsKey(company.getPkValue()) || (subAccount = detail.getDynamicObject("subacct")) == null || detail.get("inneracctbank") != null) continue;
                DynamicObject innerAccount = (DynamicObject)((Map)orgInnerAccountMap.get(company.getPkValue())).get(subAccount.getPkValue());
                if (innerAccount != null && !(currencyIdList = (currencies = innerAccount.getDynamicObjectCollection("currency")).stream().map(c -> c.get("fbasedataid_id")).collect(Collectors.toList())).contains(currency.getPkValue())) {
                    innerAccount = null;
                }
                if (innerAccount == null || innerAcctMap == null) continue;
                detail.set("inneracctbank", innerAcctMap.get(innerAccount.getPkValue()));
            }
            BigDecimal amount = details.stream().filter(Objects::nonNull).map(o -> o.getBigDecimal("transamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            transBill.set("amount", (Object)amount);
        }
        LOGGER.info("TransBillSubmitService end");
    }
}

