/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillUnAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransBillUnAuditService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List pks = Arrays.stream(dataEntities).map(d -> d.getString("id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pks)) {
            try {
                String tableName = dataEntities[0].getDynamicObjectType().getAlias();
                String sql = "update " + tableName + " set fbillstatus = ? where fid in (" + String.join((CharSequence)",", pks) + ") and fbillstatus = ?";
                int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.AUDIT.getValue()}));
                if (result.length < 1 || result[0] != pks.size()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"TransBillUnAuditService_10", (String)"tmc-fca-business", (Object[])new Object[0]));
                }
            }
            catch (Exception e1) {
                logger.error("TransBillUnAuditService error", (Throwable)e1);
                throw e1;
            }
        }
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String state = entry.getString("state");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) continue;
                entry.set("paystatus", (Object)FcaTransPayStatusEnum.INIT.getValue());
                entry.set("state", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
            }
        }
    }
}

