/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.observer;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.botp.BFTrackerServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.property.DetailStatus;

public class BillSyncInfoObservable
extends Observable {
    private static final Log LOGGER = LogFactory.getLog(BillSyncInfoObservable.class);
    private List<DynamicObject> billList;
    private final Map<String, DetailStatus> payDetailMap;
    private static final String WRITE_BACK_MUTEX_KEY = "writeback";

    public BillSyncInfoObservable(List<DynamicObject> billList, Map<String, DetailStatus> payDetailMap) {
        this.billList = billList;
        this.payDetailMap = payDetailMap;
    }

    public void syncInfo() {
        if (this.billList == null || this.billList.isEmpty()) {
            return;
        }
        LOGGER.info("BillSyncInfoObservable syncInfo begin");
        String entityKey = this.billList.get(0).getDataEntityType().getName();
        for (DynamicObject bill : this.billList) {
            BillSyncInfoObservable.transBillChangeCoreLogic(bill, this.payDetailMap);
        }
        SaveServiceHelper.save((DynamicObject[])this.billList.toArray(new DynamicObject[0]));
        Object[] billIds = (Long[])this.billList.stream().filter(b -> !FcaTransSourceTypeEnum.MANUAL.getValue().equals(b.getString("sourcetype")) || !FcaTransSourceTypeEnum.AUTOTRAN.getValue().equals(b.getString("sourcetype"))).map(b -> b.getLong("id")).toArray(Long[]::new);
        if (billIds.length > 0) {
            LOGGER.info("BillSyncInfoObservable syncInfo backWriting begin");
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityKey));
            if (bills.length > 0) {
                BFTrackerServiceImpl bfTrackerService = new BFTrackerServiceImpl();
                bfTrackerService.invokeWriteBack("save", entityKey, bills);
                Map sourceBillsMap = BFTrackerServiceHelper.findSourceBills((String)entityKey, (Long[])billIds);
                ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(bills.length);
                for (Map.Entry entry : sourceBillsMap.entrySet()) {
                    for (Long id : (HashSet)entry.getValue()) {
                        String billId = String.valueOf(id);
                        Map<String, Object> requireParam = this.createDataMutexParam(billId, (String)entry.getKey());
                        mutexRequireList.add(requireParam);
                    }
                }
                try (DataMutex dataMutex = DataMutex.create();){
                    dataMutex.batchRelease(mutexRequireList);
                }
                catch (IOException e) {
                    LOGGER.error("\u91ca\u653e\u53cd\u5199\u7f51\u63a7\u5f02\u5e38\uff1a", (Throwable)e);
                }
                LOGGER.info("BillSyncInfoObservable syncInfo backWriting end");
            }
        }
        this.setChanged();
        this.notifyObservers(this.billList);
        LOGGER.info("BillSyncInfoObservable syncInfo end");
    }

    public List<DynamicObject> getBillList() {
        return this.billList;
    }

    public void setBillList(List<DynamicObject> billList) {
        this.billList = billList;
    }

    private static void transBillChangeCoreLogic(DynamicObject tranBill, Map<String, DetailStatus> payDetailMap) {
        LOGGER.info("transBillChangeCoreLogic begin");
        LOGGER.info("payDetailMap:{}", payDetailMap);
        BillSyncInfoObservable.doDetailProperties(tranBill, payDetailMap);
        BillSyncInfoObservable.doMainProperties(tranBill);
        LOGGER.info("transBillChangeCoreLogic  end");
    }

    private static void doDetailProperties(DynamicObject tranBill, Map<String, DetailStatus> payDetailMap) {
        Date currDate = new Date();
        DynamicObjectCollection entries = tranBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entries) {
            DetailStatus ds = payDetailMap.get(String.valueOf(entry.getPkValue()));
            String state = entry.get("state").toString();
            String payState = entry.get("paystatus").toString();
            if (ds == null || ds.getIsDiscard() && FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payState) && payState.equals(ds.getPayStatus())) continue;
            if (ds.getIsDiscard()) {
                entry.set("state", (Object)FcaTransDetailStatusEnum.DISCARD.getValue());
                entry.set("discard_reason", (Object)ds.getDiscardReason());
                entry.set("discard_user", (Object)ds.getDiscardUser());
                entry.set("discard_time", (Object)ds.getDiscardTime());
                entry.set("discard_time_str", (Object)DateUtils.formatString((Date)ds.getDiscardTime(), (String)"yyyyMMdd"));
            } else {
                if (FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(ds.getPayStatus())) {
                    if (EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("payuser"))) {
                        Long currentUserId = RequestContext.get().getCurrUserId();
                        DynamicObject curUser = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user");
                        entry.set("payuser", (Object)curUser);
                    }
                    Date payDate = ds.getPayDate() == null ? currDate : ds.getPayDate();
                    entry.set("paydate", (Object)payDate);
                    entry.set("bankcheckflag", (Object)ds.getBankcheckflag());
                } else {
                    entry.set("paydate", null);
                }
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(ds.getPayStatus()) && !FcaTransPayStatusEnum.PAYFAIL.getValue().equals(ds.getPayStatus()) && (FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payState) || FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payState))) {
                    entry.set("submitpaytime", null);
                } else if (ds.getSubmitPayTime() != null) {
                    entry.set("submitpaytime", (Object)ds.getSubmitPayTime());
                }
                entry.set("paystatus", (Object)ds.getPayStatus());
                if (!EmptyUtil.isEmpty((String)ds.getDetailStatus())) {
                    entry.set("state", (Object)ds.getDetailStatus());
                }
            }
            entry.set("payreturninfo", (Object)ds.getPayReturninfo());
            if (EmptyUtil.isEmpty((String)ds.getPayReturninfo())) continue;
            entry.set("payreturntime", (Object)currDate);
        }
    }

    private static void doMainProperties(DynamicObject tranBill) {
        boolean allPaySuccess = true;
        DynamicObjectCollection entries = tranBill.getDynamicObjectCollection("entrys");
        int transSuccessCount = 0;
        BigDecimal transSuccessAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            String payStatus = entry.getString("paystatus");
            String state = entry.getString("state");
            if (FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) && !FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) {
                ++transSuccessCount;
                transSuccessAmt = transSuccessAmt.add(entry.getBigDecimal("transamt"));
            }
            if (FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) || FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) continue;
            allPaySuccess = false;
        }
        if (allPaySuccess && transSuccessCount > 0) {
            tranBill.set("billstatus", (Object)BillStatusEnum.PAYED.getValue());
        } else {
            boolean isBei = entries.stream().anyMatch(e -> !FcaTransDetailStatusEnum.DISCARD.getValue().equals(e.getString("state")) && FcaTransPayChanEnum.BEI.getValue().equals(e.getString("paychanel")));
            if (isBei && !BillStatusEnum.AUDIT.getValue().equals(tranBill.get("billstatus"))) {
                tranBill.set("billstatus", (Object)BillStatusEnum.PAYING.getValue());
            } else {
                tranBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            }
        }
        tranBill.set("transsuccount", (Object)transSuccessCount);
        tranBill.set("transsucamt", (Object)transSuccessAmt);
    }

    private Map<String, Object> createDataMutexParam(String billId, String entityKey) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
        requireParam.put("dataObjId", billId);
        requireParam.put("groupId", WRITE_BACK_MUTEX_KEY);
        requireParam.put("entityKey", entityKey);
        requireParam.put("operationKey", WRITE_BACK_MUTEX_KEY);
        requireParam.put("isStrict", true);
        requireParam.put("isOpenIntentLocks", false);
        return requireParam;
    }
}

