/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import org.apache.commons.lang3.tuple.Pair;

public class LockService {
    private static final Log LOGGER = LogFactory.getLog(LockService.class);
    private boolean isInterrupt = true;
    private static final int MUTEX_TRY_AGAIN = 600;
    private static final int SLEEP_MS = 100;

    public LockService() {
    }

    public LockService(boolean isInterrupt) {
        this.isInterrupt = isInterrupt;
    }

    public Set<String> startNetworkCtrl(Set<String> srcBillIds, String entityKey, String branchCode, String branchCodeName) {
        if (srcBillIds.isEmpty()) {
            LOGGER.info("return, srcBillIds.isEmpty");
            return new HashSet<String>();
        }
        return this.doStartNetworkCtrlAgain(srcBillIds, entityKey, branchCode, branchCodeName);
    }

    private Pair<Set<String>, Set<String>> doStartNetworkCtrl(Set<String> srcBillIds, String entityKey, String branchCode) throws KDBizException {
        if (srcBillIds.isEmpty()) {
            return Pair.of(new HashSet(0), new HashSet(0));
        }
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(srcBillIds.size());
        HashSet<String> failIds = new HashSet<String>(1);
        HashSet<String> successIds = new HashSet<String>(srcBillIds.size());
        for (String objId : srcBillIds) {
            Map<String, Object> requireParam = this.createDataMutexParam(objId, entityKey, branchCode);
            mutexRequireList.add(requireParam);
        }
        try (TXHandle h = TX.notSupported();){
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    boolean ret = (Boolean)mutexItem.getValue();
                    if (ret) {
                        successIds.add(objId);
                        continue;
                    }
                    failIds.add(objId);
                }
            }
            catch (IOException e) {
                LOGGER.error("dataMutex batchRequire error\uff1a", (Throwable)e);
                if (this.isInterrupt) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;error:%1$s", (String)"SyncTxService_0", (String)"tmc-fca-business", (Object[])new Object[0]), e.getMessage()));
                }
            }
        }
        return Pair.of(successIds, failIds);
    }

    private Set<String> doStartNetworkCtrlAgain(Set<String> srcBillIds, String entityKey, String branchCode, String branchCodeName) {
        HashSet<String> successIds = new HashSet<String>(srcBillIds.size());
        int tryAgain = 1;
        while (!srcBillIds.isEmpty() && tryAgain++ < 600) {
            try {
                Pair<Set<String>, Set<String>> result = this.doStartNetworkCtrl(srcBillIds, entityKey, branchCode);
                if (!((Set)result.getLeft()).isEmpty()) {
                    successIds.addAll((Collection)result.getLeft());
                }
                if (!((Set)result.getRight()).isEmpty() && tryAgain + 1 > 600) {
                    LOGGER.info("branchCode:{},mutex successIds:{}", (Object)branchCode, successIds);
                    LOGGER.info("branchCode:{},mutex failIds:{}", (Object)branchCode, result.getRight());
                    if (this.isInterrupt) {
                        if (!successIds.isEmpty()) {
                            this.releaseDataMutex(successIds, entityKey, branchCode);
                        }
                        String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u3010%1$s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SyncTxService_1", (String)"tmc-fca-business", (Object[])new Object[0]), branchCodeName);
                        throw new KDBizException(msg);
                    }
                }
                if ((srcBillIds = (Set)result.getRight()).isEmpty()) continue;
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("sleep error", (Throwable)e);
            }
            catch (KDBizException e) {
                if (!successIds.isEmpty()) {
                    this.releaseDataMutex(successIds, entityKey, branchCode);
                }
                throw e;
            }
        }
        return successIds;
    }

    private Map<String, Object> createDataMutexParam(String billId, String entityKey, String branchCode) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
        requireParam.put("dataObjId", billId);
        requireParam.put("groupId", branchCode);
        requireParam.put("entityKey", entityKey);
        requireParam.put("operationKey", branchCode);
        requireParam.put("isStrict", true);
        requireParam.put("isOpenIntentLocks", false);
        return requireParam;
    }

    public void releaseDataMutex(Set<String> srcBillIds, String entityKey, String branchCode) {
        if (srcBillIds.isEmpty()) {
            LOGGER.info("return, srcBillIds.isEmpty");
            return;
        }
        this.doReleaseDataMutex(srcBillIds, entityKey, branchCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReleaseDataMutex(Set<String> srcBillIds, String entityKey, String branchCode) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(srcBillIds.size());
        for (String objId : srcBillIds) {
            Map<String, Object> requireParam = this.createDataMutexParam(objId, entityKey, branchCode);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
        }
        catch (IOException e) {
            LOGGER.error("doReleaseDataMutex error\uff1a", (Throwable)e);
        }
        finally {
            srcBillIds.clear();
        }
    }
}

