/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPayBookJournalBuilder;

public class BookJournalBranchService
implements Branch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(BookJournalBranchService.class);

    @Override
    public void operation(List<DynamicObject> billList, String scenesCode) {
        LOGGER.info("BookJournalBranchService operation begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        HashSet<Object> pkIdList = new HashSet<Object>(10);
        ArrayList<DynamicObject> needBookList = new ArrayList<DynamicObject>(10);
        HashSet<String> pkIdStringList = new HashSet<String>(10);
        for (DynamicObject transBill : billList) {
            if (TransBillHelper.isInnerAcctTrans((DynamicObject)transBill)) continue;
            pkIdList.add(transBill.getPkValue());
            pkIdStringList.add(String.valueOf(transBill.getPkValue()));
            needBookList.add(transBill);
        }
        List paySuccessInfos = TransBillPayBookJournalBuilder.doJournalInfoList(needBookList);
        if (!EmptyUtil.isEmpty((Collection)paySuccessInfos)) {
            String entityName = billList.get(0).getDataEntityType().getName();
            List pairList = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"validateBook", (Object[])new String[]{SerializationUtils.toJsonString((Object)paySuccessInfos)});
            if (pairList != null && !pairList.isEmpty()) {
                StringBuilder validateMessage = new StringBuilder();
                pairList.forEach(e -> validateMessage.append((String)e.getRight()).append("\n"));
                LOGGER.warn("\u767b\u8d26\u6821\u9a8c\u5f02\u5e38\uff1a{}", (Object)validateMessage.toString());
            }
            SyncParam syncParam = new SyncParam(new ArrayList<Object>(pkIdList), entityName, paySuccessInfos, this.getBranchCodeEnum());
            if (StringUtils.isNotBlank((CharSequence)scenesCode)) {
                ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"transfer_sync");
                ECGlobalSession.setAsync((boolean)true);
                ECGlobalSession.setBusinessInfo(new ArrayList(pkIdStringList));
                ECGlobalSession.register((String)"tmc", (String)"fca", (String)"syncTxService", (Param)syncParam, (String)this.getBranchCodeEnum().getValue(), new ArrayList(pkIdStringList));
            } else {
                try {
                    LOGGER.info("BookJournalBranchService operation SyncParam:{}", (Object)syncParam.toString());
                    this.transactionInvoke(syncParam);
                }
                catch (Exception e2) {
                    throw new KDBizException(e2.getMessage());
                }
            }
        }
        LOGGER.info("BookJournalBranchService operation end");
    }

    @Override
    public void transactionInvoke(Param param) {
        SyncParam p = (SyncParam)param;
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"book", (Object[])new String[]{SerializationUtils.toJsonString(p.getJournalInfoList())});
    }

    @Override
    public void callBack(Param param) {
    }

    @Override
    public BranchCodeEnum getBranchCodeEnum() {
        return BranchCodeEnum.BOOK_JOURNAL;
    }
}

