/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class DeleteIfmBranchService
implements Branch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(DeleteIfmBranchService.class);

    @Override
    public void operation(List<DynamicObject> billList, String scenesCode) {
        String targetEntityName;
        DynamicObjectCollection ifmBills;
        List<Object> toBeCancelIfmBillIds;
        LOGGER.info("DeleteIfmBranchService operation begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        HashSet<Object> pkIdList = new HashSet<Object>(10);
        HashSet<String> pkIdStringList = new HashSet<String>(10);
        ArrayList<Object> cancelledEntryIds = new ArrayList<Object>(5);
        String entityName = billList.get(0).getDataEntityType().getName();
        for (DynamicObject transBill : billList) {
            if (!TransBillHelper.isInnerAcctTrans((DynamicObject)transBill)) continue;
            pkIdStringList.add(String.valueOf(transBill.getLong("id")));
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String payStatus = (String)entry.get("paystatus");
                if (!FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) && !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) || !"0".equals(entry.get("isifmbill"))) continue;
                cancelledEntryIds.add(entry.getPkValue());
                pkIdList.add(transBill.getPkValue());
                pkIdStringList.add(String.valueOf(transBill.getPkValue()));
            }
        }
        if (!cancelledEntryIds.isEmpty() && !(toBeCancelIfmBillIds = (ifmBills = QueryServiceHelper.query((String)(targetEntityName = TransBillPushHelper.getIfmTargetEntityName((String)entityName)), (String)"id, sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)entityName), new QFilter("sourcebillentryid", "in", cancelledEntryIds)})).stream().map(d -> d.get("id")).distinct().collect(Collectors.toList())).isEmpty()) {
            SyncParam syncParam = new SyncParam(new ArrayList<Object>(pkIdList), cancelledEntryIds, entityName, toBeCancelIfmBillIds, targetEntityName, this.getBranchCodeEnum());
            if (StringUtils.isNotBlank((CharSequence)scenesCode)) {
                ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"transfer_sync");
                ECGlobalSession.setAsync((boolean)true);
                ECGlobalSession.setBusinessInfo(new ArrayList(pkIdStringList));
                ECGlobalSession.register((String)"tmc", (String)"fca", (String)"syncTxService", (Param)syncParam, (String)this.getBranchCodeEnum().getValue(), new ArrayList(pkIdStringList));
            } else {
                try {
                    LOGGER.info("DeleteIfmBranchService operation SyncParam:{}", (Object)syncParam.toString());
                    this.transactionInvoke(syncParam);
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        LOGGER.info("DeleteIfmBranchService operation end");
    }

    @Override
    public void transactionInvoke(Param param) {
        SyncParam p = (SyncParam)param;
        TmcOperateServiceHelper.execOperate((String)"canclepay", (String)p.getTargetEntityName(), (Object[])p.getTargetPkIdList().toArray(), (OperateOption)OperateOption.create());
    }

    @Override
    public void callBack(Param param) {
    }

    @Override
    public BranchCodeEnum getBranchCodeEnum() {
        return BranchCodeEnum.DELETE_IFM;
    }
}

