/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillHelper;

public class DeleteJournalBranchService
implements Branch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(DeleteJournalBranchService.class);

    @Override
    public void operation(List<DynamicObject> billList, String scenesCode) {
        LOGGER.info("DeleteJournalBranchService operation begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        String entityName = billList.get(0).getDataEntityType().getName();
        HashSet<Object> pkIdList = new HashSet<Object>(10);
        ArrayList<Object> pkEntryIdList = new ArrayList<Object>(10);
        for (DynamicObject bill : billList) {
            if (TransBillHelper.isInnerAcctTrans((DynamicObject)bill)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String payStatus = entry.getString("paystatus");
                if (!FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) && !FcaTransPayStatusEnum.INIT.getValue().equals(payStatus)) continue;
                pkIdList.add(bill.getPkValue());
                pkEntryIdList.add(entry.getPkValue());
            }
        }
        if (!pkIdList.isEmpty()) {
            QFilter filter = new QFilter("sourcebilltype", "=", (Object)entityName);
            filter.and("sourcebillid", "in", pkIdList);
            DynamicObjectCollection bankJournals = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebillid, sourcebillentryid", (QFilter[])filter.toArray());
            if (!bankJournals.isEmpty()) {
                Set existsEntryIdList = bankJournals.stream().filter(b -> EmptyUtil.isNoEmpty((Object)b.get("sourcebillentryid"))).map(b -> b.get("sourcebillentryid")).collect(Collectors.toSet());
                if (bankJournals.size() == existsEntryIdList.size()) {
                    pkEntryIdList.retainAll(existsEntryIdList);
                }
                Set existsIdList = bankJournals.stream().map(b -> b.get("sourcebillid")).collect(Collectors.toSet());
                pkIdList.retainAll(existsIdList);
                if (!pkIdList.isEmpty() && !pkEntryIdList.isEmpty()) {
                    List pairList = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"validateDeleteEntryJournal", (Object[])new Object[]{entityName, new ArrayList(pkIdList), pkEntryIdList});
                    if (pairList != null && !pairList.isEmpty()) {
                        StringBuilder validateMessage = new StringBuilder();
                        pairList.forEach(e -> validateMessage.append((String)e.getRight()).append("\n"));
                        throw new KDBizException(validateMessage.toString());
                    }
                    Set pkIdStringList = pkIdList.stream().map(Object::toString).collect(Collectors.toSet());
                    SyncParam syncParam = new SyncParam(new ArrayList<Object>(pkIdList), pkEntryIdList, entityName, this.getBranchCodeEnum());
                    ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                    ECGlobalSession.setBusinessType((String)"transfer_sync");
                    ECGlobalSession.setAsync((boolean)true);
                    ECGlobalSession.setBusinessInfo(new ArrayList(pkIdStringList));
                    ECGlobalSession.register((String)"tmc", (String)"fca", (String)"syncTxService", (Param)syncParam, (String)this.getBranchCodeEnum().getValue(), new ArrayList(pkIdStringList));
                }
            }
        }
        LOGGER.info("DeleteInnerCasBranchService operation end");
    }

    @Override
    public void transactionInvoke(Param param) {
        SyncParam p = (SyncParam)param;
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"cancelEntryBook", (Object[])new Object[]{p.getEntityName(), p.getPkIdList(), p.getEntryPkIdList()});
    }

    @Override
    public void callBack(Param param) {
    }

    @Override
    public BranchCodeEnum getBranchCodeEnum() {
        return BranchCodeEnum.DELETE_JOURNAL;
    }
}

