/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.opservice.transbill.tx.branch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fca.business.opservice.transbill.bean.CallbackParam;
import kd.tmc.fca.business.opservice.transbill.bean.SyncParam;
import kd.tmc.fca.business.opservice.transbill.tx.BranchCodeEnum;
import kd.tmc.fca.business.opservice.transbill.tx.CallBackService;
import kd.tmc.fca.business.opservice.transbill.tx.branch.Branch;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.FcaBotpHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class PushCasBranchService
implements Branch<List<DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(PushCasBranchService.class);

    @Override
    public void operation(List<DynamicObject> billList, String scenesCode) {
        LOGGER.info("PushCasBranchService operation begin");
        if (billList == null || billList.isEmpty()) {
            return;
        }
        HashSet<Object> pkIdList = new HashSet<Object>(10);
        HashSet<String> pkIdStringList = new HashSet<String>(10);
        ArrayList<Object> unPushedEntryIds = new ArrayList<Object>(10);
        for (DynamicObject transBill : billList) {
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                String payStatus = entry.getString("paystatus");
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus) || !"0".equals(entry.getString("iscashbill"))) continue;
                unPushedEntryIds.add(entry.getPkValue());
                pkIdList.add(transBill.getPkValue());
                pkIdStringList.add(String.valueOf(transBill.getPkValue()));
            }
        }
        if (!unPushedEntryIds.isEmpty()) {
            String entityName = billList.get(0).getDataEntityType().getName();
            String targetEntityName = TransBillPushHelper.getCasTargetEntityName((String)entityName);
            SyncParam syncParam = new SyncParam(new ArrayList<Object>(pkIdList), unPushedEntryIds, entityName, targetEntityName, this.getBranchCodeEnum());
            if (StringUtils.isNotBlank((CharSequence)scenesCode)) {
                ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"transfer_sync");
                ECGlobalSession.setAsync((boolean)true);
                ECGlobalSession.setBusinessInfo(new ArrayList(pkIdStringList));
                ECGlobalSession.register((String)"tmc", (String)"fca", (String)"syncTxService", (Param)syncParam, (String)this.getBranchCodeEnum().getValue(), new ArrayList(pkIdStringList));
                ECGlobalSession.setCallback((String)"fca", (DTXCallback)new CallBackService());
            } else {
                try {
                    LOGGER.info("PushCasBranchService operation SyncParam:{}", (Object)syncParam.toString());
                    this.transactionInvoke(syncParam);
                    this.callBack(new CallbackParam(syncParam));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        LOGGER.info("PushCasBranchService operation end");
    }

    @Override
    public void transactionInvoke(Param param) {
        DynamicObject[] targetBills;
        DynamicObject[] bills;
        SyncParam p = (SyncParam)param;
        DynamicObjectCollection casBills = QueryServiceHelper.query((String)p.getTargetEntityName(), (String)"entry.e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)p.getEntityName()), new QFilter("entry.e_sourcebillid", "in", p.getPkIdList()), new QFilter("entry.e_sourcebillentryid", "in", p.getEntryPkIdList())});
        List existsEntryPkIdList = casBills.stream().map(b -> b.get("entry.e_sourcebillentryid")).collect(Collectors.toList());
        ArrayList<Object> entryPkIdList = new ArrayList<Object>(p.getEntryPkIdList());
        entryPkIdList.removeAll(existsEntryPkIdList);
        if (!entryPkIdList.isEmpty() && (bills = BusinessDataServiceHelper.load((String)p.getEntityName(), (String)"id,entrys.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)p.getPkIdList().toArray())})).length != 0 && (targetBills = FcaBotpHelper.pushBySpecifiedEntry((DynamicObject[])bills, (String)"entrys", new HashSet<Object>(entryPkIdList), (String)p.getTargetEntityName())).length != 0) {
            if ("cas_paybill".equals(((SyncParam)param).getTargetEntityName())) {
                DynamicObject paymentIdentify = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_paymentidentify", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
                for (DynamicObject targetBill : targetBills) {
                    targetBill.set("paymentidentify", (Object)paymentIdentify);
                }
            }
            List resultBillIds = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"FundTransPushService", (String)"push", (Object[])new Object[]{targetBills});
            p.setTargetPkIdList(resultBillIds);
            LOGGER.info("pushCas result pks\uff1a{}", (Object)resultBillIds);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void callBack(Param param) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public BranchCodeEnum getBranchCodeEnum() {
        return BranchCodeEnum.PUSH_CAS;
    }

    private String getTableName(String entityName) {
        return "fca_transupbill".equals(entityName) ? "t_fca_transupbill_entry" : "t_fca_transdownbill_entry";
    }

    private static /* synthetic */ Object lambda$callBack$4(DynamicObject d) {
        return d.get("id");
    }

    private static /* synthetic */ Object lambda$callBack$3(DynamicObject d) {
        return d.get("id");
    }
}

