/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.service.task;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tmc.fca.business.opservice.applytransbill.PullPayBillService;
import kd.tmc.fca.business.service.task.BaseData;

public class PullBillTaskService
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PullBillTaskService.class);
    private static final String TARGET_ENTITY = "targetEntity";
    private static final String FCA_PULL_RULE = "fcaPullRule";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        BaseData baseData;
        LOGGER.info("PullBillTaskService begin");
        String targetEntity = null;
        Object fcaPullRule = null;
        if (map.get(TARGET_ENTITY) != null) {
            baseData = (BaseData)SerializationUtils.fromJsonString((String)map.get(TARGET_ENTITY).toString(), BaseData.class);
            if (baseData != null && baseData.getId() != null) {
                targetEntity = baseData.getId().toString();
            }
        } else {
            targetEntity = "fca_applytransdownbill";
        }
        if (map.get(FCA_PULL_RULE) != null && (baseData = (BaseData)SerializationUtils.fromJsonString((String)map.get(FCA_PULL_RULE).toString(), BaseData.class)) != null && baseData.getId() != null) {
            fcaPullRule = baseData.getId();
        }
        PullPayBillService pullPayBillService = new PullPayBillService(targetEntity, fcaPullRule);
        pullPayBillService.setOperationResult(new OperationResult());
        pullPayBillService.process(null);
        this.showMessage(pullPayBillService.getOperationResult());
        LOGGER.info("PullBillTaskService end");
    }

    private void showMessage(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            LOGGER.info(operationResult.getMessage());
        } else {
            List allErrorInfo = operationResult.getAllErrorInfo();
            ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
            String title = operationResult.getMessage();
            StringBuilder message = new StringBuilder();
            if (!allErrorInfo.isEmpty()) {
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    message.append(operateErrorInfo.getMessage()).append("\r\n");
                }
            }
            if (!validateResultCollection.getValidateErrors().isEmpty()) {
                for (ValidateResult validateResult : validateResultCollection.getValidateErrors()) {
                    message.append(ResManager.loadKDString((String)"\u5355\u636e\u4fdd\u5b58\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef\uff1a", (String)"ApplyTransBillList_8", (String)"tmc-fca-formplugin", (Object[])new Object[0])).append("\r\n");
                    for (OperateErrorInfo operateErrorInfo : validateResult.getAllErrorInfo()) {
                        message.append(operateErrorInfo.getMessage()).append("\r\n");
                    }
                }
            }
            LOGGER.warn(title);
            if (message.length() > 2) {
                LOGGER.warn(message.substring(0, message.length() - 2));
            }
        }
    }
}

