/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.acctgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.errorcode.AcctGroupErrorCode;

public class AcctGroupEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("accountbank");
        selector.add("currency");
        selector.add("company");
        selector.add("bankacct");
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        DynamicObjectCollection entries;
        Set sonBankAcctIdSet = Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("bankacct")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        Set bankAcctIdSet = Arrays.stream(extendedDataEntities).filter(o -> o.getDataEntity().getDynamicObject("accountbank") != null).map(o -> o.getDataEntity().getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        Set acctGroupIdSet = Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity().getLong("id")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        DynamicObjectCollection acctGroups = QueryServiceHelper.query((String)"fca_acctgroup", (String)"id, name, number, accountbank, currency, entrys.bankacct", (QFilter[])new QFilter[]{new QFilter("id", "not in", acctGroupIdSet).and(new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())).and(new QFilter("entrys.bankacct", "in", sonBankAcctIdSet)).and(new QFilter("accountbank", "in", bankAcctIdSet))});
        Map<String, DynamicObject> acctGroupMap = acctGroups.stream().collect(Collectors.toMap(a -> String.valueOf(a.get("accountbank")).concat("_").concat(String.valueOf(a.get("entrys.bankacct"))).concat("_").concat(String.valueOf(a.get("currency"))), a -> a, (e1, e2) -> e1));
        HashMap<String, List> acctGroupNewMap = new HashMap<String, List>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            if (data.get("accountbank") == null || data.get("currency") == null) continue;
            String accountBank = data.getDynamicObject("accountbank").getPkValue().toString();
            String currency = data.getDynamicObject("currency").getPkValue().toString();
            entries = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                if (entry.get("bankacct") == null) continue;
                String entryAcctId = entry.getDynamicObject("bankacct").getPkValue().toString();
                String key = accountBank.concat("_").concat(entryAcctId).concat("_").concat(currency);
                acctGroupNewMap.computeIfAbsent(key, k -> new ArrayList());
                acctGroupNewMap.computeIfPresent(key, (k, v) -> {
                    v.add(data);
                    return v;
                });
            }
        }
        block2: for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            AcctGroupErrorCode acctGroupErrorCode = new AcctGroupErrorCode();
            ArrayList<Object> acctList = new ArrayList<Object>();
            entries = (DynamicObjectCollection)dataEntity.get("entrys");
            if (entries.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, acctGroupErrorCode.SONENTEYS_ISNULL().getMessage());
            }
            DynamicObject bankAcct = dataEntity.getDynamicObject("accountbank");
            DynamicObject currency = dataEntity.getDynamicObject("currency");
            DynamicObject company = dataEntity.getDynamicObject("company");
            DynamicObject momCompany = bankAcct.getDynamicObject("company");
            if (!momCompany.getPkValue().equals(company.getPkValue())) {
                this.addErrorMessage(extendedDataEntity, acctGroupErrorCode.COMPANY_ISDIFF().getMessage());
            }
            for (DynamicObject entry : entries) {
                List acctGroupList;
                DynamicObject sonBankAcct = entry.getDynamicObject("bankacct");
                if (sonBankAcct == null) {
                    this.addErrorMessage(extendedDataEntity, acctGroupErrorCode.SONACCT_ISNULL().getMessage());
                    continue;
                }
                Object entrysAcctId = sonBankAcct.getPkValue();
                String bankaccountnumber = sonBankAcct.get("bankaccountnumber").toString();
                if (acctList.contains(entrysAcctId)) {
                    this.addErrorMessage(extendedDataEntity, acctGroupErrorCode.SONACCT_ISNULL().getMessage());
                    this.addErrorMessage(extendedDataEntity, String.format(acctGroupErrorCode.SONACCT_ISREPEAT().getMessage(), bankaccountnumber));
                    continue block2;
                }
                acctList.add(entrysAcctId);
                String key = String.valueOf(bankAcct.getPkValue()).concat("_").concat(String.valueOf(entrysAcctId)).concat("_").concat(String.valueOf(currency.getPkValue()));
                if (acctGroupMap.containsKey(key)) {
                    DynamicObject accountGroup = acctGroupMap.get(key);
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\uff1a%1$s \u5e01\u79cd\uff1a%2$s\uff0c\u5df2\u88ab\u6307\u5b9a\u4e3a\u6bcd\u5b50\u8d26\u6237\u7ec4%3$s\uff08\u7f16\u53f7\uff1a%4$s\uff09\u7684\u5b50\u8d26\u6237\uff0c\u4e0d\u80fd\u91cd\u590d\u6307\u5b9a\u3002", (String)"AcctGroupErrorCode_3", (String)"tmc-fca-common", (Object[])new Object[0]), bankaccountnumber, currency.getString("name"), accountGroup.getString("name"), accountGroup.getString("number")));
                }
                if (!acctGroupNewMap.containsKey(key) || (acctGroupList = (List)acctGroupNewMap.get(key)).size() <= 1) continue;
                List list = acctGroupList.stream().filter(a -> a.getLong("id") != dataEntity.getLong("id")).collect(Collectors.toList());
                for (DynamicObject accountGroup : list) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\uff1a%1$s \u5e01\u79cd\uff1a%2$s\uff0c\u5df2\u88ab\u6307\u5b9a\u4e3a\u6bcd\u5b50\u8d26\u6237\u7ec4%3$s\uff08\u7f16\u53f7\uff1a%4$s\uff09\u7684\u5b50\u8d26\u6237\uff0c\u4e0d\u80fd\u91cd\u590d\u6307\u5b9a\u3002", (String)"AcctGroupErrorCode_3", (String)"tmc-fca-common", (Object[])new Object[0]), bankaccountnumber, currency.getString("name"), accountGroup.getString("name"), accountGroup.getString("number")));
                }
            }
        }
    }
}

