/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.applytransbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;

public class ApplyTransBillAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applyamt");
        selector.add("currency");
        selector.add("transamt");
        selector.add("subacct");
        selector.add("pbankacct");
        selector.add("inneracct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject applyTransBill = data.getDataEntity();
            DynamicObjectCollection entries = applyTransBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                DynamicObject pAccount = entry.getDynamicObject("pbankacct");
                DynamicObject subAccount = entry.getDynamicObject("subacct");
                this.validateAccountStatus(data, pAccount, subAccount);
            }
        }
    }

    public void validateAccountStatus(ExtendedDataEntity data, DynamicObject pAccount, DynamicObject subAccount) {
        String entityName = data.getDataEntity().getDataEntityType().getName();
        if (pAccount != null) {
            String pAccountStatus = pAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_23", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransdownbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_24", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
        }
        if (subAccount != null) {
            String subAccountStatus = subAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_25", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_applytransupbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_26", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
        }
    }
}

