/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.autotrans;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class AutoTransCommonValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List autoTransIds = Arrays.stream(dataEntity).map(v -> {
            DynamicObject autoTrans = v.getDataEntity();
            return Long.valueOf(autoTrans.getString("id"));
        }).collect(Collectors.toList());
        DynamicObject[] intellExces = TmcDataServiceHelper.load((String)"gl_intellexecschema", (String)"id,sheduleplanid,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", autoTransIds)});
        Map<String, DynamicObject> intellExcesIndexMap = Stream.of(intellExces).collect(Collectors.toMap(v -> v.getString("id"), p -> p));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject autoTrans = extendedDataEntity.getDataEntity();
            DynamicObject operateIntellExces = intellExcesIndexMap.getOrDefault(autoTrans.getString("id"), null);
            if (null != operateIntellExces) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5bf9\u5e94\u7684\u667a\u80fd\u6267\u884c\u65b9\u6848\u5df2\u88ab\u5220\u9664\u3002", (String)"AutoTransCommonValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }
}

