/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.SystemParameterHelper;
import kd.tmc.fca.common.helper.TransBillHelper;

public class TransBillBeiCancelPayValidator
extends AbstractTmcBizOppValidator {
    static final Log logger = LogFactory.getLog(TransBillBeiCancelPayValidator.class);
    private static final String SYSTEM_TYPE = "tmc-fca-business";
    private static final String IFM_RECTRANSBILL = "ifm_rectransbill";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("iscashbill");
        selector.add("isifmbill");
        selector.add("isinneracccashbill");
        selector.add("paystatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity dataEntity;
        DynamicObject info;
        String name;
        ExtendedDataEntity[] extendedDataEntityArray = extendedDataEntities;
        int n = extendedDataEntityArray.length;
        for (int i = 0; i < n && ("fca_transupbill".equals(name = (info = (dataEntity = extendedDataEntityArray[i]).getDataEntity()).getDataEntityType().getName()) || "fca_transdownbill".equals(name)); ++i) {
            HashSet ifmRecIds;
            DynamicObjectCollection entries = info.getDynamicObjectCollection("entrys");
            int index = 0;
            for (DynamicObject entry : entries) {
                if (!this.isMismatch(entry)) continue;
                ++index;
            }
            if (index == entries.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u53d6\u6d88\u4ed8\u6b3e\u660e\u7ec6\u3002", (String)"TransBillCancelPayService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            this.checkIsPush(dataEntity);
            HashSet<String> bills = new HashSet<String>(4);
            bills.add("cas_paybill");
            bills.add("ifm_transhandlebill");
            bills.add("cas_recbill");
            bills.add(IFM_RECTRANSBILL);
            Map<String, HashSet<Long>> targetBills = BFTrackerServiceHelper.findTargetBills((String)name, (Long[])new Long[]{info.getLong("id")});
            logger.info("targetBills:{}", (Object)JSON.toJSONString((Object)targetBills));
            targetBills = targetBills.entrySet().stream().filter(e -> bills.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            logger.info("targetBills filter:{}", (Object)JSON.toJSONString(targetBills));
            for (Map.Entry<String, HashSet> entry : targetBills.entrySet()) {
                QFilter filter = new QFilter("sourcebillid", "in", (Object)entry.getValue());
                filter.and("billtype", "=", (Object)entry.getKey());
                DynamicObjectCollection vouchersDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{filter});
                if (vouchersDaps.isEmpty()) continue;
                for (DynamicObject obj : vouchersDaps) {
                    QFilter covFilter = new QFilter("id", "=", (Object)Long.valueOf(obj.getString("voucherid")));
                    DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebill,billno,sourcebilltype", (QFilter[])new QFilter[]{covFilter});
                    if (vouchers.isEmpty()) continue;
                    this.addErrorMessage(dataEntity, name, entry.getKey(), obj.getLong("sourcebillid"));
                }
            }
            HashSet ifmIds = targetBills.get("ifm_transhandlebill");
            if (ifmIds != null && !ifmIds.isEmpty()) {
                OperationResult ifmResult;
                Set<Long> ids = TransBillBeiCancelPayValidator.checkTransDetailRef("ifm_transhandlebill", new ArrayList<Long>(ifmIds));
                if (ids != null && !ids.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u660e\u7ec6\u5df2\u4e0b\u8f7d\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if ((ifmResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"validatecancel", (String)"ifm_transhandlebill", (Object[])ifmIds.toArray(), (OperateOption)OperateOption.create())).getAllErrorInfo().size() != 0) {
                    this.addErrorMessage(dataEntity, ifmResult.getMessage());
                }
            }
            if ((ifmRecIds = targetBills.get(IFM_RECTRANSBILL)) != null && !ifmRecIds.isEmpty()) {
                OperationResult ifmResult;
                Set<Long> refIds = TransBillBeiCancelPayValidator.checkTransDetailRef(IFM_RECTRANSBILL, new ArrayList<Long>(ifmRecIds));
                if (refIds != null && !refIds.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4ea4\u6613\u660e\u7ec6\u5df2\u4e0b\u8f7d\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if ((ifmResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"validatecancel", (String)IFM_RECTRANSBILL, (Object[])ifmRecIds.toArray(), (OperateOption)OperateOption.create())).getAllErrorInfo().size() != 0) {
                    this.addErrorMessage(dataEntity, ifmResult.getMessage());
                }
            }
            this.checkBook(dataEntity, targetBills);
        }
    }

    private boolean checkUnKnow(DynamicObject entry) {
        String payStatus = entry.getString("paystatus");
        return !FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus);
    }

    private void checkBook(ExtendedDataEntity dataEntity, Map<String, HashSet<Long>> targetBills) {
        List pairList;
        HashMap<String, Collection<Long>> map = new HashMap<String, Collection<Long>>(8);
        map.put(dataEntity.getDataEntity().getDataEntityType().getName(), Collections.singletonList(dataEntity.getDataEntity().getLong("id")));
        if (!targetBills.isEmpty()) {
            for (Map.Entry<String, HashSet<Long>> entry : targetBills.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        if ((pairList = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"tmcbookservice", (String)"validateBeforeCancel", (Object[])new Object[]{map})) != null && pairList.size() > 0) {
            pairList.forEach(e -> this.addErrorMessage(dataEntity, (String)e.getRight()));
        }
    }

    private void addErrorMessage(ExtendedDataEntity dataEntity, String name, String key, Long id) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)key, (String)"billno");
        String billNo = entity.getString("billno");
        if ("fca_transupbill".equals(name)) {
            switch (key) {
                case "cas_paybill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u4ed8\u6b3e\u56de\u5355\u3010%s\u3011\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
                case "cas_recbill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u6536\u6b3e\u56de\u5355\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
                case "ifm_rectransbill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u53f7\u5173\u8054\u7684\u5185\u90e8\u91d1\u878d\u6536\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3010%s\u3011\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
            }
        } else if ("fca_transdownbill".equals(name)) {
            switch (key) {
                case "cas_recbill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u6536\u6b3e\u56de\u5355\u201c%s\u201d\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
                case "cas_paybill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u53f7\u5bf9\u5e94\u7684\u4ed8\u6b3e\u56de\u5355\u3010%s\u3011\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
                case "ifm_transhandlebill": {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u53f7\u5173\u8054\u7684\u5185\u90e8\u91d1\u878d\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3010%s\u3011\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u64cd\u4f5c\u3002", (String)"TransBillCancelPayValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), billNo));
                    break;
                }
            }
        }
    }

    private boolean isMismatch(DynamicObject entry) {
        String state = entry.getString("state");
        String payStatus = entry.getString("paystatus");
        return FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || !FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus);
    }

    public static Set<Long> checkTransDetailRef(String srcType, List<Long> ids) {
        QFilter transFilter = new QFilter("sourcebillid", "in", ids);
        transFilter.and("sourcebilltype", "=", (Object)srcType);
        DynamicObject[] transDynColls = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,receredtype,sourcebillid, isdowntobankstate", (QFilter[])new QFilter[]{transFilter});
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        for (DynamicObject transDynColl : transDynColls) {
            if (!transDynColl.getBoolean("isdowntobankstate") && !ReceredtypeEnum.ACCOUNTED.getValue().equals(transDynColl.getString("receredtype"))) continue;
            billIdSet.add(transDynColl.getLong("sourcebillid"));
        }
        return billIdSet;
    }

    public void checkIsPush(ExtendedDataEntity dataEntity) {
        String entityName = dataEntity.getDataEntity().getDataEntityType().getName();
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getBillPkId(), (String)entityName, (String)"entrys.subacct_company,entrys.iscashbill,entrys.isinneracccashbill,entrys.isifmbill,entrys.paystatus");
        DynamicObjectCollection entries = info.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entries) {
            DynamicObject subOrg;
            if (this.checkUnKnow(entry)) continue;
            boolean flag = false;
            if (!entry.getBoolean("iscashbill")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u94f6\u884c\u8d26\u53f7\u4ed8\u6b3e\u56de\u5355\u672a\u751f\u6210\uff0c\u65e0\u6cd5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransBillPayPushCasValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                flag = true;
            }
            if (SystemParameterHelper.isShowInternalAccount((long)(subOrg = entry.getDynamicObject("subacct_company")).getLong("id")) && TransBillHelper.isInnerAcctTrans((DynamicObject)dataEntity.getDataEntity())) {
                if (!entry.getBoolean("isinneracccashbill")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b50\u8d26\u6237\u5185\u90e8\u8d26\u53f7\u4ed8\u6b3e\u56de\u5355\u672a\u751f\u6210\uff0c\u65e0\u6cd5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransBillPayPushCasValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    flag = true;
                }
                if (!entry.getBoolean("isifmbill")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u91d1\u878d\u56de\u5355\u672a\u751f\u6210\uff0c\u65e0\u6cd5\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"TransBillPayPushCasValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    flag = true;
                }
            }
            if (!flag) continue;
            break;
        }
    }
}

