/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillDiscardDetailValidator
extends AbsTransBillValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("entrys");
        selector.add("paychanel");
        selector.add("paystatus");
        selector.add("state");
        selector.add("ischangepaych");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        String[] discardIndexs = this.getOption().getVariableValue("discardIndex").split(",");
        HashMap discardIndexMap = new HashMap(discardIndexs.length);
        for (String string : discardIndexs) {
            discardIndexMap.put(Integer.valueOf(string), null);
        }
        for (String string : dataEntitys) {
            DynamicObject curData = string.getDataEntity();
            DynamicObject dbTransBill = BusinessDataServiceHelper.loadSingle((Object)curData.getPkValue(), (String)curData.getDataEntityType().getName(), (String)"billstatus, ischangepaych, entrys.paystatus, entrys.state");
            Object billStatus = dbTransBill.get("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage((ExtendedDataEntity)string, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u975e\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillDiscardDetailValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (dbTransBill.getBoolean("ischangepaych")) {
                this.addErrorMessage((ExtendedDataEntity)string, ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillDiscardDetailValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection dbEntities = dbTransBill.getDynamicObjectCollection("entrys");
            int curIndx = 0;
            for (DynamicObject entity : dbEntities) {
                if (!discardIndexMap.containsKey(curIndx++)) continue;
                Object payStatus = entity.get("paystatus");
                Object state = entity.get("state");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state) || FcaTransDetailStatusEnum.DELETE.getValue().equals(state)) {
                    this.addErrorMessage((ExtendedDataEntity)string, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u72b6\u6001\u4e3a\u4ea4\u6613\u4f5c\u5e9f\u6216\u5220\u9664\u7684\u660e\u7ec6\u4e0d\u80fd\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillDiscardDetailValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
                    continue;
                }
                if (FcaTransPayStatusEnum.INIT.getValue().equals(payStatus) || FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus)) continue;
                this.addErrorMessage((ExtendedDataEntity)string, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001\u4e3a\u4ea4\u6613\u5931\u8d25\u6216\u7a7a\u624d\u80fd\u4f5c\u5e9f\u660e\u7ec6\u3002", (String)"TransBillDiscardDetailValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
        }
    }
}

