/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.helper.TransBillPushHelper;

public class TransBillPayPushCasValidator
extends AbsTransBillValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity transBill : dataEntity) {
            DynamicObject info = transBill.getDataEntity();
            String name = info.getDataEntityType().getName();
            if (!"fca_transupbill".equals(name) && !"fca_transdownbill".equals(name)) continue;
            if (!BillStatusEnum.PAYED.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u975e\u5df2\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"TransBillPayPushCasValidator_10", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entries = info.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean("iscashbill")) continue;
                this.addErrorMessage(transBill, ResManager.loadKDString((String)"\u5212\u62e8\u5355\u5df2\u751f\u6210\u4ed8\u6b3e\u56de\u5355\u3002", (String)"TransBillPayPushCasValidator_101", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
        }
    }
}

