/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.compare.BPlusTree;
import kd.tmc.fca.common.compare.CompareData;
import kd.tmc.fca.common.compare.CompareResult;
import kd.tmc.fca.common.compare.CompareServiceImpl;
import kd.tmc.fca.common.enums.FcaTransPayChanEnum;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.enums.FcaTransTypeEnum;
import kd.tmc.fca.common.enums.SymbolEnum;
import kd.tmc.fca.common.helper.CountryHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillPayValidator
extends AbsTransBillValidator {
    private static final Log LOGGER = LogFactory.getLog(TransBillPayValidator.class);
    private boolean isCommitbei = false;
    private FcaTransTypeEnum transType;

    public TransBillPayValidator() {
    }

    public TransBillPayValidator(Boolean isCommitbei) {
        this.isCommitbei = isCommitbei;
    }

    public TransBillPayValidator(Boolean isCommitbei, FcaTransTypeEnum fcaTransType) {
        this.isCommitbei = isCommitbei;
        this.transType = fcaTransType;
    }

    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        selector.add("entrys.entrycountry");
        selector.add("entrys.entryprovince");
        selector.add("entrys.entrycity");
        selector.add("country");
        selector.add("province");
        selector.add("city");
        return selector;
    }

    private Pair<Boolean, String> verrifyFinOrg(DynamicObject transBill) {
        Pair pair = Pair.of((Object)Boolean.TRUE, (Object)"");
        if (!this.isCommitbei) {
            return pair;
        }
        DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entries)) {
            List ids = entries.stream().map(v -> v.getDynamicObject("subacct").getPkValue()).distinct().collect(Collectors.toList());
            DynamicObject[] accts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"number,bank", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> errorMap = new HashMap<String, String>(accts.length);
            HashMap<String, String> errMap = new HashMap<String, String>(accts.length);
            if (FcaTransTypeEnum.TRANSDOWN == this.transType) {
                for (DynamicObject dynamicObject : entries) {
                    boolean isChinaMainland;
                    String payChanel = dynamicObject.getString("paychanel");
                    DynamicObject subAcct = dynamicObject.getDynamicObject("subacct");
                    if (!FcaTransPayChanEnum.BEI.getValue().equals(payChanel)) continue;
                    DynamicObject entryCountry = dynamicObject.getDynamicObject("entrycountry");
                    String entryProvinceTxt = dynamicObject.getString("entryprovince");
                    String entryCityTxt = dynamicObject.getString("entrycity");
                    ArrayList<String> errMessageList = new ArrayList<String>(3);
                    if (entryCountry == null) {
                        errMessageList.add(ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a\u4fe1\u606f", (String)"TransBillPayValidator_6", (String)"tmc-fca-business", (Object[])new Object[0]));
                    }
                    if (isChinaMainland = CountryHelper.isChina((DynamicObject)entryCountry)) {
                        if (EmptyUtil.isEmpty((String)entryProvinceTxt)) {
                            errMessageList.add(ResManager.loadKDString((String)"\u7701\u4efd\u4fe1\u606f", (String)"TransBillPayValidator_7", (String)"tmc-fca-business", (Object[])new Object[0]));
                        }
                        if (EmptyUtil.isEmpty((String)entryCityTxt)) {
                            errMessageList.add(ResManager.loadKDString((String)"\u57ce\u5e02\u4fe1\u606f", (String)"TransBillPayValidator_8", (String)"tmc-fca-business", (Object[])new Object[0]));
                        }
                    }
                    if (errMessageList.isEmpty()) continue;
                    errorMap.put(subAcct.getString("number"), String.join((CharSequence)"\u3001", errMessageList));
                }
                for (Map.Entry entry : errorMap.entrySet()) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u3010%1$s\u3011\u7684\u5f00\u6237\u884c\u7f3a\u5c11\u3010%2$s\u3011\uff0c\u8bf7\u5148\u5b8c\u5584\u201c\u5408\u4f5c\u91d1\u878d\u673a\u6784\u201d\u57fa\u7840\u8d44\u6599\u3002", (String)"TransBillPayValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]), entry.getKey(), entry.getValue()));
                }
            }
            for (DynamicObject acct : accts) {
                DynamicObject finOrg = acct.getDynamicObject("bank");
                ArrayList<String> errMsgs = new ArrayList<String>();
                if (FcaTransTypeEnum.TRANSDOWN == this.transType) {
                    this.checkSubBankAccount(finOrg, errMsgs);
                }
                if (errMsgs.isEmpty()) continue;
                errMap.put(acct.getString("number"), String.join((CharSequence)"\u3001", errMsgs));
            }
            for (Map.Entry entry : errMap.entrySet()) {
                sb.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u3010%1$s\u3011\u7684\u5f00\u6237\u884c\u7f3a\u5c11\u3010%2$s\u3011\uff0c\u8bf7\u5148\u5b8c\u5584\u201c\u5408\u4f5c\u91d1\u878d\u673a\u6784\u201d\u57fa\u7840\u8d44\u6599\u3002", (String)"TransBillPayValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]), entry.getKey(), entry.getValue()));
            }
            if (sb.length() > 0) {
                pair = Pair.of((Object)Boolean.FALSE, (Object)sb.toString());
            }
        }
        return pair;
    }

    private void checkSubBankAccount(DynamicObject finOrg, List<String> errMsgs) {
        if (StringUtils.isEmpty((CharSequence)finOrg.getString("union_number"))) {
            errMsgs.add(ResManager.loadKDString((String)"\u8054\u884c\u53f7", (String)"TransBillPayValidator_5", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        if (finOrg.get("bebank") == null) {
            errMsgs.add(ResManager.loadKDString((String)"\u884c\u540d\u884c\u53f7", (String)"TransBillPayValidator_9", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        LOGGER.info("\u4ed8\u6b3e\u6821\u9a8c\u5f00\u59cb");
        if ("true".equals(this.getOption().getVariableValue("byAutoTrans", "false"))) {
            return;
        }
        BillEntityType billEntityType = (BillEntityType)dataEntity[0].getDataEntity().getDataEntityType();
        String entityName = billEntityType.getName();
        Map<ExtendedDataEntity, Pair<Boolean, String>> validateEntryRule = this.validateEntryRule(dataEntity);
        List<Long> eSourceBillEntryIdList = Arrays.stream(dataEntity).filter(d -> FcaTransSourceTypeEnum.GENERATE.getValue().equals(d.getDataEntity().getString("sourcetype")) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(d.getDataEntity().getString("sourcetype"))).map(d -> d.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("e_sourcebillentryid"))).map(d -> d.getLong("e_sourcebillentryid"))).collect(Collectors.toList());
        BPlusTree<Long, CompareData> sourceTree = this.buildSourceTree(entityName, eSourceBillEntryIdList);
        BPlusTree<Long, CompareData> targetTree = this.buildTargetTree(dataEntity);
        CompareServiceImpl compareService = new CompareServiceImpl(sourceTree, targetTree);
        BPlusTree resultTree = compareService.invoke();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Pair<Boolean, String> pairPay;
            Pair<Boolean, String> pair;
            DynamicObject transBill = extendedDataEntity.getDataEntity();
            String sourceType = transBill.getString("sourcetype");
            DynamicObject accountGroup = transBill.getDynamicObject("acctgrpid");
            if (!accountGroup.getBoolean("enable")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u5b50\u7ec4\u5df2\u7ecf\u7981\u7528\u3002", (String)"TransBillPayValidator_16", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject accountBank = transBill.getDynamicObject("accountbank");
            boolean isCheck = this.validateAccountStatus(extendedDataEntity, accountBank, null);
            if (!isCheck) continue;
            if (FcaTransTypeEnum.TRANSUP == this.transType) {
                this.checkMonBankAccount(extendedDataEntity, transBill);
            }
            if (!((Boolean)(pair = this.verrifyFinOrg(transBill)).getLeft()).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, (String)pair.getRight());
                continue;
            }
            DynamicObject dbTransBill = TmcDataServiceHelper.loadSingle((Object)transBill.getPkValue(), (String)transBill.getDataEntityType().getName());
            Object billStatus = dbTransBill.get("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u4ed8\u6b3e\u3002", (String)"TransBillPayValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            String ischangepaych = dbTransBill.getString("ischangepaych");
            if ("true".equals(ischangepaych)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\uff0c\u65e0\u6cd5\u4ed8\u6b3e\u3002", (String)"TransBillPayValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            if (validateEntryRule != null && (pairPay = validateEntryRule.get(extendedDataEntity)) != null && !((Boolean)pairPay.getLeft()).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, (String)pairPay.getRight());
                continue;
            }
            boolean isValid = this.validPayChanel(extendedDataEntity, super.getOperateKey());
            if (!isValid) continue;
            DynamicObject payFlag = extendedDataEntity.getDataEntity().getDynamicObject("payflag");
            if (this.isCommitbei && payFlag != null && "1".equals(payFlag.getString("type"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_15", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if (FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) {
                Long sourceBillId = transBill.getLong("sourcebillid");
                for (CompareResult compareResult : resultTree.search((Comparable)sourceBillId)) {
                    String message;
                    String fieldName;
                    if (!Objects.equals(transBill.getPkValue(), compareResult.getId())) continue;
                    if (compareResult.isCheckSource()) {
                        fieldName = ((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getSourceEntityName(entityName)).getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                        message = String.format(ResManager.loadKDString((String)"\u6e90\u5355%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                        this.addErrorMessage(extendedDataEntity, message);
                        continue;
                    }
                    fieldName = ((IDataEntityProperty)billEntityType.getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                    message = String.format(ResManager.loadKDString((String)"%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                    this.addErrorMessage(extendedDataEntity, message);
                }
            }
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                Long sourceBillEntryId = entry.getLong("e_sourcebillentryid");
                DynamicObject subAcct = entry.getDynamicObject("subacct");
                this.validateAccountStatus(extendedDataEntity, null, subAcct);
                if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) continue;
                for (CompareResult compareResult : resultTree.search((Comparable)sourceBillEntryId)) {
                    if (!Objects.equals(entry.getPkValue(), compareResult.getId())) continue;
                    String fieldName = ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                    String message = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%1$d\u6761%2$s\u5fc5\u987b%3$s%4$s\u3002", (String)"CompareValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1, fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                    this.addErrorMessage(extendedDataEntity, message);
                }
            }
        }
    }

    private void checkMonBankAccount(ExtendedDataEntity extendedDataEntity, DynamicObject transBill) {
        DynamicObject accountBank;
        DynamicObject headCountry = transBill.getDynamicObject("country");
        String provinceTxt = transBill.getString("province");
        String cityTxt = transBill.getString("city");
        boolean isChinaMainland = CountryHelper.isChina((DynamicObject)headCountry);
        if (headCountry == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u5f00\u6237\u884c\u56fd\u5bb6\u5730\u533a\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_12", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
        if (isChinaMainland) {
            if (EmptyUtil.isEmpty((String)provinceTxt)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u5f00\u6237\u884c\u7701\u4efd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_13", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)cityTxt)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u5f00\u6237\u884c\u57ce\u5e02\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_14", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
        }
        if (!Objects.isNull(accountBank = transBill.getDynamicObject("accountbank"))) {
            DynamicObject bank = accountBank.getDynamicObject("bank");
            DynamicObject finOrg = BusinessDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)String.join((CharSequence)",", "union_number", "country", "province", "city", "bebank"), (QFilter[])new QFilter("id", "=", bank.getPkValue()).toArray());
            if (finOrg.getDynamicObject("bebank") == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u5f00\u6237\u884c\u884c\u540d\u884c\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_10", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)finOrg.getString("union_number"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\u5f00\u6237\u884c\u8054\u884c\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"TransBillPayValidator_11", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
        }
    }

    private boolean validateAccountStatus(ExtendedDataEntity data, DynamicObject pAccount, DynamicObject subAccount) {
        boolean isCheck = true;
        String entityName = data.getDataEntity().getDataEntityType().getName();
        if (pAccount != null) {
            String pAccountStatus = pAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                isCheck = false;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_23", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_transdownbill", (CharSequence)entityName)) {
                isCheck = false;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_24", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
        }
        if (subAccount != null) {
            String subAccountStatus = subAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                isCheck = false;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_25", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_transupbill", (CharSequence)entityName)) {
                isCheck = false;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_26", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
        }
        return isCheck;
    }

    private String getSourceEntityName(String entityName) {
        if ("fca_transupbill".equals(entityName)) {
            return "fca_applytransupbill";
        }
        return "fca_applytransdownbill";
    }

    private BPlusTree<Long, CompareData> buildSourceTree(String entityName, List<Long> eSourceBillEntryIdList) {
        BPlusTree sourceTree = new BPlusTree();
        if (!eSourceBillEntryIdList.isEmpty()) {
            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)this.getSourceEntityName(entityName), (String)"id, currency, currency.amtprecision, billstatus, currency.name, entrys.id, entrys.transamt", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", eSourceBillEntryIdList)});
            for (DynamicObject sourceBill : sourceBills) {
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("billstatus", (Object)sourceBill.getString("billstatus")));
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("currency", (Object)sourceBill.getLong("currency"), (Object)sourceBill.getString("currency.name")));
                BigDecimal sourceAmount = sourceBill.getBigDecimal("entrys.transamt").setScale(sourceBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP);
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("entrys.id")), (Object)new CompareData("transamt", (Object)sourceBill.getBigDecimal("entrys.transamt"), (Object)sourceAmount));
            }
        }
        return sourceTree;
    }

    private BPlusTree<Long, CompareData> buildTargetTree(ExtendedDataEntity[] dataEntity) {
        BPlusTree targetTree = new BPlusTree();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObject currency = bill.getDynamicObject("currency");
            Object currencyId = currency == null ? null : currency.getPkValue();
            String sourceType = bill.getString("sourcetype");
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) && !FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Long)bill.getLong("sourcebillid"))) {
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "billstatus", (Object)BillStatusEnum.AUDIT.getValue(), (Object)BillStatusEnum.AUDIT.getName(), true));
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "currency", currencyId, SymbolEnum.EQUALS));
            }
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) continue;
            for (DynamicObject entry : entries) {
                if (!EmptyUtil.isNoEmpty((Long)entry.getLong("e_sourcebillentryid"))) continue;
                targetTree.insert((Comparable)Long.valueOf(entry.getLong("e_sourcebillentryid")), (Object)new CompareData(entry.getPkValue(), "transamt", (Object)entry.getBigDecimal("transamt"), SymbolEnum.LESS_EQUALS));
            }
        }
        return targetTree;
    }
}

