/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.business.validate.transbill.AbsTransBillValidator;
import kd.tmc.fca.common.compare.BPlusTree;
import kd.tmc.fca.common.compare.CompareData;
import kd.tmc.fca.common.compare.CompareResult;
import kd.tmc.fca.common.compare.CompareServiceImpl;
import kd.tmc.fca.common.enums.FcaTransSourceTypeEnum;
import kd.tmc.fca.common.enums.SymbolEnum;
import kd.tmc.fca.common.helper.CountryHelper;
import kd.tmc.fca.common.helper.TransBillPushHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TransBillSubmitValidator
extends AbsTransBillValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.addAll(TransBillPushHelper.buildSelectors());
        selector.add("sourcetype");
        selector.add("sourcebillid");
        selector.add("entrys.e_sourcebillentryid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<ExtendedDataEntity, Pair<Boolean, String>> validateEntryRule = this.validateEntryRule(dataEntity);
        Set<Long> orgIds = this.getAllOrgIds(dataEntity);
        Set<Long> orgIsInnit = this.getAllOrgIsInnit(orgIds);
        Map<Long, Boolean> stringBooleanMap = this.loadBatchAppParameterByOrg(orgIds);
        BillEntityType billEntityType = (BillEntityType)dataEntity[0].getDataEntity().getDataEntityType();
        String entityName = billEntityType.getName();
        List<Long> eSourceBillEntryIdList = Arrays.stream(dataEntity).filter(d -> FcaTransSourceTypeEnum.GENERATE.getValue().equals(d.getDataEntity().getString("sourcetype")) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(d.getDataEntity().getString("sourcetype"))).map(d -> d.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(e -> e.stream().filter(d -> EmptyUtil.isNoEmpty((Long)d.getLong("e_sourcebillentryid"))).map(d -> d.getLong("e_sourcebillentryid"))).collect(Collectors.toList());
        List<Long> idList = Arrays.stream(dataEntity).filter(d -> FcaTransSourceTypeEnum.GENERATE.getValue().equals(d.getDataEntity().getString("sourcetype")) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(d.getDataEntity().getString("sourcetype"))).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        List<Long> existsEntryIdList = this.repeatCheck(idList, eSourceBillEntryIdList, entityName);
        BPlusTree<Long, CompareData> sourceTree = this.buildSourceTree(entityName, eSourceBillEntryIdList);
        BPlusTree<Long, CompareData> targetTree = this.buildTargetTree(dataEntity);
        CompareServiceImpl compareService = new CompareServiceImpl(sourceTree, targetTree);
        BPlusTree resultTree = compareService.invoke();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Pair<Boolean, String> pair;
            DynamicObject data = extendedDataEntity.getDataEntity();
            Object billStatus = data.get("billstatus");
            String sourceType = data.getString("sourcetype");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u5355\u636e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"TransBillSubmitValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject accountGroup = data.getDynamicObject("acctgrpid");
            if (accountGroup != null && !accountGroup.getBoolean("enable")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6bcd\u5b50\u7ec4\u5df2\u7ecf\u7981\u7528\u3002", (String)"TransBillSubmitValidator_3", (String)"tmc-fca-business", (Object[])new Object[0]));
            }
            DynamicObject company = data.getDynamicObject("company");
            Long companyId = (Long)company.getPkValue();
            DynamicObject accountBank = data.getDynamicObject("accountbank");
            this.validateAccountStatus(extendedDataEntity, accountBank, null);
            if (validateEntryRule != null && (pair = validateEntryRule.get(extendedDataEntity)) != null && !((Boolean)pair.getLeft()).booleanValue()) {
                this.addErrorMessage(extendedDataEntity, (String)pair.getRight());
                continue;
            }
            if (stringBooleanMap.get(companyId).booleanValue() && (CollectionUtils.isEmpty(orgIsInnit) || !orgIsInnit.contains(companyId))) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u3010%1$s\u3011\u7684\u7533\u8bf7\u516c\u53f8\u3010%2$s\u3011\u521d\u59cb\u5316\u3002", (String)"TransBillSubmitValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), accountBank.get("number"), company.get("name")));
                continue;
            }
            if (FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) || FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) {
                Long sourceBillId = data.getLong("sourcebillid");
                for (CompareResult compareResult : resultTree.search((Comparable)sourceBillId)) {
                    String message;
                    String fieldName;
                    if (!Objects.equals(data.getPkValue(), compareResult.getId())) continue;
                    if (compareResult.isCheckSource()) {
                        fieldName = ((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)this.getSourceEntityName(entityName)).getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                        message = String.format(ResManager.loadKDString((String)"\u6e90\u5355%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                        this.addErrorMessage(extendedDataEntity, message);
                        continue;
                    }
                    fieldName = ((IDataEntityProperty)billEntityType.getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                    message = String.format(ResManager.loadKDString((String)"%1$s\u5fc5\u987b%2$s%3$s\u3002", (String)"CompareValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]), fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                    this.addErrorMessage(extendedDataEntity, message);
                }
            }
            boolean existBei = Boolean.FALSE;
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                Long sourceBillEntryId = entry.getLong("e_sourcebillentryid");
                if (existsEntryIdList.contains(sourceBillEntryId)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%1$d\u6761\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CompareValidator_4", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObject subAcct = entry.getDynamicObject("subacct");
                this.validateAccountStatus(extendedDataEntity, null, subAcct);
                DynamicObject subAcctCompany = entry.getDynamicObject("subacct_company");
                if (EmptyUtil.isEmpty((DynamicObject)subAcctCompany)) continue;
                Long subAcctCompanyId = (Long)subAcctCompany.getPkValue();
                if (stringBooleanMap.get(subAcctCompanyId).booleanValue() && (CollectionUtils.isEmpty(orgIsInnit) || !orgIsInnit.contains(subAcctCompanyId))) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u3010%1$s\u3011\u7684\u7533\u8bf7\u516c\u53f8\u3010%2$s\u3011\u521d\u59cb\u5316\u3002", (String)"TransBillSubmitValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), subAcct.get("number"), subAcctCompany.get("name")));
                    continue;
                }
                String payChanel = entry.getString("paychanel");
                if ("bei".equalsIgnoreCase(payChanel)) {
                    String usage;
                    existBei = Boolean.TRUE;
                    DynamicObject entryCountry = entry.getDynamicObject("entrycountry");
                    String entryProvinceTxt = entry.getString("entryprovince");
                    String entryCityTxt = entry.getString("entrycity");
                    String entryAcctNumber = subAcct.getString("bankaccountnumber");
                    this.checkRecBankInfo(extendedDataEntity, entryAcctNumber, entryCountry, entryProvinceTxt, entryCityTxt);
                    DynamicObject payflag = data.getDynamicObject("payflag");
                    if (payflag != null && "0".equals(payflag.getString("type")) && ((usage = entry.getString("usage")) == null || "".equals(usage))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u7684\u4e3b\u52a8\u4ed8\u6b3e\uff0c\u8f6c\u8d26\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransBillSubmitValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]));
                    }
                }
                if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) continue;
                for (CompareResult compareResult : resultTree.search((Comparable)sourceBillEntryId)) {
                    if (!Objects.equals(entry.getPkValue(), compareResult.getId())) continue;
                    String fieldName = ((IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)compareResult.getFieldKey())).getDisplayName().getLocaleValue();
                    String message = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%1$d\u6761%2$s\u5fc5\u987b%3$s%4$s\u3002", (String)"CompareValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]), i + 1, fieldName, compareResult.getSymbolEnum().getName(), compareResult.getDisplayName());
                    this.addErrorMessage(extendedDataEntity, message);
                }
            }
            if (existBei) {
                DynamicObject headCountry = data.getDynamicObject("country");
                String provinceTxt = data.getString("province");
                String cityTxt = data.getString("city");
                this.checkRecBankInfo(extendedDataEntity, accountBank.getString("number"), headCountry, provinceTxt, cityTxt);
            }
            this.validateDownIntelSourceType(data, extendedDataEntity);
            this.validateUpIntelSourceType(data, extendedDataEntity);
        }
    }

    private BPlusTree<Long, CompareData> buildSourceTree(String entityName, List<Long> eSourceBillEntryIdList) {
        BPlusTree sourceTree = new BPlusTree();
        if (!eSourceBillEntryIdList.isEmpty()) {
            DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)this.getSourceEntityName(entityName), (String)"id, currency, currency.amtprecision, billstatus, currency.name, entrys.id, entrys.transamt", (QFilter[])new QFilter[]{new QFilter("entrys.id", "in", eSourceBillEntryIdList)});
            for (DynamicObject sourceBill : sourceBills) {
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("billstatus", (Object)sourceBill.getString("billstatus")));
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("id")), (Object)new CompareData("currency", (Object)sourceBill.getLong("currency"), (Object)sourceBill.getString("currency.name")));
                BigDecimal sourceAmount = sourceBill.getBigDecimal("entrys.transamt").setScale(sourceBill.getInt("currency.amtprecision"), RoundingMode.HALF_UP);
                sourceTree.insert((Comparable)Long.valueOf(sourceBill.getLong("entrys.id")), (Object)new CompareData("transamt", (Object)sourceBill.getBigDecimal("entrys.transamt"), (Object)sourceAmount));
            }
        }
        return sourceTree;
    }

    private BPlusTree<Long, CompareData> buildTargetTree(ExtendedDataEntity[] dataEntity) {
        BPlusTree targetTree = new BPlusTree();
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObject currency = bill.getDynamicObject("currency");
            Object currencyId = currency == null ? null : currency.getPkValue();
            String sourceType = bill.getString("sourcetype");
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType) && !FcaTransSourceTypeEnum.ROUNDINGAMOUNT.getValue().equals(sourceType)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((Long)bill.getLong("sourcebillid"))) {
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "billstatus", (Object)BillStatusEnum.AUDIT.getValue(), (Object)BillStatusEnum.AUDIT.getName(), true));
                targetTree.insert((Comparable)Long.valueOf(bill.getLong("sourcebillid")), (Object)new CompareData(bill.getPkValue(), "currency", currencyId, SymbolEnum.EQUALS));
            }
            if (!FcaTransSourceTypeEnum.GENERATE.getValue().equals(sourceType)) continue;
            for (DynamicObject entry : entries) {
                if (!EmptyUtil.isNoEmpty((Long)entry.getLong("e_sourcebillentryid"))) continue;
                targetTree.insert((Comparable)Long.valueOf(entry.getLong("e_sourcebillentryid")), (Object)new CompareData(entry.getPkValue(), "transamt", (Object)entry.getBigDecimal("transamt"), SymbolEnum.LESS_EQUALS));
            }
        }
        return targetTree;
    }

    private void validateDownIntelSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String meteName = info.getDynamicObjectType().getName();
        String sourceBillType = info.getString("sourcetype");
        DynamicObject paymentEntity = info.getDynamicObject("payflag");
        if (!"fca_transdownbill".equals(meteName) || !"paypassive".equals(sourceBillType) || paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u5165\u8d26\u4e0b\u63a8\u751f\u6210\u7684\u4e0b\u62e8\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u4e0b\u62e8\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8", (String)"AbsTransBillValidator_27", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    private void validateUpIntelSourceType(DynamicObject info, ExtendedDataEntity dataEntity) {
        String meteName = info.getDynamicObjectType().getName();
        String sourceBillType = info.getString("sourcetype");
        DynamicObject paymentEntity = info.getDynamicObject("payflag");
        if (!"fca_transupbill".equals(meteName) || !"recinitiative".equals(sourceBillType) || paymentEntity == null) {
            return;
        }
        String type = paymentEntity.getString("type");
        if (!"1".equals(type)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u4e0b\u63a8\u751f\u6210\u7684\u4e0a\u5212\u5355\uff0c\u5c5e\u5df2\u53d1\u751f\u7684\u4e0a\u5212\u4e1a\u52a1\uff0c\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u5fc5\u987b\u7f6e\u4e3a\u88ab\u52a8\uff0c\u4ee5\u514d\u91cd\u590d\u652f\u4ed8", (String)"AbsTransBillValidator_28", (String)"tmc-fca-business", (Object[])new Object[0]));
        }
    }

    private void validateAccountStatus(ExtendedDataEntity data, DynamicObject pAccount, DynamicObject subAccount) {
        String entityName = data.getDataEntity().getDataEntityType().getName();
        if (pAccount != null) {
            String pAccountStatus = pAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_23", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)pAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_transdownbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6bcd\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_24", (String)"tmc-fca-business", (Object[])new Object[0]), pAccount.getString("bankaccountnumber")));
            }
        }
        if (subAccount != null) {
            String subAccountStatus = subAccount.getString("acctstatus");
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.CLOSED.getValue())) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_25", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
            if (StringUtils.equals((CharSequence)subAccountStatus, (CharSequence)BankAcctStatusEnum.FREEZE.getValue()) && StringUtils.equals((CharSequence)"fca_transupbill", (CharSequence)entityName)) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b50\u8d26\u6237\uff08%1s\uff09\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AbsTransBillValidator_26", (String)"tmc-fca-business", (Object[])new Object[0]), subAccount.getString("bankaccountnumber")));
            }
        }
    }

    private void checkRecBankInfo(ExtendedDataEntity data, String bankAcctNumber, DynamicObject country, String provinceTxt, String cityTxt) {
        boolean isChinaMainland;
        if (country == null) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u94f6\u884c\u8d26\u6237\uff08%1$s\uff09\u5bf9\u5e94\u94f6\u884c\u7684\u56fd\u5bb6\u5730\u533a\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u7ef4\u62a4\u4e4b\u540e\u91cd\u65b0\u9009\u62e9\u3002", (String)"TransBillSubmitValidatorErr_1", (String)"tmc-fca-business", (Object[])new Object[0]), bankAcctNumber));
        }
        if ((isChinaMainland = CountryHelper.isChina((DynamicObject)country)) && (EmptyUtil.isEmpty((String)provinceTxt) || EmptyUtil.isEmpty((String)cityTxt))) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u94f6\u884c\u8d26\u6237\uff08%1$s\uff09\u5bf9\u5e94\u94f6\u884c\u7684\u7701\u4efd\uff08\u94f6\u4f01\uff09\u3001\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u7ef4\u62a4\u4e4b\u540e\u91cd\u65b0\u9009\u62e9\u3002", (String)"TransBillSubmitValidatorErr_0", (String)"tmc-fca-business", (Object[])new Object[0]), bankAcctNumber));
        }
    }

    private String getSourceEntityName(String entityName) {
        if ("fca_transupbill".equals(entityName)) {
            return "fca_applytransupbill";
        }
        return "fca_applytransdownbill";
    }

    private List<Long> repeatCheck(List<Long> idList, List<Long> entryIdList, String entityName) {
        QFilter filter = new QFilter("id", "not in", idList);
        filter.and(new QFilter("entrys.e_sourcebillentryid", "in", entryIdList));
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)entityName, (String)"entrys.e_sourcebillentryid", (QFilter[])filter.toArray());
        return applyBills.stream().map(b -> b.getLong("entrys.e_sourcebillentryid")).collect(Collectors.toList());
    }
}

