/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;

public class TransBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("paychanel");
        selector.add("ischangepaych");
        selector.add("paystatus");
        selector.add("state");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        block0: for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            String ischangepaych = data.getString("ischangepaych");
            if ("true".equals(ischangepaych)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u53d8\u66f4\u652f\u4ed8\u6e20\u9053\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"TransBillUnAuditValidator_0", (String)"tmc-fca-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject transBill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                String payStatus = entry.getString("paystatus");
                String state = entry.getString("state");
                if (FcaTransPayStatusEnum.PAYFAIL.getValue().equals(payStatus) && FcaTransDetailStatusEnum.NORMAL.getValue().equals(state)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7%s\u7684\u5355\u636e\u4e2d\u5b58\u5728\u652f\u4ed8\u5931\u8d25\u4e14\u672a\u6253\u56de\u7684\u660e\u7ec6\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"TransBillUnAuditValidator_1", (String)"tmc-fca-business", (Object[])new Object[0]), data.getString("billno")));
                    continue block0;
                }
                if (!FcaTransPayStatusEnum.PAYSUCCESS.getValue().equals(payStatus)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7%s\u7684\u5355\u636e\u4e2d\u5b58\u5728\u4ed8\u6b3e\u6210\u529f\u7684\u660e\u7ec6\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"TransBillUnAuditValidator_2", (String)"tmc-fca-business", (Object[])new Object[0]), data.getString("billno")));
                continue block0;
            }
        }
    }
}

