/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.business.validate.transtrategy;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fca.common.enums.FcaDownWayEnum;
import kd.tmc.fca.common.enums.FcaUpWayEnum;
import kd.tmc.fca.common.errorcode.ErrorCodeUtils;
import kd.tmc.fca.common.errorcode.TransErrorCode;
import kd.tmc.fca.common.exception.FcaException;
import kd.tmc.fca.common.util.String2DecUtil;

public class TranStrategySaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            FcaException fcaException;
            boolean isExists;
            DynamicObject entities = dataEntity.getDataEntity();
            StringBuilder s = new StringBuilder();
            QFilter qFilter = new QFilter("number", "=", (Object)dataEntity.getBillNo());
            if (dataEntity.getBillPkId() != null) {
                qFilter.and("id", "<>", dataEntity.getBillPkId());
            }
            if (isExists = QueryServiceHelper.exists((String)"fca_transtrategy", (QFilter[])new QFilter[]{qFilter})) {
                fcaException = new FcaException(new TransErrorCode().EXISTNUMBER());
                s = s.append(fcaException.getMessage()).append('\n');
            }
            if (!entities.getBoolean("istransup") && !entities.getBoolean("istransdown")) {
                fcaException = new FcaException(new TransErrorCode().MUSTWRITEUPANDDOWN());
                s = s.append(fcaException.getMessage()).append('\n');
            }
            if (entities.getBoolean("istransup")) {
                if (BigDecimal.ZERO.compareTo(String2DecUtil.string2Dec((String)entities.getString("transupint"))) < 0 && entities.getBoolean("istransup") && !FcaUpWayEnum.ISUPQUOTA.getValue().equals(entities.getString("upway")) && entities.getBigDecimal("minupamt").compareTo(String2DecUtil.string2Dec((String)entities.getString("transupint"))) < 0) {
                    fcaException = new FcaException(new TransErrorCode().MUSTUPCOMPARE());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (EmptyUtil.isEmpty((Object)entities.get("upway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITEUPWAY());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)entities.get("upquotaamt")) >= 0 && FcaUpWayEnum.ISUPQUOTA.getValue().equals(entities.get("upway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITEUPQUOTAAMT());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)entities.get("transupscale")) == 0 && FcaUpWayEnum.ISSCALE.getValue().equals(entities.get("upway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITETRANSUPSCALE());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)entities.get("safetyamt")) >= 0 && FcaUpWayEnum.ISSAFETY.getValue().equals(entities.get("upway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITESAFETYAMT());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
            }
            if (entities.getBoolean("istransdown")) {
                if (BigDecimal.ZERO.compareTo(String2DecUtil.string2Dec((String)entities.getString("transdownint"))) < 0 && entities.getBoolean("istransdown") && FcaDownWayEnum.ISPOLISH.getValue().equals(entities.getString("downway")) && entities.getBigDecimal("mindownamt").compareTo(String2DecUtil.string2Dec((String)entities.getString("transdownint"))) < 0) {
                    fcaException = new FcaException(new TransErrorCode().MUSTDOWNCOMPARE());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (entities.getBoolean("istransdown") && StringUtils.isBlank((Object)entities.get("downway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITEDOWNWAY());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)entities.get("downquotaamt")) >= 0 && FcaDownWayEnum.ISDOWNQUOTA.getValue().equals(entities.get("downway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITEDOWNQUOTAAMT());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)entities.get("solidbal")) >= 0 && FcaDownWayEnum.ISPOLISH.getValue().equals(entities.get("downway"))) {
                    fcaException = new FcaException(new TransErrorCode().MUSTWRITESOLIDBALANCE());
                    s = s.append(fcaException.getMessage()).append('\n');
                }
            }
            if (s.length() == 0) continue;
            ErrorCode allException = ErrorCodeUtils.create((String)"ALLEXCEPTION", (String)s.toString());
            this.addErrorMessage(dataEntity, allException.getMessage());
        }
    }
}

