/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.opplugin.transbill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogPayBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.TmcOperationServicePlugIn;
import kd.tmc.fca.business.ebservice.TransInfoFactory;
import kd.tmc.fca.business.opservice.transbill.observer.BillSyncInfoObservable;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.helper.TransBillPayStatusChangeHelper;
import kd.tmc.fca.common.property.DetailStatus;

public abstract class AbstractTransBillCommitBeOp
extends TmcOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AbstractTransBillCommitBeOp.class);
    private static PayLogger traceLogger = PayLogger.create(AbstractTransBillCommitBeOp.class);
    public Map<Long, Long> billIdsToPayBills = new LinkedHashMap<Long, Long>(16);
    public List<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();

    public abstract String getEntityName();

    public abstract String getEntityTable();

    public abstract String getBankEntityName();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> successList;
        super.beginOperationTransaction(e);
        List<DynamicObject> canDoBillList = this.getBillCanDoAndFillProp(e.getDataEntities());
        LinkedHashMap<Long, Long> bankBillIdsToBillIds = new LinkedHashMap<Long, Long>();
        List transInfoList = TransInfoFactory.createTransInfo(canDoBillList);
        List bankBills = TransInfoFactory.generateBankTransBill((String)this.getBankEntityName(), (List)transInfoList);
        TransInfoFactory.dealExPropValue((String)this.getEntityName(), canDoBillList, (List)bankBills);
        this.dealLog(canDoBillList, bankBills);
        bankBills.forEach(o -> bankBillIdsToBillIds.put(o.getLong("id"), o.getLong("sourcebillid")));
        OperationResult opResult = this.saveBankBill(bankBills);
        traceLogger.logBatch(new PayTraceLogPayBillBuilder(canDoBillList, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u94f6\u884c\u5355\u636e\u3002", (String)"AbstractTransBillCommitBeOp_1", (String)"tmc-fca-opplugin", (Object[])new Object[0]), SerializationUtils.toJsonString((Object)opResult), null).build());
        List successIdList = opResult.getSuccessPkIds();
        bankBillIdsToBillIds.entrySet().stream().filter(o -> successIdList.contains(o.getKey())).forEach(o -> this.billIdsToPayBills.put((Long)o.getValue(), (Long)o.getKey()));
        this.dealMsg_SaveBankBill(opResult, bankBillIdsToBillIds);
        if (canDoBillList.size() > 0 && (successList = canDoBillList.stream().filter(o -> this.billIdsToPayBills.containsKey(o.getLong("id"))).collect(Collectors.toList())).size() > 0) {
            SaveServiceHelper.save((DynamicObject[])successList.toArray(new DynamicObject[0]));
            traceLogger.logBatch(new PayTraceLogPayBillBuilder(successList, PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1\u5355\u636e\u3002", (String)"AbstractTransBillCommitBeOp_2", (String)"tmc-fca-opplugin", (Object[])new Object[0]), null, null).build());
        }
    }

    private void dealMsg_SaveBankBill(OperationResult opResult, Map<Long, Long> bankBillIdsToBillIds) {
        for (OperateErrorInfo errorInfo : opResult.getAllErrorInfo()) {
            OperateErrorInfo temp = new OperateErrorInfo();
            Long billPk = bankBillIdsToBillIds.get(errorInfo.getPkValue());
            temp.setPkValue((Object)billPk);
            temp.setMessage((String)this.operationResult.getBillNos().get(billPk) + "\uff1a" + errorInfo.getMessage());
            temp.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(temp);
        }
        if (this.errorInfos.size() == 0 && this.operationResult.getMessage() == null && opResult.getMessage() != null) {
            this.operationResult.setMessage(this.extractResultErrorMessage(opResult));
            if (opResult.getSuccessPkIds().size() <= 0) {
                this.operationResult.setSuccess(false);
            }
        }
    }

    private String extractResultErrorMessage(OperationResult opResult) {
        List opInfoList = opResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : opInfoList) {
            stringBuilder.append(info.getMessage());
        }
        if (EmptyUtil.isEmpty((String)stringBuilder.toString())) {
            stringBuilder.append(opResult.getMessage());
        }
        return stringBuilder.toString();
    }

    private void dealLog(List<DynamicObject> billList, List<DynamicObject> bankBillList) {
        PayTraceLogPayBillBuilder logBuilder = new PayTraceLogPayBillBuilder(billList.size());
        HashMap id_bankBill = new HashMap(bankBillList.size());
        bankBillList.forEach(o -> id_bankBill.put(o.getLong("sourcebillid"), o));
        billList.forEach(o -> logBuilder.addLog(o, SerializationUtils.toJsonString(id_bankBill.get(o.getLong("id"))), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.CREATE.getValue(), ResManager.loadKDString((String)"\u751f\u6210\u94f6\u884c\u5355\u636e\u3002", (String)"AbstractTransBillCommitBeOp_4", (String)"tmc-fca-opplugin", (Object[])new Object[0]), null));
        traceLogger.logBatch(logBuilder.build());
    }

    public List<DynamicObject> getBillCanDoAndFillProp(DynamicObject[] bills) {
        List billIds = Arrays.stream(bills).map(o -> o.getLong("id")).collect(Collectors.toList());
        bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()));
        this.dealDisCard(bills);
        List<Object> billCol = this.filterDiscardBillList(Arrays.asList(bills));
        List<Long> canDoIds = this.beforeGeneratePayBill(billCol.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        billCol = billCol.stream().filter(o -> canDoIds.contains(o.getLong("id"))).collect(Collectors.toList());
        List<DynamicObject> updateList = this.setBillStatus(billCol.toArray(new DynamicObject[0]));
        return updateList;
    }

    public void dealDisCard(DynamicObject[] dataEntities) {
        HashMap<String, DetailStatus> payDetailMap = new HashMap<String, DetailStatus>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                Object state = entry.get("state");
                if (!FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) continue;
                payDetailMap.put(String.valueOf(entry.getPkValue()), new DetailStatus(Boolean.TRUE.booleanValue(), entry.getString("discard_reason"), entry.getDynamicObject("discard_user"), entry.getDate("discard_time"), entry.getString("payreturninfo")));
            }
        }
        new BillSyncInfoObservable(Arrays.asList(dataEntities), payDetailMap).syncInfo();
    }

    private List<DynamicObject> filterDiscardBillList(List<DynamicObject> srcList) {
        List<DynamicObject> filteredList = srcList.stream().filter(o -> {
            boolean isAllDiscard = true;
            DynamicObjectCollection entries = o.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                Object state = entry.get("state");
                if (FcaTransDetailStatusEnum.DISCARD.getValue().equals(state)) continue;
                isAllDiscard = false;
                break;
            }
            return !isAllDiscard;
        }).collect(Collectors.toList());
        return filteredList;
    }

    public List<DynamicObject> setBillStatus(DynamicObject[] bills) {
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject transBill : bills) {
            transBill.set("isrepulsed", (Object)false);
            transBill.set("repulsedreason", (Object)"");
            DynamicObjectCollection entries = transBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entries) {
                if (!TransBillPayStatusChangeHelper.transBillDetailCanCommitBei((DynamicObject)entry)) continue;
                entry.set("payuser", (Object)RequestContext.get().getCurrUserId());
                entry.set("submitpaytime", (Object)new Date());
                entry.set("paystatus", (Object)FcaTransPayStatusEnum.BEIPROC.getValue());
                entry.set("state", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
            }
            transBill.set("billstatus", (Object)BillStatusEnum.PAYING.getValue());
            updateBills.add(transBill);
        }
        return updateBills;
    }

    public OperationResult saveBankBill(List<DynamicObject> bankBills) {
        OperationResult opResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("srcEntityNumber", this.getEntityName());
        try (TXHandle handle = TX.requiresNew();){
            try {
                opResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getBankEntityName(), (DynamicObject[])bankBills.toArray(new DynamicObject[0]), (OperateOption)option);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
        return opResult;
    }

    protected List<Long> beforeGeneratePayBill(List<Long> idList) {
        String sSQL = "Update " + this.getEntityTable() + " Set Fmodifytime = ? Where Fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and fbillstatus = ?";
        DB.executeBatch((DBRoute)new DBRoute("tmc"), (String)sSQL, Collections.singletonList(new Object[]{new Date(), BillStatusEnum.AUDIT.getValue()}));
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObjectCollection bankPay = QueryServiceHelper.query((String)this.getEntityName(), (String)"id,billstatus", (QFilter[])filter);
        ArrayList<Long> canDoIds = new ArrayList<Long>(10);
        for (DynamicObject info : bankPay) {
            if (info.getString("billstatus").equals(BillStatusEnum.AUDIT.getValue())) {
                canDoIds.add(info.getLong("id"));
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(ResManager.loadKDString((String)"\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"AbstractTransBillCommitBeOp_0", (String)"tmc-fca-opplugin", (Object[])new Object[0]));
            errorInfo.setPkValue((Object)info.getLong("id"));
            errorInfo.setLevel(ErrorLevel.FatalError);
            this.errorInfos.add(errorInfo);
        }
        return canDoIds;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        if (this.billIdsToPayBills.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)this.getBankEntityName()), (Object[])this.billIdsToPayBills.values().toArray(new Long[0]));
            }
            catch (Exception exception) {
                logger.error("commitbe rollback:delete bankbill fail");
                logger.error((Throwable)exception);
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.errorInfos.size() > 0) {
            ValidateResult vr = new ValidateResult();
            vr.setAllErrorInfo(this.errorInfos);
            if (this.operationResult.getValidateResult() != null && this.operationResult.getValidateResult().getValidateErrors() != null) {
                this.operationResult.getValidateResult().getValidateErrors().add(vr);
            }
        }
        List successPair = this.billIdsToPayBills.entrySet().stream().map(o -> {
            JSONObject result = new JSONObject();
            result.put("payBillId", o.getKey());
            result.put("bankBillId", o.getValue());
            return result;
        }).collect(Collectors.toList());
        e.getOperationResult().setSuccessPkIds(successPair);
    }
}

