/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fca.report.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.fca.common.enums.FcaTransDetailStatusEnum;
import kd.tmc.fca.common.enums.FcaTransPayStatusEnum;
import kd.tmc.fca.common.enums.StatisCycleEnum;

public class TransBillDetailReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String UP_SELECT = "bank.name as bank, company.name as parentorg, entrys.subacct_company.name as sonorg, entrys.inneracctbank.number as inneraccount, entrys.subacct.number as accountbank, entrys.paydate as paydate, currency, 'fca_transupbill' as biztype, entrys.transamt as upamount, null as downamount, billno, id";
    private static final String DOWN_SELECT = "bank.name as bank, company.name as parentorg, entrys.subacct_company.name as sonorg, entrys.inneracctbank.number as inneraccount, entrys.subacct.number as accountbank, entrys.paydate as paydate, currency, 'fca_transdownbill' as biztype, null as upamount, entrys.transamt as downamount, billno, id";
    private static final String ORDER_SELECT = "bank , company, entrys.paydate, id";

    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        String bizType = String.valueOf(paramMap.get("filter_biztype"));
        QFilter filter = this.initFilter(paramMap);
        DataSet dataSet = null;
        if (bizType.contains("fca_transupbill")) {
            dataSet = QueryServiceHelper.queryDataSet((String)"fca_transupbill", (String)"fca_transupbill", (String)UP_SELECT, (QFilter[])filter.toArray(), (String)ORDER_SELECT);
        }
        if (bizType.contains("fca_transdownbill")) {
            DataSet downDataSet = QueryServiceHelper.queryDataSet((String)"fca_transdownbill", (String)"fca_transdownbill", (String)DOWN_SELECT, (QFilter[])filter.toArray(), (String)ORDER_SELECT);
            dataSet = dataSet != null ? dataSet.union(downDataSet) : downDataSet;
        }
        return dataSet;
    }

    public List<String> groupFields() {
        ArrayList<String> groupFieldList = new ArrayList<String>(2);
        groupFieldList.add("bank");
        groupFieldList.add("parentorg");
        return groupFieldList;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFieldList = new ArrayList<String>(2);
        sumFieldList.add("upamount_report");
        sumFieldList.add("downamount_report");
        return sumFieldList;
    }

    public String sumNameField() {
        return "sonorg";
    }

    public List<String> orinalAmountField() {
        ArrayList<String> sumFieldList = new ArrayList<String>(2);
        sumFieldList.add("upamount");
        sumFieldList.add("downamount");
        return sumFieldList;
    }

    private QFilter initFilter(Map<String, Object> paramMap) {
        Date endDate;
        Date startDate;
        QFilter filter = new QFilter("entrys.state", "=", (Object)FcaTransDetailStatusEnum.NORMAL.getValue());
        filter.and(new QFilter("entrys.paystatus", "=", (Object)FcaTransPayStatusEnum.PAYSUCCESS.getValue()));
        if (paramMap.get("filter_bank") != null) {
            DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get("filter_bank");
            List bankIdList = banks.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            filter.and("bank", "in", bankIdList);
        }
        if (paramMap.get("filter_org") != null) {
            filter.and("company", "in", paramMap.get("filter_org"));
        }
        if (paramMap.get("filter_sonorg") != null) {
            filter.and("entrys.subacct_company", "in", paramMap.get("filter_sonorg"));
        }
        if (paramMap.get("filter_accountgroup") != null) {
            filter.and("acctgrpid", "in", paramMap.get("filter_accountgroup"));
        }
        if (paramMap.get("filter_currency") != null) {
            DynamicObjectCollection currencies = (DynamicObjectCollection)paramMap.get("filter_currency");
            List currencyIdList = currencies.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            filter.and("currency", "in", currencyIdList);
        }
        String filterPeriod = (String)paramMap.get("filter_period");
        Date currDate = DateUtils.getCurrentDate();
        if (StringUtils.equals((CharSequence)StatisCycleEnum.THISMONTH.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTYEAR.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstYearDate((Date)DateUtils.getLastYear((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurYear();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.THISYEAR.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfCurYear();
            endDate = DateUtils.getFirstYearDate((Date)DateUtils.getNextYear((Date)currDate, (int)1));
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.LASTMONTH.getCode(), (CharSequence)filterPeriod)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getLastMonth((Date)currDate, (int)1));
            endDate = DateUtils.getFirstDayOfCurMonth();
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.TODAY.getCode(), (CharSequence)filterPeriod)) {
            startDate = currDate;
            endDate = DateUtils.getNextDay((Date)currDate, (int)1);
        } else if (StringUtils.equals((CharSequence)StatisCycleEnum.CONSTOM.getCode(), (CharSequence)filterPeriod)) {
            startDate = (Date)paramMap.get("filter_startdate");
            endDate = (Date)paramMap.get("filter_enddate");
            endDate = DateUtils.getNextDay((Date)endDate, (int)1);
        } else {
            startDate = DateUtils.getFirstDayOfCurMonth();
            endDate = DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        }
        filter.and("entrys.paydate", ">=", (Object)startDate);
        filter.and("entrys.paydate", "<", (Object)endDate);
        String queryAuth = (String)paramMap.get("filter_queryauth");
        if ("parentorg".equals(queryAuth)) {
            filter.and("company", "in", paramMap.get("orgIdList"));
        } else {
            filter.and("entrys.subacct_company", "in", paramMap.get("orgIdList"));
        }
        return filter;
    }
}

