/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fl.formplugin.contractbill;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fl.common.enums.ExecuteStatusEnum;
import kd.tmc.fl.formplugin.resource.FlFormResourceEnum;

public class LeaseContractInitEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "executestatus": {
                String result = this.executeStatusChgEvt();
                if (EmptyUtil.isNoEmpty((String)result)) {
                    this.getView().showTipNotification(result);
                }
                this.getModel().setValue("isinitplan", (Object)ExecuteStatusEnum.isExecuted((String)e.getChangeSet()[0].getNewValue().toString()), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "startdate": {
                this.initEndDate();
                break;
            }
        }
    }

    private void initEndDate() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        DateEdit endDate = (DateEdit)this.getControl("enddate");
        endDate.setMinDate(startDate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.propInit();
        this.initEndDate();
    }

    private void propInit() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"issyncdraw"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String result;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Arrays.asList("save", "submit", "audit").contains(operateKey) && EmptyUtil.isNoEmpty((String)(result = this.executeStatusChgEvt()))) {
            args.setCancel(true);
            this.getView().showTipNotification(result);
        }
    }

    private String executeStatusChgEvt() {
        String result = "";
        DynamicObjectCollection entryRentplan = this.getModel().getEntryEntity("entry_rentplan");
        int lastES = 0;
        for (int i = entryRentplan.size() - 1; i >= 0; --i) {
            DynamicObject plan = (DynamicObject)entryRentplan.get(i);
            if ("executed".equals(plan.getString("executestatus"))) {
                if (lastES > i) continue;
                lastES = i;
                continue;
            }
            if (lastES <= i) continue;
            result = String.format(FlFormResourceEnum.LeaseContractInitEdit_0.loadKDString(), DateUtils.formatString((Date)plan.getDate("paydate"), (String)"yyyy-MM-dd"));
        }
        return result;
    }
}

